// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/http.proto

package com.google.api;

/**
 * <pre>
 * `HttpRule` defines the mapping of an RPC method to one or more HTTP
 * REST APIs.  The mapping determines what portions of the request
 * message are populated from the path, query parameters, or body of
 * the HTTP request.  The mapping is typically specified as an
 * `google.api.http` annotation, see "google/api/annotations.proto"
 * for details.
 * The mapping consists of a field specifying the path template and
 * method kind.  The path template can refer to fields in the request
 * message, as in the example below which describes a REST GET
 * operation on a resource collection of messages:
 *     service Messaging {
 *       rpc GetMessage(GetMessageRequest) returns (Message) {
 *         option (google.api.http).get = "/v1/messages/{message_id}/{sub.subfield}";
 *       }
 *     }
 *     message GetMessageRequest {
 *       message SubMessage {
 *         string subfield = 1;
 *       }
 *       string message_id = 1; // mapped to the URL
 *       SubMessage sub = 2;    // `sub.subfield` is url-mapped
 *     }
 *     message Message {
 *       string text = 1; // content of the resource
 *     }
 * The same http annotation can alternatively be expressed inside the
 * `GRPC API Configuration` YAML file.
 *     http:
 *       rules:
 *         - selector: &lt;proto_package_name&gt;.Messaging.GetMessage
 *           get: /v1/messages/{message_id}/{sub.subfield}
 * This definition enables an automatic, bidrectional mapping of HTTP
 * JSON to RPC. Example:
 * HTTP | RPC
 * -----|-----
 * `GET /v1/messages/123456/foo`  | `GetMessage(message_id: "123456" sub: SubMessage(subfield: "foo"))`
 * In general, not only fields but also field paths can be referenced
 * from a path pattern. Fields mapped to the path pattern cannot be
 * repeated and must have a primitive (non-message) type.
 * Any fields in the request message which are not bound by the path
 * pattern automatically become (optional) HTTP query
 * parameters. Assume the following definition of the request message:
 *     message GetMessageRequest {
 *       message SubMessage {
 *         string subfield = 1;
 *       }
 *       string message_id = 1; // mapped to the URL
 *       int64 revision = 2;    // becomes a parameter
 *       SubMessage sub = 3;    // `sub.subfield` becomes a parameter
 *     }
 * This enables a HTTP JSON to RPC mapping as below:
 * HTTP | RPC
 * -----|-----
 * `GET /v1/messages/123456?revision=2&amp;sub.subfield=foo` | `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield: "foo"))`
 * Note that fields which are mapped to HTTP parameters must have a
 * primitive type or a repeated primitive type. Message types are not
 * allowed. In the case of a repeated type, the parameter can be
 * repeated in the URL, as in `...?param=A&amp;param=B`.
 * For HTTP method kinds which allow a request body, the `body` field
 * specifies the mapping. Consider a REST update method on the
 * message resource collection:
 *     service Messaging {
 *       rpc UpdateMessage(UpdateMessageRequest) returns (Message) {
 *         option (google.api.http) = {
 *           put: "/v1/messages/{message_id}"
 *           body: "message"
 *         };
 *       }
 *     }
 *     message UpdateMessageRequest {
 *       string message_id = 1; // mapped to the URL
 *       Message message = 2;   // mapped to the body
 *     }
 * The following HTTP JSON to RPC mapping is enabled, where the
 * representation of the JSON in the request body is determined by
 * protos JSON encoding:
 * HTTP | RPC
 * -----|-----
 * `PUT /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" message { text: "Hi!" })`
 * The special name `*` can be used in the body mapping to define that
 * every field not bound by the path template should be mapped to the
 * request body.  This enables the following alternative definition of
 * the update method:
 *     service Messaging {
 *       rpc UpdateMessage(Message) returns (Message) {
 *         option (google.api.http) = {
 *           put: "/v1/messages/{message_id}"
 *           body: "*"
 *         };
 *       }
 *     }
 *     message Message {
 *       string message_id = 1;
 *       string text = 2;
 *     }
 * The following HTTP JSON to RPC mapping is enabled:
 * HTTP | RPC
 * -----|-----
 * `PUT /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" text: "Hi!")`
 * Note that when using `*` in the body mapping, it is not possible to
 * have HTTP parameters, as all fields not bound by the path end in
 * the body. This makes this option more rarely used in practice of
 * defining REST APIs. The common usage of `*` is in custom methods
 * which don't use the URL at all for transferring data.
 * It is possible to define multiple HTTP methods for one RPC by using
 * the `additional_bindings` option. Example:
 *     service Messaging {
 *       rpc GetMessage(GetMessageRequest) returns (Message) {
 *         option (google.api.http) = {
 *           get: "/v1/messages/{message_id}"
 *           additional_bindings {
 *             get: "/v1/users/{user_id}/messages/{message_id}"
 *           }
 *         };
 *       }
 *     }
 *     message GetMessageRequest {
 *       string message_id = 1;
 *       string user_id = 2;
 *     }
 * This enables the following two alternative HTTP JSON to RPC
 * mappings:
 * HTTP | RPC
 * -----|-----
 * `GET /v1/messages/123456` | `GetMessage(message_id: "123456")`
 * `GET /v1/users/me/messages/123456` | `GetMessage(user_id: "me" message_id: "123456")`
 * # Rules for HTTP mapping
 * The rules for mapping HTTP path, query parameters, and body fields
 * to the request message are as follows:
 * 1. The `body` field specifies either `*` or a field path, or is
 *    omitted. If omitted, it assumes there is no HTTP body.
 * 2. Leaf fields (recursive expansion of nested messages in the
 *    request) can be classified into three types:
 *     (a) Matched in the URL template.
 *     (b) Covered by body (if body is `*`, everything except (a) fields;
 *         else everything under the body field)
 *     (c) All other fields.
 * 3. URL query parameters found in the HTTP request are mapped to (c) fields.
 * 4. Any body sent with an HTTP request can contain only (b) fields.
 * The syntax of the path template is as follows:
 *     Template = "/" Segments [ Verb ] ;
 *     Segments = Segment { "/" Segment } ;
 *     Segment  = "*" | "**" | LITERAL | Variable ;
 *     Variable = "{" FieldPath [ "=" Segments ] "}" ;
 *     FieldPath = IDENT { "." IDENT } ;
 *     Verb     = ":" LITERAL ;
 * The syntax `*` matches a single path segment. It follows the semantics of
 * [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String
 * Expansion.
 * The syntax `**` matches zero or more path segments. It follows the semantics
 * of [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.3 Reserved
 * Expansion. NOTE: it must be the last segment in the path except the Verb.
 * The syntax `LITERAL` matches literal text in the URL path.
 * The syntax `Variable` matches the entire path as specified by its template;
 * this nested template must not contain further variables. If a variable
 * matches a single path segment, its template may be omitted, e.g. `{var}`
 * is equivalent to `{var=*}`.
 * NOTE: the field paths in variables and in the `body` must not refer to
 * repeated fields or map fields.
 * Use CustomHttpPattern to specify any HTTP method that is not included in the
 * `pattern` field, such as HEAD, or "*" to leave the HTTP method unspecified for
 * a given URL path rule. The wild-card rule is useful for services that provide
 * content to Web (HTML) clients.
 * </pre>
 *
 * Protobuf type {@code google.api.HttpRule}
 */
public  final class HttpRule extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.HttpRule)
    HttpRuleOrBuilder {
private static final long serialVersionUID = 0L;
  // Use HttpRule.newBuilder() to construct.
  private HttpRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private HttpRule() {
    selector_ = "";
    body_ = "";
    additionalBindings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new HttpRule();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private HttpRule(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            selector_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();
            patternCase_ = 2;
            pattern_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();
            patternCase_ = 3;
            pattern_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();
            patternCase_ = 4;
            pattern_ = s;
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();
            patternCase_ = 5;
            pattern_ = s;
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();
            patternCase_ = 6;
            pattern_ = s;
            break;
          }
          case 58: {
            java.lang.String s = input.readStringRequireUtf8();

            body_ = s;
            break;
          }
          case 66: {
            com.google.api.CustomHttpPattern.Builder subBuilder = null;
            if (patternCase_ == 8) {
              subBuilder = ((com.google.api.CustomHttpPattern) pattern_).toBuilder();
            }
            pattern_ =
                input.readMessage(com.google.api.CustomHttpPattern.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.api.CustomHttpPattern) pattern_);
              pattern_ = subBuilder.buildPartial();
            }
            patternCase_ = 8;
            break;
          }
          case 90: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              additionalBindings_ = new java.util.ArrayList<com.google.api.HttpRule>();
              mutable_bitField0_ |= 0x00000001;
            }
            additionalBindings_.add(
                input.readMessage(com.google.api.HttpRule.parser(), extensionRegistry));
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        additionalBindings_ = java.util.Collections.unmodifiableList(additionalBindings_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.api.HttpProto.internal_static_google_api_HttpRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.HttpProto.internal_static_google_api_HttpRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.HttpRule.class, com.google.api.HttpRule.Builder.class);
  }

  private int patternCase_ = 0;
  private java.lang.Object pattern_;
  public enum PatternCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GET(2),
    PUT(3),
    POST(4),
    DELETE(5),
    PATCH(6),
    CUSTOM(8),
    PATTERN_NOT_SET(0);
    private final int value;
    private PatternCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PatternCase valueOf(int value) {
      return forNumber(value);
    }

    public static PatternCase forNumber(int value) {
      switch (value) {
        case 2: return GET;
        case 3: return PUT;
        case 4: return POST;
        case 5: return DELETE;
        case 6: return PATCH;
        case 8: return CUSTOM;
        case 0: return PATTERN_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public PatternCase
  getPatternCase() {
    return PatternCase.forNumber(
        patternCase_);
  }

  public static final int SELECTOR_FIELD_NUMBER = 1;
  private volatile java.lang.Object selector_;
  /**
   * <pre>
   * Selects methods to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   * @return The selector.
   */
  public java.lang.String getSelector() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selector_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Selects methods to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   * @return The bytes for selector.
   */
  public com.google.protobuf.ByteString
      getSelectorBytes() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      selector_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GET_FIELD_NUMBER = 2;
  /**
   * <pre>
   * Used for listing and getting information about resources.
   * </pre>
   *
   * <code>string get = 2;</code>
   * @return The get.
   */
  public java.lang.String getGet() {
    java.lang.Object ref = "";
    if (patternCase_ == 2) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 2) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Used for listing and getting information about resources.
   * </pre>
   *
   * <code>string get = 2;</code>
   * @return The bytes for get.
   */
  public com.google.protobuf.ByteString
      getGetBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 2) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 2) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUT_FIELD_NUMBER = 3;
  /**
   * <pre>
   * Used for updating a resource.
   * </pre>
   *
   * <code>string put = 3;</code>
   * @return The put.
   */
  public java.lang.String getPut() {
    java.lang.Object ref = "";
    if (patternCase_ == 3) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 3) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Used for updating a resource.
   * </pre>
   *
   * <code>string put = 3;</code>
   * @return The bytes for put.
   */
  public com.google.protobuf.ByteString
      getPutBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 3) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 3) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POST_FIELD_NUMBER = 4;
  /**
   * <pre>
   * Used for creating a resource.
   * </pre>
   *
   * <code>string post = 4;</code>
   * @return The post.
   */
  public java.lang.String getPost() {
    java.lang.Object ref = "";
    if (patternCase_ == 4) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 4) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Used for creating a resource.
   * </pre>
   *
   * <code>string post = 4;</code>
   * @return The bytes for post.
   */
  public com.google.protobuf.ByteString
      getPostBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 4) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 4) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETE_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Used for deleting a resource.
   * </pre>
   *
   * <code>string delete = 5;</code>
   * @return The delete.
   */
  public java.lang.String getDelete() {
    java.lang.Object ref = "";
    if (patternCase_ == 5) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 5) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Used for deleting a resource.
   * </pre>
   *
   * <code>string delete = 5;</code>
   * @return The bytes for delete.
   */
  public com.google.protobuf.ByteString
      getDeleteBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 5) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 5) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATCH_FIELD_NUMBER = 6;
  /**
   * <pre>
   * Used for updating a resource.
   * </pre>
   *
   * <code>string patch = 6;</code>
   * @return The patch.
   */
  public java.lang.String getPatch() {
    java.lang.Object ref = "";
    if (patternCase_ == 6) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 6) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Used for updating a resource.
   * </pre>
   *
   * <code>string patch = 6;</code>
   * @return The bytes for patch.
   */
  public com.google.protobuf.ByteString
      getPatchBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 6) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 6) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_FIELD_NUMBER = 8;
  /**
   * <pre>
   * Custom pattern is used for defining custom verbs.
   * </pre>
   *
   * <code>.google.api.CustomHttpPattern custom = 8;</code>
   * @return Whether the custom field is set.
   */
  public boolean hasCustom() {
    return patternCase_ == 8;
  }
  /**
   * <pre>
   * Custom pattern is used for defining custom verbs.
   * </pre>
   *
   * <code>.google.api.CustomHttpPattern custom = 8;</code>
   * @return The custom.
   */
  public com.google.api.CustomHttpPattern getCustom() {
    if (patternCase_ == 8) {
       return (com.google.api.CustomHttpPattern) pattern_;
    }
    return com.google.api.CustomHttpPattern.getDefaultInstance();
  }
  /**
   * <pre>
   * Custom pattern is used for defining custom verbs.
   * </pre>
   *
   * <code>.google.api.CustomHttpPattern custom = 8;</code>
   */
  public com.google.api.CustomHttpPatternOrBuilder getCustomOrBuilder() {
    if (patternCase_ == 8) {
       return (com.google.api.CustomHttpPattern) pattern_;
    }
    return com.google.api.CustomHttpPattern.getDefaultInstance();
  }

  public static final int BODY_FIELD_NUMBER = 7;
  private volatile java.lang.Object body_;
  /**
   * <pre>
   * The name of the request field whose value is mapped to the HTTP body, or
   * `*` for mapping all fields not captured by the path pattern to the HTTP
   * body. NOTE: the referred field must not be a repeated field and must be
   * present at the top-level of request message type.
   * </pre>
   *
   * <code>string body = 7;</code>
   * @return The body.
   */
  public java.lang.String getBody() {
    java.lang.Object ref = body_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      body_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The name of the request field whose value is mapped to the HTTP body, or
   * `*` for mapping all fields not captured by the path pattern to the HTTP
   * body. NOTE: the referred field must not be a repeated field and must be
   * present at the top-level of request message type.
   * </pre>
   *
   * <code>string body = 7;</code>
   * @return The bytes for body.
   */
  public com.google.protobuf.ByteString
      getBodyBytes() {
    java.lang.Object ref = body_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      body_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDITIONAL_BINDINGS_FIELD_NUMBER = 11;
  private java.util.List<com.google.api.HttpRule> additionalBindings_;
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  public java.util.List<com.google.api.HttpRule> getAdditionalBindingsList() {
    return additionalBindings_;
  }
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  public java.util.List<? extends com.google.api.HttpRuleOrBuilder> 
      getAdditionalBindingsOrBuilderList() {
    return additionalBindings_;
  }
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  public int getAdditionalBindingsCount() {
    return additionalBindings_.size();
  }
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  public com.google.api.HttpRule getAdditionalBindings(int index) {
    return additionalBindings_.get(index);
  }
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  public com.google.api.HttpRuleOrBuilder getAdditionalBindingsOrBuilder(
      int index) {
    return additionalBindings_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getSelectorBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, selector_);
    }
    if (patternCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, pattern_);
    }
    if (patternCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pattern_);
    }
    if (patternCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pattern_);
    }
    if (patternCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pattern_);
    }
    if (patternCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, pattern_);
    }
    if (!getBodyBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, body_);
    }
    if (patternCase_ == 8) {
      output.writeMessage(8, (com.google.api.CustomHttpPattern) pattern_);
    }
    for (int i = 0; i < additionalBindings_.size(); i++) {
      output.writeMessage(11, additionalBindings_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getSelectorBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, selector_);
    }
    if (patternCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, pattern_);
    }
    if (patternCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pattern_);
    }
    if (patternCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pattern_);
    }
    if (patternCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pattern_);
    }
    if (patternCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, pattern_);
    }
    if (!getBodyBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, body_);
    }
    if (patternCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (com.google.api.CustomHttpPattern) pattern_);
    }
    for (int i = 0; i < additionalBindings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, additionalBindings_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.api.HttpRule)) {
      return super.equals(obj);
    }
    com.google.api.HttpRule other = (com.google.api.HttpRule) obj;

    if (!getSelector()
        .equals(other.getSelector())) return false;
    if (!getBody()
        .equals(other.getBody())) return false;
    if (!getAdditionalBindingsList()
        .equals(other.getAdditionalBindingsList())) return false;
    if (!getPatternCase().equals(other.getPatternCase())) return false;
    switch (patternCase_) {
      case 2:
        if (!getGet()
            .equals(other.getGet())) return false;
        break;
      case 3:
        if (!getPut()
            .equals(other.getPut())) return false;
        break;
      case 4:
        if (!getPost()
            .equals(other.getPost())) return false;
        break;
      case 5:
        if (!getDelete()
            .equals(other.getDelete())) return false;
        break;
      case 6:
        if (!getPatch()
            .equals(other.getPatch())) return false;
        break;
      case 8:
        if (!getCustom()
            .equals(other.getCustom())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getSelector().hashCode();
    hash = (37 * hash) + BODY_FIELD_NUMBER;
    hash = (53 * hash) + getBody().hashCode();
    if (getAdditionalBindingsCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_BINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalBindingsList().hashCode();
    }
    switch (patternCase_) {
      case 2:
        hash = (37 * hash) + GET_FIELD_NUMBER;
        hash = (53 * hash) + getGet().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PUT_FIELD_NUMBER;
        hash = (53 * hash) + getPut().hashCode();
        break;
      case 4:
        hash = (37 * hash) + POST_FIELD_NUMBER;
        hash = (53 * hash) + getPost().hashCode();
        break;
      case 5:
        hash = (37 * hash) + DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDelete().hashCode();
        break;
      case 6:
        hash = (37 * hash) + PATCH_FIELD_NUMBER;
        hash = (53 * hash) + getPatch().hashCode();
        break;
      case 8:
        hash = (37 * hash) + CUSTOM_FIELD_NUMBER;
        hash = (53 * hash) + getCustom().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.HttpRule parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.HttpRule parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.HttpRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.HttpRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.HttpRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.HttpRule parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.HttpRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.HttpRule parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.HttpRule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.api.HttpRule parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.HttpRule parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.HttpRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.api.HttpRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * `HttpRule` defines the mapping of an RPC method to one or more HTTP
   * REST APIs.  The mapping determines what portions of the request
   * message are populated from the path, query parameters, or body of
   * the HTTP request.  The mapping is typically specified as an
   * `google.api.http` annotation, see "google/api/annotations.proto"
   * for details.
   * The mapping consists of a field specifying the path template and
   * method kind.  The path template can refer to fields in the request
   * message, as in the example below which describes a REST GET
   * operation on a resource collection of messages:
   *     service Messaging {
   *       rpc GetMessage(GetMessageRequest) returns (Message) {
   *         option (google.api.http).get = "/v1/messages/{message_id}/{sub.subfield}";
   *       }
   *     }
   *     message GetMessageRequest {
   *       message SubMessage {
   *         string subfield = 1;
   *       }
   *       string message_id = 1; // mapped to the URL
   *       SubMessage sub = 2;    // `sub.subfield` is url-mapped
   *     }
   *     message Message {
   *       string text = 1; // content of the resource
   *     }
   * The same http annotation can alternatively be expressed inside the
   * `GRPC API Configuration` YAML file.
   *     http:
   *       rules:
   *         - selector: &lt;proto_package_name&gt;.Messaging.GetMessage
   *           get: /v1/messages/{message_id}/{sub.subfield}
   * This definition enables an automatic, bidrectional mapping of HTTP
   * JSON to RPC. Example:
   * HTTP | RPC
   * -----|-----
   * `GET /v1/messages/123456/foo`  | `GetMessage(message_id: "123456" sub: SubMessage(subfield: "foo"))`
   * In general, not only fields but also field paths can be referenced
   * from a path pattern. Fields mapped to the path pattern cannot be
   * repeated and must have a primitive (non-message) type.
   * Any fields in the request message which are not bound by the path
   * pattern automatically become (optional) HTTP query
   * parameters. Assume the following definition of the request message:
   *     message GetMessageRequest {
   *       message SubMessage {
   *         string subfield = 1;
   *       }
   *       string message_id = 1; // mapped to the URL
   *       int64 revision = 2;    // becomes a parameter
   *       SubMessage sub = 3;    // `sub.subfield` becomes a parameter
   *     }
   * This enables a HTTP JSON to RPC mapping as below:
   * HTTP | RPC
   * -----|-----
   * `GET /v1/messages/123456?revision=2&amp;sub.subfield=foo` | `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield: "foo"))`
   * Note that fields which are mapped to HTTP parameters must have a
   * primitive type or a repeated primitive type. Message types are not
   * allowed. In the case of a repeated type, the parameter can be
   * repeated in the URL, as in `...?param=A&amp;param=B`.
   * For HTTP method kinds which allow a request body, the `body` field
   * specifies the mapping. Consider a REST update method on the
   * message resource collection:
   *     service Messaging {
   *       rpc UpdateMessage(UpdateMessageRequest) returns (Message) {
   *         option (google.api.http) = {
   *           put: "/v1/messages/{message_id}"
   *           body: "message"
   *         };
   *       }
   *     }
   *     message UpdateMessageRequest {
   *       string message_id = 1; // mapped to the URL
   *       Message message = 2;   // mapped to the body
   *     }
   * The following HTTP JSON to RPC mapping is enabled, where the
   * representation of the JSON in the request body is determined by
   * protos JSON encoding:
   * HTTP | RPC
   * -----|-----
   * `PUT /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" message { text: "Hi!" })`
   * The special name `*` can be used in the body mapping to define that
   * every field not bound by the path template should be mapped to the
   * request body.  This enables the following alternative definition of
   * the update method:
   *     service Messaging {
   *       rpc UpdateMessage(Message) returns (Message) {
   *         option (google.api.http) = {
   *           put: "/v1/messages/{message_id}"
   *           body: "*"
   *         };
   *       }
   *     }
   *     message Message {
   *       string message_id = 1;
   *       string text = 2;
   *     }
   * The following HTTP JSON to RPC mapping is enabled:
   * HTTP | RPC
   * -----|-----
   * `PUT /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" text: "Hi!")`
   * Note that when using `*` in the body mapping, it is not possible to
   * have HTTP parameters, as all fields not bound by the path end in
   * the body. This makes this option more rarely used in practice of
   * defining REST APIs. The common usage of `*` is in custom methods
   * which don't use the URL at all for transferring data.
   * It is possible to define multiple HTTP methods for one RPC by using
   * the `additional_bindings` option. Example:
   *     service Messaging {
   *       rpc GetMessage(GetMessageRequest) returns (Message) {
   *         option (google.api.http) = {
   *           get: "/v1/messages/{message_id}"
   *           additional_bindings {
   *             get: "/v1/users/{user_id}/messages/{message_id}"
   *           }
   *         };
   *       }
   *     }
   *     message GetMessageRequest {
   *       string message_id = 1;
   *       string user_id = 2;
   *     }
   * This enables the following two alternative HTTP JSON to RPC
   * mappings:
   * HTTP | RPC
   * -----|-----
   * `GET /v1/messages/123456` | `GetMessage(message_id: "123456")`
   * `GET /v1/users/me/messages/123456` | `GetMessage(user_id: "me" message_id: "123456")`
   * # Rules for HTTP mapping
   * The rules for mapping HTTP path, query parameters, and body fields
   * to the request message are as follows:
   * 1. The `body` field specifies either `*` or a field path, or is
   *    omitted. If omitted, it assumes there is no HTTP body.
   * 2. Leaf fields (recursive expansion of nested messages in the
   *    request) can be classified into three types:
   *     (a) Matched in the URL template.
   *     (b) Covered by body (if body is `*`, everything except (a) fields;
   *         else everything under the body field)
   *     (c) All other fields.
   * 3. URL query parameters found in the HTTP request are mapped to (c) fields.
   * 4. Any body sent with an HTTP request can contain only (b) fields.
   * The syntax of the path template is as follows:
   *     Template = "/" Segments [ Verb ] ;
   *     Segments = Segment { "/" Segment } ;
   *     Segment  = "*" | "**" | LITERAL | Variable ;
   *     Variable = "{" FieldPath [ "=" Segments ] "}" ;
   *     FieldPath = IDENT { "." IDENT } ;
   *     Verb     = ":" LITERAL ;
   * The syntax `*` matches a single path segment. It follows the semantics of
   * [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String
   * Expansion.
   * The syntax `**` matches zero or more path segments. It follows the semantics
   * of [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.3 Reserved
   * Expansion. NOTE: it must be the last segment in the path except the Verb.
   * The syntax `LITERAL` matches literal text in the URL path.
   * The syntax `Variable` matches the entire path as specified by its template;
   * this nested template must not contain further variables. If a variable
   * matches a single path segment, its template may be omitted, e.g. `{var}`
   * is equivalent to `{var=*}`.
   * NOTE: the field paths in variables and in the `body` must not refer to
   * repeated fields or map fields.
   * Use CustomHttpPattern to specify any HTTP method that is not included in the
   * `pattern` field, such as HEAD, or "*" to leave the HTTP method unspecified for
   * a given URL path rule. The wild-card rule is useful for services that provide
   * content to Web (HTML) clients.
   * </pre>
   *
   * Protobuf type {@code google.api.HttpRule}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.HttpRule)
      com.google.api.HttpRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.HttpProto.internal_static_google_api_HttpRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.HttpProto.internal_static_google_api_HttpRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.HttpRule.class, com.google.api.HttpRule.Builder.class);
    }

    // Construct using com.google.api.HttpRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getAdditionalBindingsFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      selector_ = "";

      body_ = "";

      if (additionalBindingsBuilder_ == null) {
        additionalBindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        additionalBindingsBuilder_.clear();
      }
      patternCase_ = 0;
      pattern_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.api.HttpProto.internal_static_google_api_HttpRule_descriptor;
    }

    @java.lang.Override
    public com.google.api.HttpRule getDefaultInstanceForType() {
      return com.google.api.HttpRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.HttpRule build() {
      com.google.api.HttpRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.HttpRule buildPartial() {
      com.google.api.HttpRule result = new com.google.api.HttpRule(this);
      int from_bitField0_ = bitField0_;
      result.selector_ = selector_;
      if (patternCase_ == 2) {
        result.pattern_ = pattern_;
      }
      if (patternCase_ == 3) {
        result.pattern_ = pattern_;
      }
      if (patternCase_ == 4) {
        result.pattern_ = pattern_;
      }
      if (patternCase_ == 5) {
        result.pattern_ = pattern_;
      }
      if (patternCase_ == 6) {
        result.pattern_ = pattern_;
      }
      if (patternCase_ == 8) {
        if (customBuilder_ == null) {
          result.pattern_ = pattern_;
        } else {
          result.pattern_ = customBuilder_.build();
        }
      }
      result.body_ = body_;
      if (additionalBindingsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          additionalBindings_ = java.util.Collections.unmodifiableList(additionalBindings_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.additionalBindings_ = additionalBindings_;
      } else {
        result.additionalBindings_ = additionalBindingsBuilder_.build();
      }
      result.patternCase_ = patternCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.HttpRule) {
        return mergeFrom((com.google.api.HttpRule)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.HttpRule other) {
      if (other == com.google.api.HttpRule.getDefaultInstance()) return this;
      if (!other.getSelector().isEmpty()) {
        selector_ = other.selector_;
        onChanged();
      }
      if (!other.getBody().isEmpty()) {
        body_ = other.body_;
        onChanged();
      }
      if (additionalBindingsBuilder_ == null) {
        if (!other.additionalBindings_.isEmpty()) {
          if (additionalBindings_.isEmpty()) {
            additionalBindings_ = other.additionalBindings_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAdditionalBindingsIsMutable();
            additionalBindings_.addAll(other.additionalBindings_);
          }
          onChanged();
        }
      } else {
        if (!other.additionalBindings_.isEmpty()) {
          if (additionalBindingsBuilder_.isEmpty()) {
            additionalBindingsBuilder_.dispose();
            additionalBindingsBuilder_ = null;
            additionalBindings_ = other.additionalBindings_;
            bitField0_ = (bitField0_ & ~0x00000001);
            additionalBindingsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getAdditionalBindingsFieldBuilder() : null;
          } else {
            additionalBindingsBuilder_.addAllMessages(other.additionalBindings_);
          }
        }
      }
      switch (other.getPatternCase()) {
        case GET: {
          patternCase_ = 2;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case PUT: {
          patternCase_ = 3;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case POST: {
          patternCase_ = 4;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case DELETE: {
          patternCase_ = 5;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case PATCH: {
          patternCase_ = 6;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case CUSTOM: {
          mergeCustom(other.getCustom());
          break;
        }
        case PATTERN_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.HttpRule parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.HttpRule) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int patternCase_ = 0;
    private java.lang.Object pattern_;
    public PatternCase
        getPatternCase() {
      return PatternCase.forNumber(
          patternCase_);
    }

    public Builder clearPattern() {
      patternCase_ = 0;
      pattern_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object selector_ = "";
    /**
     * <pre>
     * Selects methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @return The selector.
     */
    public java.lang.String getSelector() {
      java.lang.Object ref = selector_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Selects methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @return The bytes for selector.
     */
    public com.google.protobuf.ByteString
        getSelectorBytes() {
      java.lang.Object ref = selector_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        selector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Selects methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @param value The selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelector(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      selector_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Selects methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearSelector() {
      
      selector_ = getDefaultInstance().getSelector();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Selects methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @param value The bytes for selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelectorBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      selector_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Used for listing and getting information about resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @return The get.
     */
    public java.lang.String getGet() {
      java.lang.Object ref = "";
      if (patternCase_ == 2) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 2) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Used for listing and getting information about resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @return The bytes for get.
     */
    public com.google.protobuf.ByteString
        getGetBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 2) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 2) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Used for listing and getting information about resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @param value The get to set.
     * @return This builder for chaining.
     */
    public Builder setGet(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  patternCase_ = 2;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Used for listing and getting information about resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearGet() {
      if (patternCase_ == 2) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Used for listing and getting information about resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @param value The bytes for get to set.
     * @return This builder for chaining.
     */
    public Builder setGetBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      patternCase_ = 2;
      pattern_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @return The put.
     */
    public java.lang.String getPut() {
      java.lang.Object ref = "";
      if (patternCase_ == 3) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 3) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @return The bytes for put.
     */
    public com.google.protobuf.ByteString
        getPutBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 3) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 3) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @param value The put to set.
     * @return This builder for chaining.
     */
    public Builder setPut(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  patternCase_ = 3;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearPut() {
      if (patternCase_ == 3) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @param value The bytes for put to set.
     * @return This builder for chaining.
     */
    public Builder setPutBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      patternCase_ = 3;
      pattern_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Used for creating a resource.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @return The post.
     */
    public java.lang.String getPost() {
      java.lang.Object ref = "";
      if (patternCase_ == 4) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 4) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Used for creating a resource.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @return The bytes for post.
     */
    public com.google.protobuf.ByteString
        getPostBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 4) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 4) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Used for creating a resource.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @param value The post to set.
     * @return This builder for chaining.
     */
    public Builder setPost(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  patternCase_ = 4;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Used for creating a resource.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearPost() {
      if (patternCase_ == 4) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Used for creating a resource.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @param value The bytes for post to set.
     * @return This builder for chaining.
     */
    public Builder setPostBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      patternCase_ = 4;
      pattern_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @return The delete.
     */
    public java.lang.String getDelete() {
      java.lang.Object ref = "";
      if (patternCase_ == 5) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 5) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @return The bytes for delete.
     */
    public com.google.protobuf.ByteString
        getDeleteBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 5) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 5) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @param value The delete to set.
     * @return This builder for chaining.
     */
    public Builder setDelete(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  patternCase_ = 5;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearDelete() {
      if (patternCase_ == 5) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @param value The bytes for delete to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      patternCase_ = 5;
      pattern_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @return The patch.
     */
    public java.lang.String getPatch() {
      java.lang.Object ref = "";
      if (patternCase_ == 6) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 6) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @return The bytes for patch.
     */
    public com.google.protobuf.ByteString
        getPatchBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 6) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 6) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @param value The patch to set.
     * @return This builder for chaining.
     */
    public Builder setPatch(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  patternCase_ = 6;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearPatch() {
      if (patternCase_ == 6) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @param value The bytes for patch to set.
     * @return This builder for chaining.
     */
    public Builder setPatchBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      patternCase_ = 6;
      pattern_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.CustomHttpPattern, com.google.api.CustomHttpPattern.Builder, com.google.api.CustomHttpPatternOrBuilder> customBuilder_;
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     * @return Whether the custom field is set.
     */
    public boolean hasCustom() {
      return patternCase_ == 8;
    }
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     * @return The custom.
     */
    public com.google.api.CustomHttpPattern getCustom() {
      if (customBuilder_ == null) {
        if (patternCase_ == 8) {
          return (com.google.api.CustomHttpPattern) pattern_;
        }
        return com.google.api.CustomHttpPattern.getDefaultInstance();
      } else {
        if (patternCase_ == 8) {
          return customBuilder_.getMessage();
        }
        return com.google.api.CustomHttpPattern.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public Builder setCustom(com.google.api.CustomHttpPattern value) {
      if (customBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pattern_ = value;
        onChanged();
      } else {
        customBuilder_.setMessage(value);
      }
      patternCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public Builder setCustom(
        com.google.api.CustomHttpPattern.Builder builderForValue) {
      if (customBuilder_ == null) {
        pattern_ = builderForValue.build();
        onChanged();
      } else {
        customBuilder_.setMessage(builderForValue.build());
      }
      patternCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public Builder mergeCustom(com.google.api.CustomHttpPattern value) {
      if (customBuilder_ == null) {
        if (patternCase_ == 8 &&
            pattern_ != com.google.api.CustomHttpPattern.getDefaultInstance()) {
          pattern_ = com.google.api.CustomHttpPattern.newBuilder((com.google.api.CustomHttpPattern) pattern_)
              .mergeFrom(value).buildPartial();
        } else {
          pattern_ = value;
        }
        onChanged();
      } else {
        if (patternCase_ == 8) {
          customBuilder_.mergeFrom(value);
        }
        customBuilder_.setMessage(value);
      }
      patternCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public Builder clearCustom() {
      if (customBuilder_ == null) {
        if (patternCase_ == 8) {
          patternCase_ = 0;
          pattern_ = null;
          onChanged();
        }
      } else {
        if (patternCase_ == 8) {
          patternCase_ = 0;
          pattern_ = null;
        }
        customBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public com.google.api.CustomHttpPattern.Builder getCustomBuilder() {
      return getCustomFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public com.google.api.CustomHttpPatternOrBuilder getCustomOrBuilder() {
      if ((patternCase_ == 8) && (customBuilder_ != null)) {
        return customBuilder_.getMessageOrBuilder();
      } else {
        if (patternCase_ == 8) {
          return (com.google.api.CustomHttpPattern) pattern_;
        }
        return com.google.api.CustomHttpPattern.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Custom pattern is used for defining custom verbs.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.CustomHttpPattern, com.google.api.CustomHttpPattern.Builder, com.google.api.CustomHttpPatternOrBuilder> 
        getCustomFieldBuilder() {
      if (customBuilder_ == null) {
        if (!(patternCase_ == 8)) {
          pattern_ = com.google.api.CustomHttpPattern.getDefaultInstance();
        }
        customBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.CustomHttpPattern, com.google.api.CustomHttpPattern.Builder, com.google.api.CustomHttpPatternOrBuilder>(
                (com.google.api.CustomHttpPattern) pattern_,
                getParentForChildren(),
                isClean());
        pattern_ = null;
      }
      patternCase_ = 8;
      onChanged();;
      return customBuilder_;
    }

    private java.lang.Object body_ = "";
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP body, or
     * `*` for mapping all fields not captured by the path pattern to the HTTP
     * body. NOTE: the referred field must not be a repeated field and must be
     * present at the top-level of request message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @return The body.
     */
    public java.lang.String getBody() {
      java.lang.Object ref = body_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        body_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP body, or
     * `*` for mapping all fields not captured by the path pattern to the HTTP
     * body. NOTE: the referred field must not be a repeated field and must be
     * present at the top-level of request message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @return The bytes for body.
     */
    public com.google.protobuf.ByteString
        getBodyBytes() {
      java.lang.Object ref = body_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        body_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP body, or
     * `*` for mapping all fields not captured by the path pattern to the HTTP
     * body. NOTE: the referred field must not be a repeated field and must be
     * present at the top-level of request message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @param value The body to set.
     * @return This builder for chaining.
     */
    public Builder setBody(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      body_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP body, or
     * `*` for mapping all fields not captured by the path pattern to the HTTP
     * body. NOTE: the referred field must not be a repeated field and must be
     * present at the top-level of request message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearBody() {
      
      body_ = getDefaultInstance().getBody();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP body, or
     * `*` for mapping all fields not captured by the path pattern to the HTTP
     * body. NOTE: the referred field must not be a repeated field and must be
     * present at the top-level of request message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @param value The bytes for body to set.
     * @return This builder for chaining.
     */
    public Builder setBodyBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      body_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.HttpRule> additionalBindings_ =
      java.util.Collections.emptyList();
    private void ensureAdditionalBindingsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        additionalBindings_ = new java.util.ArrayList<com.google.api.HttpRule>(additionalBindings_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.api.HttpRule, com.google.api.HttpRule.Builder, com.google.api.HttpRuleOrBuilder> additionalBindingsBuilder_;

    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public java.util.List<com.google.api.HttpRule> getAdditionalBindingsList() {
      if (additionalBindingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(additionalBindings_);
      } else {
        return additionalBindingsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public int getAdditionalBindingsCount() {
      if (additionalBindingsBuilder_ == null) {
        return additionalBindings_.size();
      } else {
        return additionalBindingsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRule getAdditionalBindings(int index) {
      if (additionalBindingsBuilder_ == null) {
        return additionalBindings_.get(index);
      } else {
        return additionalBindingsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder setAdditionalBindings(
        int index, com.google.api.HttpRule value) {
      if (additionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.set(index, value);
        onChanged();
      } else {
        additionalBindingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder setAdditionalBindings(
        int index, com.google.api.HttpRule.Builder builderForValue) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.set(index, builderForValue.build());
        onChanged();
      } else {
        additionalBindingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAdditionalBindings(com.google.api.HttpRule value) {
      if (additionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.add(value);
        onChanged();
      } else {
        additionalBindingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAdditionalBindings(
        int index, com.google.api.HttpRule value) {
      if (additionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.add(index, value);
        onChanged();
      } else {
        additionalBindingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAdditionalBindings(
        com.google.api.HttpRule.Builder builderForValue) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.add(builderForValue.build());
        onChanged();
      } else {
        additionalBindingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAdditionalBindings(
        int index, com.google.api.HttpRule.Builder builderForValue) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.add(index, builderForValue.build());
        onChanged();
      } else {
        additionalBindingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAllAdditionalBindings(
        java.lang.Iterable<? extends com.google.api.HttpRule> values) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, additionalBindings_);
        onChanged();
      } else {
        additionalBindingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder clearAdditionalBindings() {
      if (additionalBindingsBuilder_ == null) {
        additionalBindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        additionalBindingsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder removeAdditionalBindings(int index) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.remove(index);
        onChanged();
      } else {
        additionalBindingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRule.Builder getAdditionalBindingsBuilder(
        int index) {
      return getAdditionalBindingsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRuleOrBuilder getAdditionalBindingsOrBuilder(
        int index) {
      if (additionalBindingsBuilder_ == null) {
        return additionalBindings_.get(index);  } else {
        return additionalBindingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public java.util.List<? extends com.google.api.HttpRuleOrBuilder> 
         getAdditionalBindingsOrBuilderList() {
      if (additionalBindingsBuilder_ != null) {
        return additionalBindingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(additionalBindings_);
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRule.Builder addAdditionalBindingsBuilder() {
      return getAdditionalBindingsFieldBuilder().addBuilder(
          com.google.api.HttpRule.getDefaultInstance());
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRule.Builder addAdditionalBindingsBuilder(
        int index) {
      return getAdditionalBindingsFieldBuilder().addBuilder(
          index, com.google.api.HttpRule.getDefaultInstance());
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public java.util.List<com.google.api.HttpRule.Builder> 
         getAdditionalBindingsBuilderList() {
      return getAdditionalBindingsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.api.HttpRule, com.google.api.HttpRule.Builder, com.google.api.HttpRuleOrBuilder> 
        getAdditionalBindingsFieldBuilder() {
      if (additionalBindingsBuilder_ == null) {
        additionalBindingsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.HttpRule, com.google.api.HttpRule.Builder, com.google.api.HttpRuleOrBuilder>(
                additionalBindings_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        additionalBindings_ = null;
      }
      return additionalBindingsBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.api.HttpRule)
  }

  // @@protoc_insertion_point(class_scope:google.api.HttpRule)
  private static final com.google.api.HttpRule DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.api.HttpRule();
  }

  public static com.google.api.HttpRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRule>
      PARSER = new com.google.protobuf.AbstractParser<HttpRule>() {
    @java.lang.Override
    public HttpRule parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new HttpRule(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<HttpRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.HttpRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

