/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.testing.compile.AutoValue_Compiler;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationFailureException;
import com.google.testing.compile.InMemoryJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

@AutoValue
public abstract class Compiler {
    @VisibleForTesting
    static final ClassLoader platformClassLoader = Compiler.getPlatformClassLoader();

    public static Compiler javac() {
        return Compiler.compiler(ToolProvider.getSystemJavaCompiler());
    }

    public static Compiler compiler(JavaCompiler javaCompiler) {
        return new AutoValue_Compiler(javaCompiler, (ImmutableList<Processor>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of(), Optional.empty());
    }

    abstract JavaCompiler javaCompiler();

    public abstract ImmutableList<Processor> processors();

    public abstract ImmutableList<String> options();

    public abstract Optional<ImmutableList<File>> classPath();

    public final Compiler withProcessors(Processor ... processors) {
        return this.withProcessors((Iterable<? extends Processor>)ImmutableList.copyOf((Object[])processors));
    }

    public final Compiler withProcessors(Iterable<? extends Processor> processors) {
        return this.copy((ImmutableList<Processor>)ImmutableList.copyOf(processors), this.options(), this.classPath());
    }

    public final Compiler withOptions(Object ... options) {
        return this.withOptions((Iterable<?>)ImmutableList.copyOf((Object[])options));
    }

    public final Compiler withOptions(Iterable<?> options) {
        return this.copy(this.processors(), (ImmutableList<String>)FluentIterable.from(options).transform(Functions.toStringFunction()).toList(), this.classPath());
    }

    @Deprecated
    public final Compiler withClasspathFrom(ClassLoader classloader) {
        return this.copy(this.processors(), this.options(), Optional.of(Compiler.getClasspathFromClassloader(classloader)));
    }

    public final Compiler withClasspath(Iterable<File> classPath) {
        return this.copy(this.processors(), this.options(), Optional.of(ImmutableList.copyOf(classPath)));
    }

    public final Compilation compile(JavaFileObject ... files) {
        return this.compile((Iterable<? extends JavaFileObject>)ImmutableList.copyOf((Object[])files));
    }

    public final Compilation compile(Iterable<? extends JavaFileObject> files) {
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(this.javaCompiler().getStandardFileManager(diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        this.classPath().ifPresent(classPath -> {
            try {
                fileManager.setLocation(StandardLocation.CLASS_PATH, (Iterable<? extends File>)classPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        JavaCompiler.CompilationTask task = this.javaCompiler().getTask(null, fileManager, diagnosticCollector, (Iterable<String>)this.options(), (Iterable<String>)ImmutableSet.of(), files);
        task.setProcessors((Iterable<? extends Processor>)this.processors());
        boolean succeeded = task.call();
        Compilation compilation = new Compilation(this, files, succeeded, (Iterable<Diagnostic<? extends JavaFileObject>>)diagnosticCollector.getDiagnostics(), (Iterable<JavaFileObject>)fileManager.getOutputFiles());
        if (compilation.status().equals((Object)Compilation.Status.FAILURE) && compilation.errors().isEmpty()) {
            throw new CompilationFailureException(compilation);
        }
        return compilation;
    }

    private static ClassLoader getPlatformClassLoader() {
        try {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static ImmutableList<File> getClasspathFromClassloader(ClassLoader currentClassloader) {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        LinkedHashSet<String> classpaths = new LinkedHashSet<String>();
        while (true) {
            if (currentClassloader == systemClassLoader) {
                Iterables.addAll(classpaths, (Iterable)Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value()));
                break;
            }
            if (currentClassloader == platformClassLoader) break;
            if (currentClassloader instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)currentClassloader).getURLs()) {
                    if (!url.getProtocol().equals("file")) {
                        throw new IllegalArgumentException("Given classloader consists of classpaths which are unsupported for compilation.");
                    }
                    classpaths.add(url.getPath());
                }
            } else {
                throw new IllegalArgumentException(String.format("Classpath for compilation could not be extracted since %s is not an instance of URLClassloader", currentClassloader));
            }
            currentClassloader = currentClassloader.getParent();
        }
        return (ImmutableList)classpaths.stream().map(File::new).collect(ImmutableList.toImmutableList());
    }

    private Compiler copy(ImmutableList<Processor> processors, ImmutableList<String> options, Optional<ImmutableList<File>> classPath) {
        return new AutoValue_Compiler(this.javaCompiler(), processors, options, classPath);
    }
}

