/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TurbineClassValue;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.model.Const;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineAnnotationValueMirror;
import com.google.turbine.processing.TurbineElement;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeMirror;

class TurbineAnnotationMirror
implements TurbineAnnotationValueMirror,
AnnotationMirror {
    private final TurbineAnnotationValue value;
    private final AnnoInfo anno;
    private final Supplier<DeclaredType> type;
    private final Supplier<ImmutableMap<String, TypeBoundClass.MethodInfo>> elements;
    private final Supplier<ImmutableMap<ExecutableElement, AnnotationValue>> elementValues;
    private final Supplier<ImmutableMap<ExecutableElement, AnnotationValue>> elementValuesWithDefaults;

    static TurbineAnnotationValueMirror annotationValue(ModelFactory factory, Const value) {
        switch (value.kind()) {
            case ARRAY: {
                return new TurbineArrayConstant(factory, (Const.ArrayInitValue)value);
            }
            case PRIMITIVE: {
                return new TurbinePrimitiveConstant((Const.Value)value);
            }
            case CLASS_LITERAL: {
                return new TurbineClassConstant(factory, (TurbineClassValue)value);
            }
            case ENUM_CONSTANT: {
                return new TurbineEnumConstant(factory, (EnumConstantValue)value);
            }
            case ANNOTATION: {
                return new TurbineAnnotationMirror(factory, (TurbineAnnotationValue)value);
            }
        }
        throw new AssertionError((Object)value.kind());
    }

    static TurbineAnnotationMirror create(ModelFactory factory, AnnoInfo anno) {
        return new TurbineAnnotationMirror(factory, new TurbineAnnotationValue(anno));
    }

    private TurbineAnnotationMirror(final ModelFactory factory, TurbineAnnotationValue value) {
        this.value = value;
        this.anno = value.info();
        this.type = factory.memoize(new Supplier<DeclaredType>(){

            public DeclaredType get() {
                if (TurbineAnnotationMirror.this.anno.sym() == null) {
                    return (ErrorType)factory.asTypeMirror(Type.ErrorTy.create(((Tree.Ident)Iterables.getLast(TurbineAnnotationMirror.this.anno.tree().name())).value()));
                }
                return (DeclaredType)factory.typeElement(TurbineAnnotationMirror.this.anno.sym()).asType();
            }
        });
        this.elements = factory.memoize(new Supplier<ImmutableMap<String, TypeBoundClass.MethodInfo>>(){

            public ImmutableMap<String, TypeBoundClass.MethodInfo> get() {
                ImmutableMap.Builder result = ImmutableMap.builder();
                for (TypeBoundClass.MethodInfo m : factory.getSymbol(TurbineAnnotationMirror.this.anno.sym()).methods()) {
                    Preconditions.checkState((boolean)m.parameters().isEmpty());
                    result.put((Object)m.name(), (Object)m);
                }
                return result.build();
            }
        });
        this.elementValues = factory.memoize(new Supplier<ImmutableMap<ExecutableElement, AnnotationValue>>(){

            public ImmutableMap<ExecutableElement, AnnotationValue> get() {
                ImmutableMap.Builder result = ImmutableMap.builder();
                for (Map.Entry value : TurbineAnnotationMirror.this.anno.values().entrySet()) {
                    result.put((Object)factory.executableElement(((TypeBoundClass.MethodInfo)((ImmutableMap)TurbineAnnotationMirror.this.elements.get()).get(value.getKey())).sym()), (Object)TurbineAnnotationMirror.annotationValue(factory, (Const)value.getValue()));
                }
                return result.build();
            }
        });
        this.elementValuesWithDefaults = factory.memoize(new Supplier<ImmutableMap<ExecutableElement, AnnotationValue>>(){

            public ImmutableMap<ExecutableElement, AnnotationValue> get() {
                LinkedHashMap<? extends ExecutableElement, ? extends AnnotationValue> result = new LinkedHashMap<ExecutableElement, AnnotationValue>();
                result.putAll(TurbineAnnotationMirror.this.getElementValues());
                for (TypeBoundClass.MethodInfo method : ((ImmutableMap)TurbineAnnotationMirror.this.elements.get()).values()) {
                    TurbineElement.TurbineExecutableElement element;
                    if (method.defaultValue() == null || result.containsKey(element = factory.executableElement(method.sym()))) continue;
                    result.put(element, TurbineAnnotationMirror.annotationValue(factory, method.defaultValue()));
                }
                return ImmutableMap.copyOf(result);
            }
        });
    }

    public int hashCode() {
        return this.anno.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TurbineAnnotationMirror && this.anno.equals(((TurbineAnnotationMirror)obj).anno);
    }

    @Override
    public String toString() {
        return this.anno.toString();
    }

    @Override
    public DeclaredType getAnnotationType() {
        return (DeclaredType)this.type.get();
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults() {
        return (Map)this.elementValuesWithDefaults.get();
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return (Map)this.elementValues.get();
    }

    @Override
    public AnnotationMirror getValue() {
        return this;
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
        return v.visitAnnotation(this.getValue(), p);
    }

    public AnnoInfo anno() {
        return this.anno;
    }

    @Override
    public Const value() {
        return this.value;
    }

    private static class TurbinePrimitiveConstant
    implements TurbineAnnotationValueMirror {
        private final Const.Value value;

        public TurbinePrimitiveConstant(Const.Value value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value.getValue();
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return this.value.accept(v, p);
        }

        @Override
        public String toString() {
            return this.value.toString();
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TurbinePrimitiveConstant && this.value.equals(((TurbinePrimitiveConstant)obj).value);
        }

        @Override
        public Const value() {
            return this.value;
        }
    }

    private static class TurbineEnumConstant
    implements TurbineAnnotationValueMirror {
        private final EnumConstantValue value;
        private final TurbineElement.TurbineFieldElement fieldElement;

        private TurbineEnumConstant(ModelFactory factory, EnumConstantValue value) {
            this.value = value;
            this.fieldElement = factory.fieldElement(value.sym());
        }

        @Override
        public Object getValue() {
            return this.fieldElement;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitEnumConstant(this.fieldElement, p);
        }

        @Override
        public String toString() {
            return this.fieldElement.getEnclosingElement() + "." + this.fieldElement.getSimpleName();
        }

        @Override
        public Const value() {
            return this.value;
        }
    }

    private static class TurbineClassConstant
    implements TurbineAnnotationValueMirror {
        private final TurbineClassValue value;
        private final TypeMirror typeMirror;

        private TurbineClassConstant(ModelFactory factory, TurbineClassValue value) {
            this.value = value;
            this.typeMirror = factory.asTypeMirror(value.type());
        }

        @Override
        public TypeMirror getValue() {
            return this.typeMirror;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            if (this.value.type().tyKind() == Type.TyKind.ERROR_TY) {
                return v.visitString("<error>", p);
            }
            return v.visitType(this.getValue(), p);
        }

        @Override
        public String toString() {
            return this.typeMirror + ".class";
        }

        @Override
        public Const value() {
            return this.value;
        }
    }

    private static class TurbineArrayConstant
    implements TurbineAnnotationValueMirror {
        private final Const.ArrayInitValue value;
        private final Supplier<ImmutableList<AnnotationValue>> elements;

        private TurbineArrayConstant(final ModelFactory factory, final Const.ArrayInitValue value) {
            this.value = value;
            this.elements = factory.memoize(new Supplier<ImmutableList<AnnotationValue>>(){

                public ImmutableList<AnnotationValue> get() {
                    ImmutableList.Builder values = ImmutableList.builder();
                    for (Const element : value.elements()) {
                        values.add((Object)TurbineAnnotationMirror.annotationValue(factory, element));
                    }
                    return values.build();
                }
            });
        }

        @Override
        public List<AnnotationValue> getValue() {
            return (List)this.elements.get();
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitArray((List)this.elements.get(), p);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            Joiner.on((String)", ").appendTo(sb, (Iterable)this.elements.get());
            sb.append("}");
            return sb.toString();
        }

        @Override
        public Const value() {
            return this.value;
        }
    }
}

