/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Pool {
    public static final int MAX_ENTRIES = 65535;
    public static final int MAX_STRING_LENGTH = 65535;
    int pp;
    Object[] pool;
    Map<Object, Integer> indices;
    Types types;

    public Pool(int n, Object[] objectArray, Types types) {
        this.pp = n;
        this.pool = objectArray;
        this.types = types;
        this.indices = new HashMap<Object, Integer>(objectArray.length);
        for (int i = 1; i < n; ++i) {
            if (objectArray[i] == null) continue;
            this.indices.put(objectArray[i], i);
        }
    }

    public Pool(Types types) {
        this(1, new Object[64], types);
    }

    public int numEntries() {
        return this.pp;
    }

    public void reset() {
        this.pp = 1;
        this.indices.clear();
    }

    public int put(Object object) {
        Assert.check(!((object = this.makePoolValue(object)) instanceof Type.TypeVar));
        Assert.check(!(object instanceof Types.UniqueType) || !(((Types.UniqueType)object).type instanceof Type.TypeVar));
        Integer n = this.indices.get(object);
        if (n == null) {
            n = this.pp;
            this.indices.put(object, n);
            this.pool = ArrayUtils.ensureCapacity(this.pool, this.pp);
            this.pool[this.pp++] = object;
            if (object instanceof Long || object instanceof Double) {
                this.pool = ArrayUtils.ensureCapacity(this.pool, this.pp);
                this.pool[this.pp++] = null;
            }
        }
        return n;
    }

    Object makePoolValue(Object object) {
        if (object instanceof Symbol.DynamicMethodSymbol) {
            return new DynamicMethod((Symbol.DynamicMethodSymbol)object, this.types);
        }
        if (object instanceof Symbol.MethodSymbol) {
            return new Method((Symbol.MethodSymbol)object, this.types);
        }
        if (object instanceof Symbol.VarSymbol) {
            return new Variable((Symbol.VarSymbol)object, this.types);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            if (type.hasTag(TypeTag.CLASS)) {
                return type.tsym;
            }
            return new Types.UniqueType(type, this.types);
        }
        return object;
    }

    public int get(Object object) {
        Integer n = this.indices.get(object);
        return n == null ? -1 : n;
    }

    public static class MethodHandle {
        int refKind;
        Symbol refSym;
        Types.UniqueType uniqueType;
        Filter<Name> nonInitFilter = name -> name != name.table.names.init && name != name.table.names.clinit;
        Filter<Name> initFilter = name -> name == name.table.names.init;

        public MethodHandle(int n, Symbol symbol, Types types) {
            this.refKind = n;
            this.refSym = symbol;
            this.uniqueType = new Types.UniqueType(this.refSym.type, types);
            this.checkConsistent();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodHandle)) {
                return false;
            }
            MethodHandle methodHandle = (MethodHandle)object;
            if (methodHandle.refKind != this.refKind) {
                return false;
            }
            Symbol symbol = methodHandle.refSym;
            return symbol.name == this.refSym.name && symbol.owner == this.refSym.owner && ((MethodHandle)object).uniqueType.equals(this.uniqueType);
        }

        public int hashCode() {
            return this.refKind * 65 + this.refSym.name.hashCode() * 33 + this.refSym.owner.hashCode() * 9 + this.uniqueType.hashCode();
        }

        private void checkConsistent() {
            boolean bl = false;
            Kinds.Kind kind = null;
            Filter<Name> filter = this.nonInitFilter;
            boolean bl2 = false;
            switch (this.refKind) {
                case 2: 
                case 4: {
                    bl = true;
                }
                case 1: 
                case 3: {
                    kind = Kinds.Kind.VAR;
                    break;
                }
                case 8: {
                    filter = this.initFilter;
                    kind = Kinds.Kind.MTH;
                    break;
                }
                case 9: {
                    bl2 = true;
                    kind = Kinds.Kind.MTH;
                    break;
                }
                case 6: {
                    bl2 = true;
                    bl = true;
                }
                case 5: {
                    kind = Kinds.Kind.MTH;
                    break;
                }
                case 7: {
                    bl2 = true;
                    kind = Kinds.Kind.MTH;
                }
            }
            Assert.check(!this.refSym.isStatic() || bl);
            Assert.check(this.refSym.kind == kind);
            Assert.check(filter.accepts(this.refSym.name));
            Assert.check(!this.refSym.owner.isInterface() || bl2);
        }
    }

    static class Variable
    extends Symbol.DelegatedSymbol<Symbol.VarSymbol> {
        Types.UniqueType uniqueType;

        Variable(Symbol.VarSymbol varSymbol, Types types) {
            super(varSymbol);
            this.uniqueType = new Types.UniqueType(varSymbol.type, types);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Variable)) {
                return false;
            }
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)((Variable)object).other;
            Symbol.VarSymbol varSymbol2 = (Symbol.VarSymbol)this.other;
            return varSymbol.name == varSymbol2.name && varSymbol.owner == varSymbol2.owner && ((Variable)object).uniqueType.equals(this.uniqueType);
        }

        @Override
        public int hashCode() {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)this.other;
            return varSymbol.name.hashCode() * 33 + varSymbol.owner.hashCode() * 9 + this.uniqueType.hashCode();
        }
    }

    static class DynamicMethod
    extends Method {
        public Object[] uniqueStaticArgs;

        DynamicMethod(Symbol.DynamicMethodSymbol dynamicMethodSymbol, Types types) {
            super(dynamicMethodSymbol, types);
            this.uniqueStaticArgs = this.getUniqueTypeArray(dynamicMethodSymbol.staticArgs, types);
        }

        @Override
        public boolean equals(Object object) {
            return this.equalsImpl(object, true);
        }

        protected boolean equalsImpl(Object object, boolean bl) {
            if (bl && !super.equals(object)) {
                return false;
            }
            if (!(object instanceof DynamicMethod)) {
                return false;
            }
            Symbol.DynamicMethodSymbol dynamicMethodSymbol = (Symbol.DynamicMethodSymbol)this.other;
            Symbol.DynamicMethodSymbol dynamicMethodSymbol2 = (Symbol.DynamicMethodSymbol)((DynamicMethod)object).other;
            return dynamicMethodSymbol.bsm == dynamicMethodSymbol2.bsm && dynamicMethodSymbol.bsmKind == dynamicMethodSymbol2.bsmKind && Arrays.equals(this.uniqueStaticArgs, ((DynamicMethod)object).uniqueStaticArgs);
        }

        @Override
        public int hashCode() {
            return this.hashCodeImpl(true);
        }

        protected int hashCodeImpl(boolean bl) {
            int n = bl ? super.hashCode() : 0;
            Symbol.DynamicMethodSymbol dynamicMethodSymbol = (Symbol.DynamicMethodSymbol)this.other;
            n += dynamicMethodSymbol.bsmKind * 7 + dynamicMethodSymbol.bsm.hashCode() * 11;
            for (int i = 0; i < dynamicMethodSymbol.staticArgs.length; ++i) {
                n += this.uniqueStaticArgs[i].hashCode() * 23;
            }
            return n;
        }

        private Object[] getUniqueTypeArray(Object[] objectArray, Types types) {
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] instanceof Type ? new Types.UniqueType((Type)objectArray[i], types) : objectArray[i];
            }
            return objectArray2;
        }

        static class BootstrapMethodsValue {
            final MethodHandle mh;
            final int index;

            public BootstrapMethodsValue(MethodHandle methodHandle, int n) {
                this.mh = methodHandle;
                this.index = n;
            }
        }

        static class BootstrapMethodsKey
        extends DynamicMethod {
            BootstrapMethodsKey(Symbol.DynamicMethodSymbol dynamicMethodSymbol, Types types) {
                super(dynamicMethodSymbol, types);
            }

            @Override
            public boolean equals(Object object) {
                return this.equalsImpl(object, false);
            }

            @Override
            public int hashCode() {
                return this.hashCodeImpl(false);
            }

            Object[] getUniqueArgs() {
                return this.uniqueStaticArgs;
            }
        }
    }

    static class Method
    extends Symbol.DelegatedSymbol<Symbol.MethodSymbol> {
        Types.UniqueType uniqueType;

        Method(Symbol.MethodSymbol methodSymbol, Types types) {
            super(methodSymbol);
            this.uniqueType = new Types.UniqueType(methodSymbol.type, types);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Method)) {
                return false;
            }
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)((Method)object).other;
            Symbol.MethodSymbol methodSymbol2 = (Symbol.MethodSymbol)this.other;
            return methodSymbol.name == methodSymbol2.name && methodSymbol.owner == methodSymbol2.owner && ((Method)object).uniqueType.equals(this.uniqueType);
        }

        @Override
        public int hashCode() {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)this.other;
            return methodSymbol.name.hashCode() * 33 + methodSymbol.owner.hashCode() * 9 + this.uniqueType.hashCode();
        }
    }
}

