/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.Platform;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import junit.framework.Assert;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class SpliteratorTester<E> {
    private final Supplier<Spliterator<E>> spliteratorSupplier;

    private static <E> @Nullable Spliterator<E> trySplitTestingSize(Spliterator<E> spliterator) {
        boolean subsized = spliterator.hasCharacteristics(16384);
        long originalSize = spliterator.estimateSize();
        Spliterator<E> trySplit = spliterator.trySplit();
        if (spliterator.estimateSize() > originalSize) {
            Assert.fail((String)Platform.format("estimated size of spliterator after trySplit (%s) is larger than original size (%s)", spliterator.estimateSize(), originalSize));
        }
        if (trySplit != null && trySplit.estimateSize() > originalSize) {
            Assert.fail((String)Platform.format("estimated size of trySplit result (%s) is larger than original size (%s)", trySplit.estimateSize(), originalSize));
        }
        if (subsized) {
            if (trySplit != null) {
                Assert.assertEquals((String)"sum of estimated sizes of trySplit and original spliterator after trySplit", (long)originalSize, (long)(trySplit.estimateSize() + spliterator.estimateSize()));
            } else {
                Assert.assertEquals((String)"estimated size of spliterator after failed trySplit", (long)originalSize, (long)spliterator.estimateSize());
            }
        }
        return trySplit;
    }

    public static <E> SpliteratorTester<E> of(Supplier<Spliterator<E>> spliteratorSupplier) {
        return new SpliteratorTester<E>(spliteratorSupplier);
    }

    private SpliteratorTester(Supplier<Spliterator<E>> spliteratorSupplier) {
        this.spliteratorSupplier = (Supplier)Preconditions.checkNotNull(spliteratorSupplier);
    }

    @SafeVarargs
    public final Ordered expect(Object ... elements) {
        return this.expect(Arrays.asList(elements));
    }

    public final Ordered expect(final Iterable<?> elements) {
        final ArrayList resultsForAllStrategies = new ArrayList();
        Spliterator<E> spliterator = this.spliteratorSupplier.get();
        int characteristics = spliterator.characteristics();
        long estimatedSize = spliterator.estimateSize();
        for (SpliteratorDecompositionStrategy strategy : EnumSet.allOf(SpliteratorDecompositionStrategy.class)) {
            ArrayList resultsForStrategy = new ArrayList();
            strategy.forEach(this.spliteratorSupplier.get(), resultsForStrategy::add);
            if ((characteristics & 0x100) != 0) {
                Assert.assertFalse((boolean)resultsForStrategy.contains(null));
            }
            if ((characteristics & 4) != 0) {
                Comparator<Object> comparator = spliterator.getComparator();
                if (comparator == null) {
                    comparator = Comparator.naturalOrder();
                }
                Assert.assertTrue((boolean)Ordering.from(comparator).isOrdered(resultsForStrategy));
            }
            if ((characteristics & 0x40) != 0) {
                Assert.assertEquals((int)Ints.checkedCast((long)estimatedSize), (int)resultsForStrategy.size());
            }
            Helpers.assertEqualIgnoringOrder(elements, resultsForStrategy);
            resultsForAllStrategies.add(resultsForStrategy);
        }
        return new Ordered(){

            @Override
            public void inOrder() {
                resultsForAllStrategies.forEach(resultsForStrategy -> Helpers.assertEqualInOrder(elements, resultsForStrategy));
            }
        };
    }

    static enum SpliteratorDecompositionStrategy {
        NO_SPLIT_FOR_EACH_REMAINING{

            @Override
            <E> void forEach(Spliterator<E> spliterator, Consumer<? super E> consumer) {
                spliterator.forEachRemaining(consumer);
            }
        }
        ,
        NO_SPLIT_TRY_ADVANCE{

            @Override
            <E> void forEach(Spliterator<E> spliterator, Consumer<? super E> consumer) {
                while (spliterator.tryAdvance(consumer)) {
                }
            }
        }
        ,
        MAXIMUM_SPLIT{

            @Override
            <E> void forEach(Spliterator<E> spliterator, Consumer<? super E> consumer) {
                Spliterator prefix = SpliteratorTester.trySplitTestingSize(spliterator);
                while (prefix != null) {
                    this.forEach(prefix, consumer);
                    prefix = SpliteratorTester.trySplitTestingSize(spliterator);
                }
                long size = spliterator.getExactSizeIfKnown();
                long[] counter = new long[]{0L};
                spliterator.forEachRemaining(e -> {
                    consumer.accept((Object)e);
                    counter[0] = counter[0] + 1L;
                });
                if (size >= 0L) {
                    Assert.assertEquals((long)size, (long)counter[0]);
                }
            }
        }
        ,
        ALTERNATE_ADVANCE_AND_SPLIT{

            @Override
            <E> void forEach(Spliterator<E> spliterator, Consumer<? super E> consumer) {
                while (spliterator.tryAdvance(consumer)) {
                    Spliterator prefix = SpliteratorTester.trySplitTestingSize(spliterator);
                    if (prefix == null) continue;
                    this.forEach(prefix, consumer);
                }
            }
        };


        abstract <E> void forEach(Spliterator<E> var1, Consumer<? super E> var2);
    }

    public static interface Ordered {
        public void inOrder();
    }
}

