/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public final class Enums {
    private static final ConcurrentMap<Class<? extends Enum<?>>, Map<String, ? extends Enum<?>>> CACHE = new ConcurrentHashMap();

    private Enums() {
    }

    public static <V extends Enum<V>> V get(Class<V> type, String value) {
        Map map = CACHE.computeIfAbsent(type, k -> Arrays.stream((Enum[])type.getEnumConstants()).collect(Collectors.toMap(Enum::toString, t -> t, (f, s) -> f)));
        return (V)((Enum)map.get(value));
    }

    @SafeVarargs
    public static <V extends Enum<V>> boolean oneOf(V value, V ... candidates) {
        for (V c : candidates) {
            if (value != c) continue;
            return true;
        }
        return false;
    }

    public static String string(Enum<?> en) {
        return en.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }
}

