/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQHashMap;
import org.basex.query.value.map.XQIntValueMap;
import org.basex.query.value.map.XQItemValueMap;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.list.TokenList;

public final class XQIntStrMap
extends XQHashMap {
    private static final MapType TYPE = MapType.get(AtomType.INTEGER, SeqType.STRING_O);
    private final IntObjectMap<byte[]> map;

    XQIntStrMap(int capacity) {
        super(TYPE);
        this.map = new IntObjectMap(capacity);
    }

    @Override
    public long structSize() {
        return this.map.size();
    }

    @Override
    public Value getOrNull(Item key) {
        int i;
        int v;
        ANum num;
        double d;
        if (key instanceof ANum && (d = (num = (ANum)key).dbl()) == (double)(v = (int)d) && (i = this.map.index(v)) != 0) {
            return this.valueAt(i - 1);
        }
        return null;
    }

    @Override
    public Value keys() {
        return IntSeq.get(this.map.keys());
    }

    @Override
    public Value items(QueryContext qc) {
        long is = this.structSize();
        TokenList list = new TokenList(is);
        int i = 1;
        while ((long)i <= is) {
            list.add(this.map.value(i));
            ++i;
        }
        return StrSeq.get(list);
    }

    @Override
    public Item keyAt(int index) {
        return Itr.get(this.map.key(index + 1));
    }

    @Override
    public Value valueAt(int index) {
        return Str.get(this.map.value(index + 1));
    }

    @Override
    XQHashMap build(Item key, Value value) throws QueryException {
        int k = XQIntStrMap.toInt(key);
        byte[] v = XQIntStrMap.toStr(value);
        if (k != Integer.MIN_VALUE) {
            if (v != null) {
                this.map.put(k, v);
                return this;
            }
            return new XQIntValueMap(this.map.capacity() - 2).build(this).build(key, value);
        }
        return new XQItemValueMap(this.map.capacity() - 2).build(this).build(key, value);
    }
}

