/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.ws;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.basex.core.Context;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPContext;
import org.basex.http.web.WebModules;
import org.basex.http.ws.WsFunction;
import org.basex.http.ws.WsPath;
import org.basex.http.ws.WsPool;
import org.basex.http.ws.WsResponse;
import org.basex.query.ann.Annotation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.seq.StrSeq;
import org.basex.server.ClientInfo;
import org.basex.util.Performance;
import org.basex.util.Util;
import org.basex.util.list.TokenList;
import org.basex.util.log.LogType;
import org.eclipse.jetty.ee9.websocket.api.Session;
import org.eclipse.jetty.ee9.websocket.api.UpgradeRequest;
import org.eclipse.jetty.ee9.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.ee9.websocket.api.exceptions.CloseException;

public final class WebSocket
extends WebSocketAdapter
implements ClientInfo {
    public final ConcurrentHashMap<String, Value> atts = new ConcurrentHashMap();
    public final Context context;
    public final WsPath path;
    final Map<String, Value> headers = new HashMap<String, Value>();
    final HttpServletRequest request;
    public String id;
    public HttpSession session;

    private WebSocket(HttpServletRequest request) {
        this.request = request;
        String pi = request.getPathInfo();
        this.path = new WsPath(pi != null ? pi : "/");
        this.session = request.getSession();
        this.context = new Context(HTTPContext.get().context(), (ClientInfo)this);
    }

    static WebSocket get(HttpServletRequest request) {
        WebSocket ws = new WebSocket(request);
        try {
            if (!WebModules.get(ws.context).findWs(ws, null).isEmpty()) {
                return ws;
            }
        }
        catch (Exception ex) {
            Util.debug((Throwable)ex);
            throw new CloseException(1006, ex.getMessage());
        }
        return null;
    }

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        this.id = WsPool.add(this);
        this.run("[WS-OPEN] " + String.valueOf(this.request.getRequestURL()), null, () -> {
            UpgradeRequest ur = sess.getUpgradeRequest();
            BiConsumer<String, String> addHeader = (k, v) -> {
                if (v != null) {
                    this.headers.put((String)k, (Value)Atm.get((String)v));
                }
            };
            addHeader.accept("http-version", ur.getHttpVersion());
            addHeader.accept("origin", ur.getOrigin());
            addHeader.accept("protocol-version", ur.getProtocolVersion());
            addHeader.accept("query-string", ur.getQueryString());
            addHeader.accept("is-secure", String.valueOf(ur.isSecure()));
            addHeader.accept("request-uri", ur.getRequestURI().toString());
            addHeader.accept("host", ur.getHost());
            TokenList protocols = new TokenList();
            for (String protocol : ur.getSubProtocols()) {
                protocols.add(protocol);
            }
            this.headers.put("sub-protocols", StrSeq.get((TokenList)protocols));
            this.findAndProcess(Annotation._WS_CONNECT, null);
        });
    }

    public void onWebSocketError(Throwable th) {
        String m1 = th.getMessage();
        String m2 = Util.message((Throwable)th);
        String msg = m1 != null ? m1 : m2;
        this.run("[WS-ERROR] " + String.valueOf(this.request.getRequestURL()) + ": " + msg, null, () -> this.findAndProcess(Annotation._WS_ERROR, msg));
    }

    public void onWebSocketClose(int status, String message) {
        try {
            this.run("[WS-CLOSE] " + String.valueOf(this.request.getRequestURL()), status, () -> this.findAndProcess(Annotation._WS_CLOSE, null));
        }
        finally {
            WsPool.remove(this.id);
            super.onWebSocketClose(status, message);
        }
    }

    public void onWebSocketText(String message) {
        this.findAndProcess(Annotation._WS_MESSAGE, message);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.findAndProcess(Annotation._WS_MESSAGE, payload);
    }

    public String clientAddress() {
        return HTTPConnection.remoteAddress(this.request);
    }

    public String clientName() {
        Object value = this.atts.get("id");
        if (value == null && this.session != null) {
            value = this.session.getAttribute("id");
        }
        return this.clientName(value, this.context);
    }

    public void close() {
        WsPool.remove(this.id);
        this.getSession().close();
    }

    private void findAndProcess(Annotation ann, Object message) {
        try {
            if (this.session != null) {
                this.session.getCreationTime();
            }
        }
        catch (IllegalStateException ex) {
            Util.debug((Throwable)ex);
            this.session = null;
        }
        try {
            WsFunction func = WebModules.get(this.context).websocket(this, ann);
            if (func != null) {
                new WsResponse(this).create(func, message, true);
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    public void error(Exception ex) {
        Util.debug((Throwable)ex);
        try {
            this.getRemote().sendString(ex.getMessage());
        }
        catch (IOException e) {
            Util.debug((Throwable)e);
        }
    }

    private void run(String info, Integer status, Runnable func) {
        this.context.log.write((Object)LogType.REQUEST, info, null, this.context);
        Performance perf = new Performance();
        try {
            func.run();
        }
        catch (Exception ex) {
            this.context.log.write((Object)LogType.ERROR, "", perf, this.context);
            throw ex;
        }
        this.context.log.write((Object)(status != null ? status : LogType.OK), null, perf, this.context);
    }
}

