// Copyright 2010 Google Inc. All Rights Reserved.

package com.google.appengine.api.datastore;

/**
 * Attributes of a datastore.
 *
 */
public final class DatastoreAttributes {
  /**
   * Indicates the type of datastore being used. Currently always returns HIGH_REPLICATION.
   *
   */
  public enum DatastoreType {
    UNKNOWN,
    MASTER_SLAVE,
    HIGH_REPLICATION,
  }

  private final DatastoreType datastoreType;

  DatastoreAttributes() {
    datastoreType = DatastoreType.HIGH_REPLICATION;
  }

  /**
   * Gets the datastore type.
   *
   * <p>Only guaranteed to return something other than {@link DatastoreType#UNKNOWN} when running in
   * production and querying the current app.
   */
  public DatastoreType getDatastoreType() {
    return datastoreType;
  }
}
