/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.api.server.spi.tools.GenApiConfigAction;
import com.google.api.server.spi.tools.GenClientLibAction;
import com.google.api.server.spi.tools.GenDiscoveryDocAction;
import com.google.api.server.spi.tools.GetClientLibAction;
import com.google.api.server.spi.tools.GetDiscoveryDocAction;
import com.google.api.server.spi.tools.HelpAction;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Parser;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class EndpointsTool {
    private final Map<String, EndpointsToolAction> actions = new LinkedHashMap<String, EndpointsToolAction>();

    public EndpointsTool() {
        this.actions.put("get-discovery-doc", new GetDiscoveryDocAction());
        this.actions.put("get-client-lib", new GetClientLibAction());
        this.actions.put("gen-api-config", new GenApiConfigAction());
        this.actions.put("gen-discovery-doc", new GenDiscoveryDocAction());
        this.actions.put("gen-client-lib", new GenClientLibAction());
        this.actions.put("help", new HelpAction());
    }

    @VisibleForTesting
    Map<String, EndpointsToolAction> getActions() {
        return this.actions;
    }

    public void execute(String[] args) throws Exception {
        if (args.length < 1) {
            this.printUsage();
            return;
        }
        EndpointsToolAction action = this.getActions().get(args[0]);
        if (action == null) {
            this.printUsage();
            return;
        }
        Parser parser = new Parser();
        Parser.ParseResult r = parser.parseArgs((Action)action, action.getOptions(), Arrays.copyOfRange(args, 1, args.length));
        r.applyArgs();
        if (!action.execute()) {
            this.printUsage(action);
        }
    }

    public void printUsage() {
        System.out.println("Command line tool for Google Cloud Endpoints.");
        System.out.println("");
        System.out.println("usage: <endpoints-tool> <command> <options> [args]");
        System.out.println();
        System.out.println("<command> must be one of:\n");
        for (EndpointsToolAction action : this.actions.values()) {
            if (!action.isHelpDisplayNeeded()) continue;
            System.out.println(action.getNameString());
        }
        System.out.println();
        System.out.println("Use 'help <command>' for a detailed description of a command.");
    }

    public void printUsage(Action action) {
        System.out.println(action.getHelpString());
    }

    public static void main(String[] args) {
        try {
            new EndpointsTool().execute(args);
        }
        catch (Exception e) {
            String string = String.valueOf(e.getMessage());
            System.err.println(string.length() != 0 ? "Error: ".concat(string) : new String("Error: "));
        }
    }
}

