/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Transaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.appengine.BatchDeleteManager;
import org.datanucleus.store.appengine.DatastoreDeleteFieldManager;
import org.datanucleus.store.appengine.DatastoreExceptionTranslator;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.DependentDeleteRequest;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.FetchMappingConsumer;
import org.datanucleus.store.appengine.ForceFlushPreCommitTransactionEventListener;
import org.datanucleus.store.appengine.KeyRegistry;
import org.datanucleus.store.appengine.StorageVersion;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastorePersistenceHandler
implements StorePersistenceHandler {
    static final Object ENTITY_WRITE_DELAYED = "___entity_write_delayed___";
    static final String MISSING_RELATION_KEY = "___missing_relation_key___";
    private final DatastoreService datastoreServiceForReads;
    private final DatastoreService datastoreServiceForWrites;
    private final DatastoreManager storeMgr;
    private static final Object INSERTION_TOKEN = new Object();

    public DatastorePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (DatastoreManager)storeMgr;
        this.datastoreServiceForReads = DatastoreServiceFactoryInternal.getDatastoreService(this.storeMgr.getDefaultDatastoreServiceConfigForReads());
        this.datastoreServiceForWrites = DatastoreServiceFactoryInternal.getDatastoreService(this.storeMgr.getDefaultDatastoreServiceConfigForWrites());
    }

    Entity get(DatastoreTransaction txn, Key key) {
        NucleusLogger.DATASTORE.debug((Object)("Getting entity of kind " + key.getKind() + " with key " + key));
        try {
            Entity entity = txn == null ? this.datastoreServiceForReads.get(key) : this.datastoreServiceForReads.get(txn.getInnerTxn(), key);
            return entity;
        }
        catch (EntityNotFoundException e) {
            throw DatastoreExceptionTranslator.wrapEntityNotFoundException(e, key);
        }
    }

    private Entity get(StateManager sm, Key key) {
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(sm.getObjectManager());
        Entity entity = this.get(txn, key);
        this.setAssociatedEntity(sm, txn, entity);
        return entity;
    }

    private void put(List<PutState> putStateList) {
        if (putStateList.isEmpty()) {
            return;
        }
        DatastoreTransaction txn = null;
        ObjectManager om = null;
        AbstractClassMetaData acmd = null;
        ArrayList<Object> entityList = Utils.newArrayList(new Object[0]);
        for (PutState putState : putStateList) {
            if (txn == null) {
                txn = EntityUtils.getCurrentTransaction(putState.sm.getObjectManager());
            }
            if (om == null) {
                om = putState.sm.getObjectManager();
            }
            if (acmd == null) {
                acmd = putState.sm.getClassMetaData();
            }
            entityList.add(putState.entity);
        }
        this.put(om, acmd, entityList);
        for (PutState putState : putStateList) {
            this.setAssociatedEntity(putState.sm, txn, putState.entity);
        }
    }

    private void put(StateManager sm, Entity entity) {
        DatastoreTransaction txn = this.put(sm.getObjectManager(), sm.getClassMetaData(), entity);
        this.setAssociatedEntity(sm, txn, entity);
    }

    DatastoreTransaction put(ObjectManager om, AbstractClassMetaData acmd, Entity entity) {
        return this.put(om, acmd, Collections.singletonList(entity));
    }

    private DatastoreTransaction put(ObjectManager om, AbstractClassMetaData acmd, List<Entity> entities) {
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(om);
        ArrayList<Object> putMe = Utils.newArrayList(new Object[0]);
        for (Entity entity : entities) {
            Entity previouslyPut;
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)("Putting entity of kind " + entity.getKind() + " with key " + entity.getKey()));
                for (Map.Entry entry : entity.getProperties().entrySet()) {
                    NucleusLogger.DATASTORE.debug((Object)("  " + (String)entry.getKey() + " : " + entry.getValue()));
                }
            }
            if (txn == null) {
                putMe.add(entity);
                continue;
            }
            if (txn.getDeletedKeys().contains(entity.getKey()) || (previouslyPut = txn.getPutEntities().get(entity.getKey())) != null && ((Object)previouslyPut.getProperties()).equals(entity.getProperties())) continue;
            putMe.add(entity);
        }
        if (!putMe.isEmpty()) {
            for (Entity entity : putMe) {
                this.validate(om, acmd, entity);
            }
            if (txn == null) {
                if (putMe.size() == 1) {
                    this.datastoreServiceForWrites.put((Entity)putMe.get(0));
                } else {
                    this.datastoreServiceForWrites.put(putMe);
                }
            } else {
                Transaction innerTxn = txn.getInnerTxn();
                if (putMe.size() == 1) {
                    this.datastoreServiceForWrites.put(innerTxn, (Entity)putMe.get(0));
                } else {
                    this.datastoreServiceForWrites.put(innerTxn, putMe);
                }
                txn.addPutEntities(putMe);
            }
        }
        return txn;
    }

    void delete(DatastoreTransaction txn, List<Key> keys) {
        NucleusLogger.DATASTORE.debug((Object)("Deleting entities with keys " + keys));
        if (txn == null) {
            if (keys.size() == 1) {
                this.datastoreServiceForWrites.delete(new Key[]{keys.get(0)});
            } else {
                this.datastoreServiceForWrites.delete(keys);
            }
        } else {
            Transaction innerTxn = txn.getInnerTxn();
            if (keys.size() == 1) {
                this.datastoreServiceForWrites.delete(innerTxn, new Key[]{keys.get(0)});
            } else {
                this.datastoreServiceForWrites.delete(innerTxn, keys);
            }
        }
    }

    public void insertObject(StateManager sm) {
        if (this.storeMgr.getBatchPutManager().batchOperationInProgress()) {
            this.storeMgr.getBatchPutManager().add(sm);
            return;
        }
        this.insertObjects(Collections.singletonList(sm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertObjects(List<StateManager> stateManagersToInsert) {
        try {
            List<PutState> putStateList = this.insertPreProcess(stateManagersToInsert);
            this.put(putStateList);
            this.insertPostProcess(putStateList);
        }
        finally {
            for (StateManager sm : stateManagersToInsert) {
                sm.setAssociatedValue(INSERTION_TOKEN, null);
            }
        }
    }

    private void insertPostProcess(List<PutState> putStateList) {
        for (PutState putState : putStateList) {
            Integer pkIdPos;
            Object newObjectId;
            Class pkType = putState.acmd.getMetaDataForManagedMemberAtAbsolutePosition(putState.acmd.getPKMemberPositions()[0]).getType();
            if (pkType.equals(Key.class)) {
                newObjectId = putState.entity.getKey();
            } else if (pkType.equals(String.class)) {
                newObjectId = DatastoreManager.hasEncodedPKField(putState.acmd) ? KeyFactory.keyToString((Key)putState.entity.getKey()) : putState.entity.getKey().getName();
            } else if (pkType.equals(Long.class)) {
                newObjectId = putState.entity.getKey().getId();
            } else {
                throw new IllegalStateException("Primary key for type " + putState.sm.getClassMetaData().getName() + " is of unexpected type " + pkType.getName() + " (must be String, Long, or " + Key.class.getName() + ")");
            }
            putState.sm.setPostStoreNewObjectId(newObjectId);
            if (putState.assignedParentPk != null) {
                this.setPostStoreNewParent(putState.sm, putState.fieldMgr.getParentMemberMetaData(), putState.assignedParentPk);
            }
            if ((pkIdPos = putState.fieldMgr.getPkIdPos()) != null) {
                this.setPostStorePkId(putState.sm, pkIdPos, putState.entity);
            }
            this.storeRelations(putState.fieldMgr, putState.sm, putState.entity);
            if (putState.entity.getParent() != null) {
                KeyRegistry keyReg = KeyRegistry.getKeyRegistry(putState.sm.getObjectManager());
                keyReg.registerModifiedParent(putState.entity.getParent());
            }
            if (this.storeMgr.getRuntimeManager() == null) continue;
            this.storeMgr.getRuntimeManager().incrementInsertCount();
        }
    }

    private List<PutState> insertPreProcess(List<StateManager> stateManagersToInsert) {
        ArrayList<Object> putStateList = Utils.newArrayList(new Object[0]);
        for (StateManager sm : stateManagersToInsert) {
            if (sm.getAssociatedValue(INSERTION_TOKEN) != null) continue;
            sm.setAssociatedValue(INSERTION_TOKEN, INSERTION_TOKEN);
            this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
            this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
            String kind = EntityUtils.determineKind(sm.getClassMetaData(), sm.getObjectManager());
            DatastoreFieldManager fieldMgr = new DatastoreFieldManager(sm, kind, this.storeMgr, DatastoreFieldManager.Operation.INSERT);
            AbstractClassMetaData acmd = sm.getClassMetaData();
            sm.provideFields(acmd.getAllMemberPositions(), (FieldManager)fieldMgr);
            Object assignedParentPk = fieldMgr.establishEntityGroup();
            Entity entity = fieldMgr.getEntity();
            if (fieldMgr.handleIndexFields()) {
                sm.setAssociatedValue(ENTITY_WRITE_DELAYED, (Object)entity);
                continue;
            }
            this.handleVersioningBeforeWrite(sm, entity, VersionBehavior.INCREMENT, "updating");
            this.handleDiscriminatorBeforeInsert(sm, entity);
            putStateList.add(new PutState(sm, fieldMgr, acmd, assignedParentPk, entity));
        }
        return putStateList;
    }

    private void setPostStorePkId(StateManager sm, int fieldNumber, Entity entity) {
        sm.replaceField(fieldNumber, (Object)entity.getKey().getId(), true);
    }

    private void setPostStoreNewParent(StateManager sm, AbstractMemberMetaData parentMemberMetaData, Object assignedParentPk) {
        sm.replaceField(parentMemberMetaData.getAbsoluteFieldNumber(), assignedParentPk, true);
    }

    IdentifierFactory getIdentifierFactory(StateManager sm) {
        return ((MappedStoreManager)sm.getObjectManager().getStoreManager()).getIdentifierFactory();
    }

    private NucleusOptimisticException newNucleusOptimisticException(AbstractClassMetaData cmd, Entity entity, String op, String details) {
        return new NucleusOptimisticException("Optimistic concurrency exception " + op + " " + cmd.getFullClassName() + " with pk " + entity.getKey() + ".  " + details);
    }

    private void handleVersioningBeforeWrite(StateManager sm, Entity entity, VersionBehavior versionBehavior, String op) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.hasVersionStrategy()) {
            VersionMetaData vmd = cmd.getVersionMetaData();
            Object curVersion = sm.getObjectManager().getApiAdapter().getVersion(sm);
            if (curVersion != null) {
                Entity refreshedEntity;
                NucleusLogger.DATASTORE.debug((Object)("Getting entity with key " + entity.getKey()));
                try {
                    refreshedEntity = this.datastoreServiceForReads.get(entity.getKey());
                }
                catch (EntityNotFoundException e) {
                    throw this.newNucleusOptimisticException(cmd, entity, op, "The underlying entity had already been deleted.");
                }
                if (!EntityUtils.getVersionFromEntity(this.getIdentifierFactory(sm), vmd, refreshedEntity).equals(curVersion)) {
                    throw this.newNucleusOptimisticException(cmd, entity, op, "The underlying entity had already been updated.");
                }
            }
            Object nextVersion = vmd.getNextVersion(curVersion);
            sm.setTransactionalVersion(nextVersion);
            String versionPropertyName = EntityUtils.getVersionPropertyName(this.getIdentifierFactory(sm), vmd);
            entity.setProperty(versionPropertyName, nextVersion);
            if (versionBehavior == VersionBehavior.INCREMENT && vmd.getFieldName() != null) {
                AbstractMemberMetaData verfmd = ((AbstractClassMetaData)vmd.getParent()).getMetaDataForMember(vmd.getFieldName());
                if (nextVersion instanceof Number) {
                    Number nextNumber = (Number)nextVersion;
                    if (verfmd.getType().equals(Long.class) || verfmd.getType().equals(Long.TYPE)) {
                        nextVersion = nextNumber.longValue();
                    } else if (verfmd.getType().equals(Integer.class) || verfmd.getType().equals(Integer.TYPE)) {
                        nextVersion = nextNumber.intValue();
                    } else if (verfmd.getType().equals(Short.class) || verfmd.getType().equals(Short.TYPE)) {
                        nextVersion = nextNumber.shortValue();
                    }
                }
                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextVersion, false);
            }
        }
    }

    private void handleDiscriminatorBeforeInsert(StateManager sm, Entity entity) {
        DatastoreTable table = this.storeMgr.getDatastoreClass(sm.getClassMetaData().getFullClassName(), sm.getObjectManager().getClassLoaderResolver());
        if (table.getDiscriminatorMapping(false) != null) {
            DiscriminatorMetaData dismd = table.getDiscriminatorMetaData();
            JavaTypeMapping mapping = table.getDiscriminatorMapping(false);
            String propertyName = mapping.getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifierName();
            if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                entity.setProperty(propertyName, (Object)sm.getObject().getClass().getName());
            } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                dismd = sm.getClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData();
                if (mapping.getDataStoreMapping(0).getJavaTypeMapping().getJavaType() == Long.class) {
                    entity.setProperty(propertyName, (Object)Long.parseLong(dismd.getValue()));
                } else {
                    entity.setProperty(propertyName, (Object)dismd.getValue());
                }
            }
        }
    }

    private static Object getPk(StateManager sm) {
        return sm.getObjectManager().getApiAdapter().getTargetKeyForSingleFieldIdentity(sm.getInternalObjectId());
    }

    private static Key getPkAsKey(StateManager sm) {
        Object pk = DatastorePersistenceHandler.getPk(sm);
        if (pk == null) {
            throw new IllegalStateException("Primary key for object of type " + sm.getClassMetaData().getName() + " is null.");
        }
        return EntityUtils.getPkAsKey(pk, sm.getClassMetaData(), sm.getObjectManager());
    }

    public void setAssociatedEntity(StateManager sm, DatastoreTransaction txn, Entity entity) {
        sm.setAssociatedValue((Object)txn, (Object)entity);
    }

    Entity getAssociatedEntityForCurrentTransaction(StateManager sm) {
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(sm.getObjectManager());
        return (Entity)sm.getAssociatedValue((Object)txn);
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        Entity entity = this.getAssociatedEntityForCurrentTransaction(sm);
        if (entity == null) {
            Key pk = DatastorePersistenceHandler.getPkAsKey(sm);
            entity = this.get(sm, pk);
        }
        sm.replaceFields(fieldNumbers, (FieldManager)new DatastoreFieldManager(sm, this.storeMgr, entity, fieldNumbers, DatastoreFieldManager.Operation.READ));
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.hasVersionStrategy()) {
            sm.setTransactionalVersion(EntityUtils.getVersionFromEntity(this.getIdentifierFactory(sm), cmd.getVersionMetaData(), entity));
        }
        this.runPostFetchMappingCallbacks(sm, fieldNumbers);
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementFetchCount();
        }
    }

    private void runPostFetchMappingCallbacks(StateManager sm, int[] fieldNumbers) {
        AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[fieldNumbers.length];
        for (int i = 0; i < fmds.length; ++i) {
            fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreTable dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        FetchMappingConsumer consumer = new FetchMappingConsumer(sm.getClassMetaData());
        dc.provideMappingsForMembers(consumer, fmds, true);
        dc.provideDatastoreIdMappings(consumer);
        dc.providePrimaryKeyMappings(consumer);
        for (MappingCallbacks callback : consumer.getMappingCallbacks()) {
            callback.postFetch(sm);
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        if (sm.isDeleted((PersistenceCapable)sm.getObject())) {
            return;
        }
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        Entity entity = this.getAssociatedEntityForCurrentTransaction(sm);
        if (entity == null) {
            Key key = DatastorePersistenceHandler.getPkAsKey(sm);
            entity = this.get(sm, key);
        }
        DatastoreFieldManager fieldMgr = new DatastoreFieldManager(sm, this.storeMgr, entity, fieldNumbers, DatastoreFieldManager.Operation.UPDATE);
        sm.provideFields(fieldNumbers, (FieldManager)fieldMgr);
        this.handleVersioningBeforeWrite(sm, entity, VersionBehavior.INCREMENT, "updating");
        this.put(sm, entity);
        this.storeRelations(fieldMgr, sm, entity);
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementUpdateCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeRelations(DatastoreFieldManager fieldMgr, StateManager sm, Entity entity) {
        if (fieldMgr.storeRelations() && this.storeMgr.storageVersionAtLeast(StorageVersion.WRITE_OWNED_CHILD_KEYS_TO_PARENTS)) {
            ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
            boolean missingRelationKey = false;
            try {
                fieldMgr.setRepersistingForChildKeys(true);
                AbstractClassMetaData acmd = sm.getClassMetaData();
                for (int field : acmd.getRelationMemberPositions(clr)) {
                    sm.provideFields(new int[]{field}, (FieldManager)fieldMgr);
                    if (sm.getAssociatedValue((Object)MISSING_RELATION_KEY) != null) {
                        missingRelationKey = true;
                    }
                    sm.setAssociatedValue((Object)MISSING_RELATION_KEY, null);
                }
            }
            finally {
                fieldMgr.setRepersistingForChildKeys(false);
            }
            if (!missingRelationKey) {
                sm.setAssociatedValue((Object)ForceFlushPreCommitTransactionEventListener.ALREADY_PERSISTED_RELATION_KEYS_KEY, (Object)true);
                this.put(sm, entity);
            }
        }
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        Entity entity = this.getAssociatedEntityForCurrentTransaction(sm);
        if (entity == null) {
            Key key = DatastorePersistenceHandler.getPkAsKey(sm);
            entity = this.get(sm, key);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreTable dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(sm.getObjectManager());
        if (txn != null) {
            if (txn.getDeletedKeys().contains(entity.getKey())) {
                return;
            }
            txn.addDeletedKey(entity.getKey());
        } else if (Boolean.TRUE.equals(sm.getAssociatedValue((Object)"deleted"))) {
            return;
        }
        sm.setAssociatedValue((Object)"deleted", (Object)true);
        DependentDeleteRequest req = new DependentDeleteRequest(dc, sm.getClassMetaData(), clr);
        req.execute(sm, entity);
        DatastoreDeleteFieldManager fieldMgr = new DatastoreDeleteFieldManager(sm, this.storeMgr, entity);
        AbstractClassMetaData acmd = sm.getClassMetaData();
        sm.provideFields(acmd.getNonPKMemberPositions(), (FieldManager)fieldMgr);
        this.handleVersioningBeforeWrite(sm, entity, VersionBehavior.NO_INCREMENT, "deleting");
        Key keyToDelete = DatastorePersistenceHandler.getPkAsKey(sm);
        BatchDeleteManager bdm = this.storeMgr.getBatchDeleteManager();
        if (bdm.batchOperationInProgress()) {
            bdm.add(new BatchDeleteManager.BatchDeleteState(txn, keyToDelete));
            return;
        }
        this.delete(txn, Collections.singletonList(keyToDelete));
    }

    public void locateObject(StateManager sm) {
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        this.get(sm, DatastorePersistenceHandler.getPkAsKey(sm));
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void close() {
    }

    private void validate(ObjectManager om, AbstractClassMetaData acmd, Entity entity) {
        DatastoreTable table = this.storeMgr.getDatastoreClass(acmd.getFullClassName(), om.getClassLoaderResolver());
        for (Map.Entry prop : entity.getProperties().entrySet()) {
            DatastoreField field = table.getDatastoreField((String)prop.getKey());
            if (field == null || field.isNullable() || prop.getValue() != null) continue;
            throw new NucleusDataStoreException("non-null property " + (String)prop.getKey() + " of " + entity.getKind() + " is null");
        }
    }

    private static final class PutState {
        private final StateManager sm;
        private final DatastoreFieldManager fieldMgr;
        private final AbstractClassMetaData acmd;
        private final Object assignedParentPk;
        private final Entity entity;

        private PutState(StateManager sm, DatastoreFieldManager fieldMgr, AbstractClassMetaData acmd, Object assignedParentPk, Entity entity) {
            this.sm = sm;
            this.fieldMgr = fieldMgr;
            this.acmd = acmd;
            this.assignedParentPk = assignedParentPk;
            this.entity = entity;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VersionBehavior {
        INCREMENT,
        NO_INCREMENT;

    }
}

