/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AutoValue_StagingOptions;
import com.google.auto.value.AutoValue;
import java.nio.charset.Charset;

@AutoValue
public abstract class StagingOptions {
    public static final StagingOptions EMPTY = StagingOptions.builder().build();
    public static final StagingOptions ANCIENT_DEFAULTS = StagingOptions.builder().setSplitJarFiles(Optional.of(false)).setSplitJarFilesExcludes(Optional.of(ImmutableSortedSet.of())).setJarJsps(Optional.of(true)).setJarClasses(Optional.of(false)).setDeleteJsps(Optional.of(false)).setCompileEncoding(Optional.of("UTF-8")).build();
    public static final StagingOptions SANE_DEFAULTS = StagingOptions.builder().setSplitJarFiles(Optional.of(true)).setSplitJarFilesExcludes(Optional.of(ImmutableSortedSet.of())).setJarJsps(Optional.of(true)).setJarClasses(Optional.of(true)).setDeleteJsps(Optional.of(true)).setCompileEncoding(Optional.of("UTF-8")).build();

    public abstract Optional<Boolean> splitJarFiles();

    public abstract Optional<ImmutableSortedSet<String>> splitJarFilesExcludes();

    public abstract Optional<Boolean> jarJsps();

    public abstract Optional<Boolean> jarClasses();

    public abstract Optional<Boolean> deleteJsps();

    public abstract Optional<String> compileEncoding();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_StagingOptions.Builder();
    }

    public void validate() {
        if (!(this.splitJarFiles().isPresent() && this.splitJarFilesExcludes().isPresent() && this.jarJsps().isPresent() && this.jarClasses().isPresent() && this.deleteJsps().isPresent() && this.compileEncoding().isPresent())) {
            throw new AppEngineConfigException("Staging options is not complete.");
        }
        Charset.forName(this.compileEncoding().get());
    }

    public static StagingOptions merge(StagingOptions ... opts) {
        Builder merged = StagingOptions.builder();
        for (StagingOptions op : opts) {
            if (op.splitJarFiles().isPresent()) {
                merged.setSplitJarFiles(op.splitJarFiles());
            }
            if (op.splitJarFilesExcludes().isPresent()) {
                merged.setSplitJarFilesExcludes(op.splitJarFilesExcludes());
            }
            if (op.jarJsps().isPresent()) {
                merged.setJarJsps(op.jarJsps());
            }
            if (op.jarClasses().isPresent()) {
                merged.setJarClasses(op.jarClasses());
            }
            if (op.deleteJsps().isPresent()) {
                merged.setDeleteJsps(op.deleteJsps());
            }
            if (!op.compileEncoding().isPresent()) continue;
            merged.setCompileEncoding(op.compileEncoding());
        }
        return merged.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSplitJarFiles(Optional<Boolean> var1);

        public abstract Builder setSplitJarFilesExcludes(Optional<ImmutableSortedSet<String>> var1);

        public abstract Builder setJarJsps(Optional<Boolean> var1);

        public abstract Builder setJarClasses(Optional<Boolean> var1);

        public abstract Builder setDeleteJsps(Optional<Boolean> var1);

        public abstract Builder setCompileEncoding(Optional<String> var1);

        public abstract StagingOptions build();
    }
}

