/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.ExistsExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class BooleanExpression
extends ScalarExpression {
    protected BooleanExpression(QueryExpression qs) {
        super(qs);
    }

    public BooleanExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public BooleanExpression(ScalarExpression.MonadicOperator op, ScalarExpression operand) {
        super(op, operand);
    }

    public BooleanExpression(ScalarExpression operand1, ScalarExpression.DyadicOperator op, ScalarExpression operand2) {
        super(operand1, op, operand2);
    }

    public BooleanExpression and(ScalarExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.and(this);
        }
        if (expr instanceof ExistsExpression && !(this instanceof ExistsExpression)) {
            boolean existsIncludesAll = false;
            Object ext = expr.qs.getValueForExtension("datanucleus.rdbms.jdoql.existsIncludesConstraints");
            if (ext != null && ((String)ext).equals("true")) {
                existsIncludesAll = true;
            }
            if (existsIncludesAll) {
                return expr.and(this);
            }
        }
        if (expr instanceof BooleanExpression) {
            return new BooleanExpression(this, OP_AND, expr);
        }
        return super.and(expr);
    }

    public BooleanExpression eor(ScalarExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.eor(this);
        }
        if (expr instanceof ExistsExpression) {
            return expr.eor(this);
        }
        if (expr instanceof BooleanExpression) {
            if (this.qs.getStoreManager().getDatastoreAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.eor(expr);
    }

    public BooleanExpression ior(ScalarExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.ior(this);
        }
        if (expr instanceof BooleanExpression) {
            return new BooleanExpression(this, OP_OR, expr);
        }
        return super.ior(expr);
    }

    public BooleanExpression not() {
        return new BooleanExpression(OP_NOT, this);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, BooleanExpression.class);
        if (expr instanceof BooleanLiteral || expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof BooleanExpression) {
            if (this.qs.getStoreManager().getDatastoreAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, OP_EQ, expr);
            }
            return this.and(expr).ior(this.not().and(expr.not()));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, BooleanExpression.class);
        if (expr instanceof BooleanLiteral || expr instanceof NullLiteral) {
            return expr.noteq(this);
        }
        if (expr instanceof BooleanExpression) {
            if (this.qs.getStoreManager().getDatastoreAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.noteq(expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }

    public ScalarExpression neg() {
        return new NumericExpression(OP_NEG, this);
    }
}

