/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoOneOf_EntityChange_Change;
import com.google.cloud.datastore.core.rep.AutoValue_EntityChange;
import com.google.cloud.datastore.core.rep.AutoValue_EntityChange_CommittedEntityChange;
import com.google.cloud.datastore.core.rep.AutoValue_EntityChange_Update;
import com.google.cloud.datastore.core.rep.AutoValue_EntityChange_VersionedEntity;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityDiff;
import com.google.cloud.datastore.core.rep.EntityDiffer;
import com.google.cloud.datastore.core.rep.EntityRef;
import java.util.Optional;
import javax.annotation.Nullable;

@Beta
@AutoValue
public abstract class EntityChange {
    abstract Change change();

    public final ChangeType type() {
        return this.change().type();
    }

    public final Entity insert() {
        return this.change().insert();
    }

    public final VersionedEntity delete() {
        return this.change().delete();
    }

    public final Update update() {
        return this.change().update();
    }

    abstract Optional<Long> createTimeOverwriteMicros();

    abstract boolean resetCreateTime();

    public EntityChange withCreateTimeOverwrite(long createTimeOverwriteMicros) {
        Preconditions.checkState((!this.createTimeOverwriteMicros().isPresent() && !this.resetCreateTime() ? 1 : 0) != 0);
        return new AutoValue_EntityChange(this.change(), Optional.of(createTimeOverwriteMicros), false);
    }

    public EntityChange withResetCreateTime() {
        Preconditions.checkState((!this.createTimeOverwriteMicros().isPresent() && !this.resetCreateTime() ? 1 : 0) != 0);
        return new AutoValue_EntityChange(this.change(), Optional.empty(), true);
    }

    public final Optional<Long> createTimeMicros() {
        if (this.createTimeOverwriteMicros().isPresent()) {
            return this.createTimeOverwriteMicros();
        }
        if (this.resetCreateTime()) {
            return Optional.empty();
        }
        return this.before().map(VersionedEntity::createTimeMicros);
    }

    public final Optional<Long> beforeUpdateTimeMicros() {
        return this.before().map(VersionedEntity::updateTimeMicros);
    }

    public EntityRef key() {
        switch (this.type()) {
            case INSERT: {
                return this.insert().ref();
            }
            case UPDATE: {
                return this.update().after().ref();
            }
            case DELETE: {
                return this.delete().entity().ref();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public Optional<VersionedEntity> before() {
        switch (this.type()) {
            case INSERT: {
                return Optional.empty();
            }
            case UPDATE: {
                return Optional.of(this.update().before());
            }
            case DELETE: {
                return Optional.of(this.delete());
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public Optional<Entity> after() {
        switch (this.type()) {
            case INSERT: {
                return Optional.of(this.change().insert());
            }
            case UPDATE: {
                return Optional.of(this.update().after());
            }
            case DELETE: {
                return Optional.empty();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public static EntityChange ofDelete(VersionedEntity before) {
        return new AutoValue_EntityChange(AutoOneOf_EntityChange_Change.delete(before), Optional.empty(), false);
    }

    public static EntityChange ofInsert(Entity after) {
        return new AutoValue_EntityChange(AutoOneOf_EntityChange_Change.insert(after), Optional.empty(), false);
    }

    public static EntityChange of(@Nullable VersionedEntity before, @Nullable Entity after) {
        if (before != null && after != null) {
            return new AutoValue_EntityChange(AutoOneOf_EntityChange_Change.update(Update.of(before, after)), Optional.empty(), false);
        }
        if (before == null && after != null) {
            return EntityChange.ofInsert(after);
        }
        if (before != null && after == null) {
            return EntityChange.ofDelete(before);
        }
        throw new IllegalArgumentException("before and update cannot be both null for entity change.");
    }

    @AutoValue
    public static abstract class CommittedEntityChange {
        public abstract EntityChange change();

        public abstract long commitTimeMicros();

        public static CommittedEntityChange of(EntityChange change, long commitTimestamp) {
            Preconditions.checkArgument((change != null && commitTimestamp > 0L ? 1 : 0) != 0);
            return new AutoValue_EntityChange_CommittedEntityChange(change, commitTimestamp);
        }

        public Optional<Long> createTimeMicros() {
            if (this.change().createTimeMicros().isPresent()) {
                return this.change().createTimeMicros();
            }
            Preconditions.checkState((this.change().resetCreateTime() || this.change().type().equals((Object)ChangeType.INSERT) ? 1 : 0) != 0);
            return Optional.of(this.commitTimeMicros());
        }
    }

    @AutoValue
    public static abstract class VersionedEntity {
        public abstract Entity entity();

        public abstract long createTimeMicros();

        public abstract long updateTimeMicros();

        public static VersionedEntity of(Entity entity, long createTime, long updateTime) {
            Preconditions.checkArgument((entity != null && createTime > 0L && updateTime >= 0L ? 1 : 0) != 0);
            return new AutoValue_EntityChange_VersionedEntity(entity, createTime, updateTime);
        }
    }

    @AutoValue
    public static abstract class Update {
        public abstract VersionedEntity before();

        public abstract Entity after();

        public abstract Optional<EntityDiff> diff();

        public static Update of(VersionedEntity before, Entity after) {
            Preconditions.checkArgument((boolean)before.entity().ref().equals(after.ref()));
            EntityDiff diff = EntityDiffer.diff(before == null ? null : before.entity(), after);
            return new AutoValue_EntityChange_Update(before, after, Optional.ofNullable(diff));
        }
    }

    @AutoOneOf(value=ChangeType.class)
    static abstract class Change {
        Change() {
        }

        public abstract ChangeType type();

        public abstract Entity insert();

        public abstract VersionedEntity delete();

        public abstract Update update();
    }

    public static enum ChangeType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

