/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ApiKey {
    private String name;
    private String version;
    private String root;

    public ApiKey(String name, String version) {
        this(name, version, null);
    }

    public ApiKey(String name, String version, @Nullable String root) {
        this.name = Preconditions.checkNotNull(name);
        this.version = Preconditions.checkNotNull(version);
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public @Nullable String getRoot() {
        return this.root;
    }

    public String getApiString() {
        String string = this.name;
        String string2 = this.version;
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ApiKey) {
            ApiKey that = (ApiKey)o;
            return this.name.equals(that.name) && this.version.equals(that.version) && Objects.equals(this.root, that.root);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.root);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("version", this.version).add("root", this.root).toString();
    }
}

