/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.auth.GoogleAppEngineAuthenticator;
import com.google.api.server.spi.auth.GoogleJwtAuthenticator;
import com.google.api.server.spi.auth.GoogleOAuth2Authenticator;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.Singleton;
import com.google.api.server.spi.request.Attribute;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class EndpointsAuthenticator
implements Authenticator {
    private final GoogleJwtAuthenticator jwtAuthenticator;
    private final GoogleAppEngineAuthenticator appEngineAuthenticator;
    private final GoogleOAuth2Authenticator oauth2Authenticator;

    public EndpointsAuthenticator() {
        this.jwtAuthenticator = new GoogleJwtAuthenticator();
        this.appEngineAuthenticator = new GoogleAppEngineAuthenticator();
        this.oauth2Authenticator = new GoogleOAuth2Authenticator();
    }

    @VisibleForTesting
    public EndpointsAuthenticator(GoogleJwtAuthenticator jwtAuthenticator, GoogleAppEngineAuthenticator appEngineAuthenticator, GoogleOAuth2Authenticator oauth2Authenticator) {
        this.jwtAuthenticator = jwtAuthenticator;
        this.appEngineAuthenticator = appEngineAuthenticator;
        this.oauth2Authenticator = oauth2Authenticator;
    }

    @Override
    public User authenticate(HttpServletRequest request) {
        Attribute attr = Attribute.from(request);
        User user = this.jwtAuthenticator.authenticate(request);
        if (user == null) {
            user = EnvUtil.isRunningOnAppEngine() && attr.isEnabled("endpoints:Require-AppEngine-User") ? this.appEngineAuthenticator.authenticate(request) : this.oauth2Authenticator.authenticate(request);
        }
        return user;
    }
}

