/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionFactoryRegistry;
import org.datanucleus.ConnectionManager;
import org.datanucleus.ConnectionManagerImpl;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.JDOClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.ApiAdapterFactory;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityTranslator;
import org.datanucleus.jta.TransactionManagerFinder;
import org.datanucleus.management.ManagementManager;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class OMFContext {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManager.class.getClassLoader());
    public static final int CONTEXT_PERSISTENCE = 1;
    public static final int CONTEXT_ENHANCE = 2;
    private int context;
    private ImplementationCreator ic;
    private boolean icInitialised = false;
    private StoreManager storeMgr = null;
    private MetaDataManager metaDataManager = null;
    private TransactionManager txManager = null;
    private javax.transaction.TransactionManager jtaTxManager = null;
    private final PersistenceConfiguration persistenceConfig;
    private ManagementManager jmxManager = null;
    private final PluginManager pluginManager;
    private final TypeManager typeManager;
    private ApiAdapter apiAdapter;
    private String apiName = "JDO";
    private Map<String, ClassLoaderResolver> classLoaderResolverMap = new HashMap<String, ClassLoaderResolver>();
    private String classLoaderResolverClassName = null;
    private Class datastoreIdentityClass = null;
    private IdentityTranslator idTranslator = null;
    private boolean idTranslatorInitialised = false;
    private ConnectionFactoryRegistry connFactoryRegistry;
    private ConnectionManager connmgr;
    private QueryManager queryManager;
    private List<ObjectManager.ObjectManagerListener> objectManagerListeners = new ArrayList<ObjectManager.ObjectManagerListener>();

    public OMFContext(PersistenceConfiguration persistenceConfig) {
        this(persistenceConfig, 1);
    }

    public OMFContext(PersistenceConfiguration persistenceConfig, int context) {
        this.context = context;
        this.persistenceConfig = persistenceConfig;
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver(this.getClass().getClassLoader());
        clr.registerUserClassLoader((ClassLoader)persistenceConfig.getProperty("datanucleus.primaryClassLoader"));
        this.pluginManager = new PluginManager(this.persistenceConfig, clr);
        this.pluginManager.registerExtensionPoints();
        this.pluginManager.registerExtensions();
        this.pluginManager.resolveConstraints();
        persistenceConfig.setDefaultProperties(this.pluginManager);
        this.apiAdapter = ApiAdapterFactory.getInstance().getApiAdapter(this.apiName, this.pluginManager);
        this.typeManager = new TypeManager(this.apiAdapter, this.pluginManager, this.getClassLoaderResolver(ClassLoaderUtil.getPlatformClassLoader()));
        if (context == 1) {
            this.jmxManager = this.getJMXManager();
            this.txManager = new TransactionManager();
            if (this.jmxManager != null) {
                this.txManager.registerMbean(this.jmxManager.getDomainName(), this.jmxManager.getInstanceName(), this.jmxManager.getManagementServer());
            }
            this.connFactoryRegistry = new ConnectionFactoryRegistry(this);
            this.connmgr = new ConnectionManagerImpl(this);
            this.queryManager = new QueryManager(this);
        }
    }

    public int getContext() {
        return this.context;
    }

    public synchronized void close() {
        if (this.storeMgr != null) {
            this.storeMgr.close();
            this.storeMgr = null;
        }
        if (this.metaDataManager != null) {
            this.metaDataManager.close();
            this.metaDataManager = null;
        }
        if (this.jmxManager != null) {
            this.jmxManager.close();
            this.jmxManager = null;
        }
        if (this.queryManager != null) {
            this.queryManager.close();
        }
        this.classLoaderResolverMap.clear();
        this.classLoaderResolverMap = null;
        this.classLoaderResolverClassName = null;
        this.datastoreIdentityClass = null;
    }

    public Class getDatastoreIdentityClass() {
        if (this.datastoreIdentityClass == null) {
            String dsidName = this.persistenceConfig.getStringProperty("datanucleus.datastoreIdentityType");
            String datastoreIdentityClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.store_datastoreidentity", "name", dsidName, "class-name");
            if (datastoreIdentityClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)dsidName)).setFatal();
            }
            ClassLoaderResolver clr = this.getClassLoaderResolver(ClassLoaderUtil.getPlatformClassLoader());
            try {
                this.datastoreIdentityClass = clr.classForName(datastoreIdentityClassName, OMFContext.class.getClassLoader());
            }
            catch (ClassNotResolvedException cnre) {
                throw new NucleusUserException(LOCALISER.msg("002002", (Object)dsidName, (Object)datastoreIdentityClassName)).setFatal();
            }
        }
        return this.datastoreIdentityClass;
    }

    public IdentityTranslator getIdentityTranslator() {
        if (this.idTranslatorInitialised) {
            return this.idTranslator;
        }
        this.idTranslatorInitialised = true;
        String translatorType = this.persistenceConfig.getStringProperty("datanucleus.identityTranslatorType");
        if (translatorType != null) {
            try {
                this.idTranslator = (IdentityTranslator)this.pluginManager.createExecutableExtension("org.datanucleus.identity_translator", "name", translatorType, "class-name", null, null);
                return this.idTranslator;
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)translatorType)).setFatal();
            }
        }
        return null;
    }

    public ManagementManager getJMXManager() {
        if (this.jmxManager == null && this.persistenceConfig.getBooleanProperty("datanucleus.managedRuntime")) {
            this.jmxManager = new ManagementManager(this);
        }
        return this.jmxManager;
    }

    public ClassLoaderResolver getClassLoaderResolver(ClassLoader primaryLoader) {
        ClassLoaderResolver clr;
        String clrName = this.persistenceConfig.getStringProperty("datanucleus.classLoaderResolverName");
        this.classLoaderResolverClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.classloader_resolver", "name", clrName, "class-name");
        if (this.classLoaderResolverClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("001001", (Object)clrName)).setFatal();
        }
        String key = this.classLoaderResolverClassName;
        if (primaryLoader != null) {
            key = key + ":[" + StringUtils.toJVMIDString(primaryLoader) + "]";
        }
        if ((clr = this.classLoaderResolverMap.get(key)) == null) {
            try {
                Class<?> cls = Class.forName(this.classLoaderResolverClassName);
                Class[] ctrArgs = null;
                Object[] ctrParams = null;
                if (primaryLoader != null) {
                    ctrArgs = new Class[]{ClassLoader.class};
                    ctrParams = new Object[]{primaryLoader};
                }
                Constructor<?> ctor = cls.getConstructor(ctrArgs);
                clr = (ClassLoaderResolver)ctor.newInstance(ctrParams);
                clr.registerUserClassLoader((ClassLoader)this.persistenceConfig.getProperty("datanucleus.primaryClassLoader"));
            }
            catch (ClassNotFoundException cnfe) {
                throw new NucleusUserException(LOCALISER.msg("001002", (Object)this.classLoaderResolverClassName), cnfe).setFatal();
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("001003", (Object)this.classLoaderResolverClassName), e).setFatal();
            }
            this.classLoaderResolverMap.put(key, clr);
        }
        return clr;
    }

    public ImplementationCreator getImplementationCreator() {
        if (!this.icInitialised) {
            String implCreatorName = this.persistenceConfig.getStringProperty("datanucleus.implementationCreatorName");
            try {
                Class<?> cls = null;
                ConfigurationElement elem = this.getPluginManager().getConfigurationElementForExtension("org.datanucleus.implementation_creator", "name", implCreatorName);
                if (elem != null) {
                    try {
                        cls = Class.forName(elem.getAttribute("class-name"), true, ObjectManagerFactoryImpl.class.getClassLoader());
                        this.ic = (ImplementationCreator)cls.newInstance();
                    }
                    catch (Exception e) {
                        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008006", (Object)implCreatorName));
                    }
                }
                if (this.ic == null) {
                    Extension[] exts = this.getPluginManager().getExtensionPoint("org.datanucleus.implementation_creator").getExtensions();
                    block7: for (int i = 0; this.ic == null && i < exts.length; ++i) {
                        for (int j = 0; this.ic == null && j < exts[i].getConfigurationElements().length; ++j) {
                            cls = Class.forName(exts[i].getConfigurationElements()[j].getAttribute("class-name"), true, ObjectManagerFactoryImpl.class.getClassLoader());
                            this.ic = (ImplementationCreator)cls.newInstance();
                            if (this.ic != null) continue block7;
                        }
                    }
                }
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    if (this.ic == null) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("008007"));
                    } else {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("008008", (Object)cls.getName()));
                    }
                }
            }
            catch (InstantiationException e) {
                throw new NucleusException(e.toString(), e).setFatal();
            }
            catch (IllegalAccessException e) {
                throw new NucleusException(e.toString(), e).setFatal();
            }
            catch (ClassNotFoundException e) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("008006", (Object)implCreatorName));
                this.ic = null;
            }
            catch (NoClassDefFoundError e) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("008006", (Object)implCreatorName));
                this.ic = null;
            }
        }
        this.icInitialised = true;
        return this.ic;
    }

    public synchronized MetaDataManager getMetaDataManager() {
        if (this.metaDataManager == null) {
            try {
                this.metaDataManager = (MetaDataManager)this.getPluginManager().createExecutableExtension("org.datanucleus.metadata_manager", new String[]{"name"}, new String[]{this.apiName}, "class", new Class[]{OMFContext.class}, new Object[]{this});
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER.msg("008010", (Object)this.apiName, (Object)e.getMessage()), e);
            }
            if (this.metaDataManager == null) {
                throw new NucleusException(LOCALISER.msg("008009", (Object)this.apiName));
            }
        }
        return this.metaDataManager;
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfig;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public TransactionManager getTransactionManager() {
        return this.txManager;
    }

    public javax.transaction.TransactionManager getJtaTransactionManager() {
        if (this.jtaTxManager == null) {
            this.jtaTxManager = new TransactionManagerFinder(this).getTransactionManager(this.getClassLoaderResolver((ClassLoader)this.persistenceConfig.getProperty("datanucleus.primaryClassLoader")));
            if (this.jtaTxManager == null) {
                throw new NucleusTransactionException(LOCALISER.msg("015030"));
            }
        }
        return this.jtaTxManager;
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    public void setStoreManager(StoreManager storeMgr) {
        if (this.storeMgr == null) {
            this.storeMgr = storeMgr;
        }
    }

    public ApiAdapter getApiAdapter() {
        return this.apiAdapter;
    }

    public String getApi() {
        return this.apiName;
    }

    public void setApi(String name) {
        this.apiName = name;
        ApiAdapter adapter = ApiAdapterFactory.getInstance().getApiAdapter(name, this.pluginManager);
        if (adapter != null) {
            this.apiAdapter = adapter;
        } else {
            NucleusLogger.JDO.warn(LOCALISER.msg("008003", (Object)name));
        }
    }

    public ConnectionFactoryRegistry getConnectionFactoryRegistry() {
        return this.connFactoryRegistry;
    }

    public ConnectionManager getConnectionManager() {
        return this.connmgr;
    }

    public ObjectManager.ObjectManagerListener[] getObjectManagerListeners() {
        return this.objectManagerListeners.toArray(new ObjectManager.ObjectManagerListener[this.objectManagerListeners.size()]);
    }

    public void addObjectManagerListener(ObjectManager.ObjectManagerListener listener) {
        this.objectManagerListeners.add(listener);
    }

    public void removeObjectManagerListener(ObjectManager.ObjectManagerListener listener) {
        this.objectManagerListeners.remove(listener);
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    static class ClassLoaderUtil {
        private static final ClassLoader PLATFORM_CLASSLOADER = ClassLoaderUtil.getPlatformClassLoaderViaReflection();

        private static ClassLoader getPlatformClassLoaderViaReflection() {
            try {
                Method getPlatformClassLoader = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
                return (ClassLoader)getPlatformClassLoader.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException ignore) {
                return null;
            }
        }

        public static ClassLoader getPlatformClassLoader() {
            return PLATFORM_CLASSLOADER;
        }

        private ClassLoaderUtil() {
        }
    }
}

