/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.client.HttpClient;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpGet;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpPost;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpRequestBase;
import com.google.appengine.repackaged.org.apache.http.cookie.Cookie;
import com.google.appengine.repackaged.org.apache.http.entity.ByteArrayEntity;
import com.google.appengine.repackaged.org.apache.http.entity.ContentType;
import com.google.appengine.repackaged.org.apache.http.impl.client.BasicCookieStore;
import com.google.appengine.repackaged.org.apache.http.impl.client.CloseableHttpClient;
import com.google.appengine.repackaged.org.apache.http.impl.client.HttpClientBuilder;
import com.google.appengine.repackaged.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.LegacyResponse;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

class StandaloneAppEngineClient
extends AppEngineClient {
    private final HttpClient httpClient;

    StandaloneAppEngineClient(RemoteApiOptions options, List<Cookie> authCookies, String appId) {
        super(options, authCookies, appId);
        BasicCookieStore cookieStore = new BasicCookieStore();
        for (Cookie cookie : authCookies) {
            cookieStore.addCookie(cookie);
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().disableRedirectHandling().setConnectionManager(new PoolingHttpClientConnectionManager()).setDefaultCookieStore(cookieStore).build();
        this.httpClient = httpClient;
    }

    @Override
    public AppEngineClient.Response get(String path) throws IOException {
        return this.createResponse(this.doGet(path));
    }

    private HttpResponse doGet(String path) throws IOException {
        HttpGet method = new HttpGet(this.makeUrl(path));
        this.addHeaders(method, this.getHeadersForGet());
        return this.httpClient.execute(method);
    }

    @Override
    public AppEngineClient.Response post(String path, String mimeType, byte[] body) throws IOException {
        return this.createResponse(this.doPost(path, mimeType, body));
    }

    private HttpResponse doPost(String path, String mimeType, byte[] body) throws IOException {
        HttpPost post = new HttpPost(this.makeUrl(path));
        this.addHeaders(post, this.getHeadersForPost(mimeType));
        post.setEntity(new ByteArrayEntity(body));
        return this.httpClient.execute(post);
    }

    @Override
    public LegacyResponse legacyGet(String path) throws IOException {
        return this.createLegacyResponse(this.doGet(path));
    }

    @Override
    public LegacyResponse legacyPost(String path, String mimeType, byte[] body) throws IOException {
        return this.createLegacyResponse(this.doPost(path, mimeType, body));
    }

    private void addHeaders(HttpRequestBase method, List<String[]> headers) {
        for (String[] headerPair : headers) {
            method.addHeader(headerPair[0], headerPair[1]);
        }
    }

    private AppEngineClient.Response createResponse(HttpResponse response) throws IOException {
        byte[] body = StandaloneAppEngineClient.responseBytes(response, this.getMaxResponseSize());
        return new AppEngineClient.Response(response.getStatusLine().getStatusCode(), body, ContentType.get(response.getEntity()).getCharset());
    }

    private LegacyResponse createLegacyResponse(HttpResponse response) throws IOException {
        byte[] body = StandaloneAppEngineClient.responseBytes(response, this.getMaxResponseSize());
        return new LegacyResponse(response.getStatusLine().getStatusCode(), body, ContentType.get(response.getEntity()).getCharset());
    }

    static byte[] responseBytes(HttpResponse response, int max) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        try (InputStream in = response.getEntity().getContent();){
            int n;
            while (bout.size() < max && (n = in.read(buf, 0, Math.min(buf.length, max - bout.size()))) > 0) {
                bout.write(buf, 0, n);
            }
        }
        return bout.toByteArray();
    }
}

