/**********************************************************************
Copyright (c) 2006 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
2006 Andy Jefferson - added check on whether Analysis are supported by dba
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import java.util.Arrays;
import java.util.List;

import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/**
 * Representation of analysis SQL functions in JDOQL.
 */
public class AnalysisExpression extends ScalarExpression
{
    /**
     * Constructor
     * @param qs The query statement
     */
    public AnalysisExpression(QueryExpression qs)
    {
        super(qs);
    }
    
    protected AnalysisExpression(JavaTypeMapping mapping, String functionName, List args)
    {
        super(functionName, args);
    }
    
    public ScalarExpression rollupMethod(ScalarExpression[] expr)
    {
        if (qs.getStoreManager().getDatastoreAdapter().supportsOption(DatastoreAdapter.ANALYSIS_METHODS))
        {
            return new AnalysisExpression(expr[0].getMapping(), "ROLLUP", Arrays.asList(expr));
        }
        else
        {
            throw new NucleusUserException("Analysis methods are not supported by this datastore").setFatal();
        }
    }

    public ScalarExpression cubeMethod(ScalarExpression[] expr)
    {
        if (qs.getStoreManager().getDatastoreAdapter().supportsOption(DatastoreAdapter.ANALYSIS_METHODS))
        {
            return new AnalysisExpression(expr[0].getMapping(), "CUBE", Arrays.asList(expr));
        }
        else
        {
            throw new NucleusUserException("Analysis methods are not supported by this datastore").setFatal();
        }
    }
}