/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.datanucleus.DatastoreFieldManager;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.KeyRegistry;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.StorageVersion;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.InsertMappingConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.util.Localiser;

public class StoreFieldManager
extends DatastoreFieldManager {
    protected static final Localiser GAE_LOCALISER = Localiser.getInstance((String)"com.google.appengine.datanucleus.Localisation", (ClassLoader)DatastoreManager.class.getClassLoader());
    private static final String PARENT_ALREADY_SET = "Cannot set both the primary key and a parent pk field.  If you want the datastore to generate an id for you, set the parent pk field to be the value of your parent key and leave the primary key field blank.  If you wish to provide a named key, leave the parent pk field blank and set the primary key to be a Key object made up of both the parent key and the named child.";
    public static final int IS_FK_VALUE = -2;
    private static final int[] IS_FK_VALUE_ARR = new int[]{-2};
    protected final Operation operation;
    protected boolean parentAlreadySet = false;
    protected boolean keyAlreadySet = false;
    private final List<RelationStoreInformation> relationStoreInfos = Utils.newArrayList(new Object[0]);

    public StoreFieldManager(ObjectProvider op, String kind) {
        super(op, new Entity(kind), null);
        this.operation = Operation.INSERT;
    }

    public StoreFieldManager(ObjectProvider op, Entity datastoreEntity, int[] fieldNumbers) {
        super(op, datastoreEntity, fieldNumbers);
        this.operation = Operation.UPDATE;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        this.storeFieldInEntity(fieldNumber, value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        this.storeFieldInEntity(fieldNumber, value);
    }

    public void storeCharField(int fieldNumber, char value) {
        this.storeFieldInEntity(fieldNumber, Character.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        this.storeFieldInEntity(fieldNumber, value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        this.storeFieldInEntity(fieldNumber, Float.valueOf(value));
    }

    public void storeIntField(int fieldNumber, int value) {
        this.storeFieldInEntity(fieldNumber, value);
    }

    public void storeLongField(int fieldNumber, long value) {
        this.storeFieldInEntity(fieldNumber, value);
    }

    public void storeShortField(int fieldNumber, short value) {
        this.storeFieldInEntity(fieldNumber, value);
    }

    public void storeStringField(int fieldNumber, String value) {
        if (this.isPK(fieldNumber)) {
            this.storeStringPKField(fieldNumber, value);
        } else if (MetaDataUtils.isParentPKField(this.getClassMetaData(), fieldNumber)) {
            this.storeParentStringField(value);
        } else if (MetaDataUtils.isPKNameField(this.getClassMetaData(), fieldNumber)) {
            this.storePKNameField(fieldNumber, value);
        } else {
            String valueToStore = value;
            AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
            if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length == 1 && "CLOB".equals(ammd.getColumnMetaData()[0].getJdbcType())) {
                valueToStore = new Text(value);
            }
            this.storeFieldInEntity(fieldNumber, valueToStore);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (this.isPK(fieldNumber)) {
            this.storePrimaryKey(fieldNumber, value);
        } else if (MetaDataUtils.isParentPKField(this.getClassMetaData(), fieldNumber)) {
            this.storeParentField(fieldNumber, value);
        } else if (MetaDataUtils.isPKIdField(this.getClassMetaData(), fieldNumber)) {
            this.storePKIdField(fieldNumber, value);
        } else {
            this.storeFieldInEntity(fieldNumber, value);
        }
    }

    private void storeFieldInEntity(int fieldNumber, Object value) {
        int relationType;
        AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
        if (!(this.operation == Operation.INSERT && ammd.isInsertable() || this.operation == Operation.UPDATE && ammd.isUpdateable())) {
            return;
        }
        if (ammd.getEmbeddedMetaData() != null) {
            ObjectProvider embeddedOP = this.getEmbeddedObjectProvider(ammd, fieldNumber, value);
            InsertMappingConsumer mc = this.buildMappingConsumer(embeddedOP.getClassMetaData(), this.getClassLoaderResolver(), embeddedOP.getClassMetaData().getAllMemberPositions(), ammd.getEmbeddedMetaData());
            this.fieldManagerStateStack.addFirst(new DatastoreFieldManager.FieldManagerState(embeddedOP, this.getEmbeddedAbstractMemberMetaDataProvider(mc), mc, true));
            embeddedOP.provideFields(embeddedOP.getClassMetaData().getAllMemberPositions(), (FieldManager)this);
            this.fieldManagerStateStack.removeFirst();
            return;
        }
        ExecutionContext ec = this.getExecutionContext();
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        if (ammd.isSerialized()) {
            if (value != null) {
                value = this.getStoreManager().getSerializationManager().serialize(clr, ammd, value);
            } else {
                this.checkSettingToNullValue(ammd, value);
            }
            EntityUtils.setEntityProperty(this.datastoreEntity, (MetaData)ammd, EntityUtils.getPropertyName(this.getStoreManager().getIdentifierFactory(), ammd), value);
            return;
        }
        if (value != null) {
            TypeManager typeMgr = this.op.getExecutionContext().getNucleusContext().getTypeManager();
            value = this.getConversionUtils().pojoValueToDatastoreValue(typeMgr, clr, value, ammd);
        }
        if ((relationType = ammd.getRelationType(clr)) == 0) {
            if (value == null) {
                this.checkSettingToNullValue(ammd, value);
            }
            if (value instanceof SCO) {
                value = ((SCO)value).getValue();
            }
            EntityUtils.setEntityProperty(this.datastoreEntity, (MetaData)ammd, EntityUtils.getPropertyName(this.getStoreManager().getIdentifierFactory(), ammd), value);
            return;
        }
        this.relationStoreInfos.add(new RelationStoreInformation(ammd, value));
        boolean owned = MetaDataUtils.isOwnedRelation(ammd);
        if (owned) {
            if (!this.getStoreManager().storageVersionAtLeast(StorageVersion.WRITE_OWNED_CHILD_KEYS_TO_PARENTS)) {
                return;
            }
            if (relationType == 6) {
                return;
            }
            if (relationType == 2 && ammd.getMappedBy() != null) {
                return;
            }
        }
        if (this.operation == Operation.INSERT) {
            if (value == null) {
                this.checkSettingToNullValue(ammd, value);
            } else if (Relation.isRelationSingleValued((int)relationType)) {
                Key key = EntityUtils.extractChildKey(value, ec, owned ? this.datastoreEntity : null);
                if (key != null && owned && !this.datastoreEntity.getKey().equals((Object)key.getParent())) {
                    throw new NucleusFatalUserException(GAE_LOCALISER.msg("AppEngine.OwnedChildCannotChangeParent", (Object)key, (Object)this.datastoreEntity.getKey()));
                }
                value = key;
            } else if (Relation.isRelationMultiValued((int)relationType)) {
                if (ammd.hasCollection()) {
                    Collection coll = value;
                    ArrayList<Object> keys = Utils.newArrayList(new Object[0]);
                    for (Object obj : coll) {
                        Key key = EntityUtils.extractChildKey(obj, ec, owned ? this.datastoreEntity : null);
                        if (key == null) continue;
                        keys.add(key);
                        if (!owned || this.datastoreEntity.getKey().equals((Object)key.getParent())) continue;
                        throw new NucleusFatalUserException(GAE_LOCALISER.msg("AppEngine.OwnedChildCannotChangeParent", (Object)key, (Object)this.datastoreEntity.getKey()));
                    }
                    value = keys;
                }
                if (value instanceof SCO) {
                    value = ((SCO)value).getValue();
                }
            }
            EntityUtils.setEntityProperty(this.datastoreEntity, (MetaData)ammd, EntityUtils.getPropertyName(this.getStoreManager().getIdentifierFactory(), ammd), value);
        }
    }

    Object processPersistable(AbstractMemberMetaData mmd, Object pc) {
        ObjectProvider childOP;
        ExecutionContext ec = this.getExecutionContext();
        if (ec.getApiAdapter().isDeleted(pc)) {
            return null;
        }
        Object childPC = pc;
        if (ec.getApiAdapter().isDetached(pc)) {
            childPC = ec.persistObjectInternal(pc, null, -1, 0);
        }
        if ((childOP = ec.findObjectProvider(childPC)) == null) {
            childPC = ec.persistObjectInternal(childPC, null, -1, 0);
        }
        if (mmd.getAbstractClassMetaData().getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)childOP.getInternalObjectId();
            if (oid == null) {
                childOP.flush();
            }
        } else {
            Object primaryKey = ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(childOP.getInternalObjectId());
            if (primaryKey == null) {
                childOP.flush();
            }
        }
        return childPC;
    }

    void storeParentField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
        if (!mmd.getType().equals(Key.class)) {
            throw this.exceptionForUnexpectedKeyType("Parent primary key", fieldNumber);
        }
        this.storeParentKeyPK((Key)value);
    }

    private void storePrimaryKey(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
        if (mmd.getType().equals(Long.class)) {
            Key key = null;
            if (value != null) {
                key = KeyFactory.createKey((String)this.datastoreEntity.getKind(), (long)((Long)value));
            }
            this.storeKeyPK(key);
        } else if (mmd.getType().equals(Key.class)) {
            Key key = (Key)value;
            if (key != null && key.getParent() != null && this.parentAlreadySet) {
                throw new NucleusFatalUserException(PARENT_ALREADY_SET);
            }
            this.storeKeyPK((Key)value);
        } else {
            throw this.exceptionForUnexpectedKeyType("Primary key", fieldNumber);
        }
    }

    void storePKIdField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
        if (!mmd.getType().equals(Long.class)) {
            throw new NucleusFatalUserException("Field with \"gae.pk-id\" extension must be of type Long");
        }
        Key key = null;
        if (value != null) {
            key = KeyFactory.createKey((String)this.datastoreEntity.getKind(), (long)((Long)value));
        }
        this.storeKeyPK(key);
    }

    private void storePKNameField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
        if (!mmd.getType().equals(String.class)) {
            throw new NucleusFatalUserException("Field with \"gae.pk-id\" extension must be of type String");
        }
        Key key = null;
        if (value != null) {
            key = KeyFactory.createKey((Key)this.datastoreEntity.getParent(), (String)this.datastoreEntity.getKind(), (String)value);
        }
        this.storeKeyPK(key);
    }

    private void storeParentStringField(String value) {
        Key key = null;
        if (value != null) {
            try {
                key = KeyFactory.stringToKey((String)value);
            }
            catch (IllegalArgumentException iae) {
                throw new NucleusFatalUserException("Attempt was made to set parent to " + value + " but this cannot be converted into a Key.");
            }
        }
        this.storeParentKeyPK(key);
    }

    private void storeParentKeyPK(Key key) {
        if (key != null && this.parentAlreadySet) {
            throw new NucleusFatalUserException(PARENT_ALREADY_SET);
        }
        if (this.datastoreEntity.getParent() != null) {
            if (!this.datastoreEntity.getParent().equals((Object)key) && !this.parentAlreadySet) {
                throw new NucleusFatalUserException("Attempt was made to modify the parent of an object of type " + this.getObjectProvider().getClassMetaData().getFullClassName() + " identified by " + "key " + this.datastoreEntity.getKey() + ".  Parents are immutable (changed value is " + key + ").");
            }
        } else if (key != null) {
            if (this.operation == Operation.UPDATE) {
                throw new NucleusFatalUserException("You can only rely on this class to properly handle parent pks if you instantiated the class without providing a datastore entity to the constructor.");
            }
            if (this.keyAlreadySet) {
                throw new NucleusFatalUserException(PARENT_ALREADY_SET);
            }
            this.datastoreEntity = EntityUtils.recreateEntityWithParent(key, this.datastoreEntity);
            this.parentAlreadySet = true;
        }
    }

    private void storeStringPKField(int fieldNumber, String value) {
        Key key = null;
        if (MetaDataUtils.isEncodedPKField(this.getClassMetaData(), fieldNumber)) {
            if (value != null) {
                try {
                    key = KeyFactory.stringToKey((String)value);
                }
                catch (IllegalArgumentException iae) {
                    throw new NucleusFatalUserException("Invalid primary key for " + this.getClassMetaData().getFullClassName() + ".  The " + "primary key field is an encoded String but an unencoded value has been provided. " + "If you want to set an unencoded value on this field you can either change its " + "type to be an unencoded String (remove the \"" + "gae.encoded-pk" + "\" extension), change its type to be a " + Key.class.getName() + " and then set " + "the Key's name field, or create a separate String field for the name component " + "of your primary key and add the \"" + "gae.pk-name" + "\" extension.");
                }
            }
        } else {
            if (value == null) {
                throw new NucleusFatalUserException("Invalid primary key for " + this.getClassMetaData().getFullClassName() + ".  Cannot have " + "a null primary key field if the field is unencoded and of type String.  " + "Please provide a value or, if you want the datastore to generate an id on your " + "behalf, change the type of the field to Long.");
            }
            if (value != null) {
                key = this.datastoreEntity.getParent() != null ? new Entity(this.datastoreEntity.getKey().getKind(), value, this.datastoreEntity.getParent()).getKey() : new Entity(this.datastoreEntity.getKey().getKind(), value).getKey();
            }
        }
        this.storeKeyPK(key);
    }

    private void storeKeyPK(Key key) {
        if (key != null && !this.datastoreEntity.getKind().equals(key.getKind())) {
            throw new NucleusFatalUserException("Attempt was made to set the primray key of an entity with kind " + this.datastoreEntity.getKind() + " to a key with kind " + key.getKind());
        }
        if (this.datastoreEntity.getKey().isComplete()) {
            if (!this.datastoreEntity.getKey().equals((Object)key) && !this.keyAlreadySet) {
                throw new NucleusFatalUserException("Attempt was made to modify the primary key of an object of type " + this.getObjectProvider().getClassMetaData().getFullClassName() + " identified by " + "key " + this.datastoreEntity.getKey() + "  Primary keys are immutable.  " + "(New value: " + key);
            }
        } else if (key != null) {
            Entity old = this.datastoreEntity;
            if (key.getParent() != null) {
                if (this.keyAlreadySet) {
                    throw new NucleusFatalUserException(PARENT_ALREADY_SET);
                }
                this.parentAlreadySet = true;
            }
            this.datastoreEntity = new Entity(key);
            EntityUtils.copyProperties(old, this.datastoreEntity);
            this.keyAlreadySet = true;
        }
    }

    private void checkSettingToNullValue(AbstractMemberMetaData ammd, Object value) {
        if (value == null) {
            if (ammd.getNullValue() == NullValue.EXCEPTION) {
                throw new NucleusUserException("Field/Property " + ammd.getFullFieldName() + " is null, but is mandatory as it's described in the jdo metadata");
            }
            ColumnMetaData[] colmds = ammd.getColumnMetaData();
            if (colmds != null && colmds.length > 0 && colmds[0].getAllowsNull() == Boolean.FALSE) {
                throw new NucleusDataStoreException("Field/Property " + ammd.getFullFieldName() + " is null, but the column is specified as not-nullable");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean storeRelations(KeyRegistry keyRegistry) {
        if (this.relationStoreInfos.isEmpty()) {
            return false;
        }
        op = this.getObjectProvider();
        ec = op.getExecutionContext();
        table = this.getDatastoreTable();
        if (this.datastoreEntity.getKey() != null) {
            key = this.datastoreEntity.getKey();
            acmd = op.getClassMetaData();
            relationFieldNums = acmd.getRelationMemberPositions(ec.getClassLoaderResolver(), ec.getMetaDataManager());
            ** if (relationFieldNums == null) goto lbl38
            for (i = 0; i < relationFieldNums.length; ++i) {
                mmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(relationFieldNums[i]);
                owned = MetaDataUtils.isOwnedRelation(mmd);
                if (owned) {
                    childValue = op.provideField(mmd.getAbsoluteFieldNumber());
                    if (childValue == null) continue;
                    if (childValue instanceof Object[]) {
                        childValue = Arrays.asList((Object[])childValue);
                    }
                    expectedType = this.getExpectedChildType(mmd);
                    if (childValue instanceof Iterable) {
                        for (T element : (Iterable)childValue) {
                            this.addToParentKeyMap(keyRegistry, element, key, op.getExecutionContext(), expectedType, true);
                        }
                        continue;
                    }
                    this.addToParentKeyMap(keyRegistry, childValue, key, op.getExecutionContext(), expectedType, table.isParentKeyProvider(mmd) == false);
                    continue;
                }
                childValue = op.provideField(mmd.getAbsoluteFieldNumber());
                if (childValue == null) continue;
                if (childValue instanceof Object[]) {
                    childValue = Arrays.asList((Object[])childValue);
                }
                if (childValue instanceof Iterable) {
                    for (T element : (Iterable)childValue) {
                        keyRegistry.registerUnownedObject(element);
                    }
                    continue;
                }
                keyRegistry.registerUnownedObject(childValue);
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl38:
        // 4 sources

        modifiedEntity = false;
        for (RelationStoreInformation relInfo : this.relationStoreInfos) {
            mmd = relInfo.mmd;
            try {
                mapping = table.getMemberMappingInDatastoreClass(relInfo.mmd);
                if (!(mapping instanceof EmbeddedPCMapping) && !(mapping instanceof SerialisedPCMapping) && !(mapping instanceof SerialisedReferenceMapping) && !(mapping instanceof PersistableMapping) && !(mapping instanceof InterfaceMapping)) continue;
                owned = MetaDataUtils.isOwnedRelation(mmd);
                relationType = mmd.getRelationType(ec.getClassLoaderResolver());
                if (owned) {
                    owner = false;
                    if (relationType == 1 || relationType == 3 || relationType == 4) {
                        owner = true;
                    } else if (relationType == 2 && mmd.getMappedBy() == null) {
                        owner = true;
                    }
                    if (table.isParentKeyProvider(mmd)) continue;
                    if (!owner) {
                        parentOP = ec.findObjectProvider(relInfo.value);
                        EntityUtils.checkParentage(op.getObject(), parentOP);
                    } else {
                        EntityUtils.checkParentage(relInfo.value, op);
                    }
                    mapping.setObject(this.getExecutionContext(), (Object)this.datastoreEntity, StoreFieldManager.IS_FK_VALUE_ARR, relInfo.value, op, mmd.getAbsoluteFieldNumber());
                    continue;
                }
                mapping.setObject(this.getExecutionContext(), (Object)this.datastoreEntity, StoreFieldManager.IS_FK_VALUE_ARR, relInfo.value, op, mmd.getAbsoluteFieldNumber());
            }
            catch (NotYetFlushedException e) {}
        }
        for (RelationStoreInformation relInfo : this.relationStoreInfos) {
            try {
                mapping = table.getMemberMappingInDatastoreClass(relInfo.mmd);
                if (!(mapping instanceof MappingCallbacks)) continue;
                if (this.operation == Operation.INSERT) {
                    ((MappingCallbacks)mapping).postInsert(op);
                    continue;
                }
                ((MappingCallbacks)mapping).postUpdate(op);
            }
            catch (NotYetFlushedException e) {}
        }
        for (RelationStoreInformation relInfo : this.relationStoreInfos) {
            mmd = relInfo.mmd;
            relationType = mmd.getRelationType(ec.getClassLoaderResolver());
            owned = MetaDataUtils.isOwnedRelation(mmd);
            if (owned && (!this.getStoreManager().storageVersionAtLeast(StorageVersion.WRITE_OWNED_CHILD_KEYS_TO_PARENTS) || relationType == 6 || relationType == 2 && mmd.getMappedBy() != null)) continue;
            value = relInfo.value;
            propName = EntityUtils.getPropertyName(this.getStoreManager().getIdentifierFactory(), mmd);
            if (value == null) {
                this.checkSettingToNullValue(mmd, value);
                if (this.datastoreEntity.hasProperty(propName) && this.datastoreEntity.getProperty(propName) == null) continue;
                modifiedEntity = true;
                EntityUtils.setEntityProperty(this.datastoreEntity, (MetaData)mmd, propName, value);
                continue;
            }
            if (Relation.isRelationSingleValued((int)relationType)) {
                if (ec.getApiAdapter().isDeleted((Object)value)) {
                    value = null;
                    continue;
                }
                key = EntityUtils.extractChildKey(value, ec, owned != false ? this.datastoreEntity : null);
                if (key == null) {
                    childPC = this.processPersistable(mmd, value);
                    if (childPC != value) {
                        op.replaceField(mmd.getAbsoluteFieldNumber(), childPC);
                    }
                    key = EntityUtils.extractChildKey(childPC, ec, owned != false ? this.datastoreEntity : null);
                }
                if (owned && !this.datastoreEntity.getKey().equals((Object)key.getParent())) {
                    throw new NucleusFatalUserException(StoreFieldManager.GAE_LOCALISER.msg("AppEngine.OwnedChildCannotChangeParent", (Object)key, (Object)this.datastoreEntity.getKey()));
                }
                value = key;
                if (this.datastoreEntity.hasProperty(propName) && value.equals(this.datastoreEntity.getProperty(propName))) continue;
                modifiedEntity = true;
                EntityUtils.setEntityProperty(this.datastoreEntity, (MetaData)mmd, propName, value);
                continue;
            }
            if (!Relation.isRelationMultiValued((int)relationType) || !mmd.hasCollection()) continue;
            coll = value;
            keys = Utils.newArrayList(new Object[0]);
            for (E obj : coll) {
                if (ec.getApiAdapter().isDeleted(obj)) continue;
                key = EntityUtils.extractChildKey(obj, ec, owned != false ? this.datastoreEntity : null);
                if (key != null) {
                    keys.add(key);
                } else {
                    childPC = this.processPersistable(mmd, obj);
                    key = EntityUtils.extractChildKey(childPC, ec, owned != false ? this.datastoreEntity : null);
                    keys.add(key);
                }
                if (!owned || this.datastoreEntity.getKey().equals((Object)key.getParent())) continue;
                throw new NucleusFatalUserException(StoreFieldManager.GAE_LOCALISER.msg("AppEngine.OwnedChildCannotChangeParent", (Object)key, (Object)this.datastoreEntity.getKey()));
            }
            value = keys;
            if (this.datastoreEntity.hasProperty(propName) && value.equals(this.datastoreEntity.getProperty(propName))) continue;
            modifiedEntity = true;
            EntityUtils.setEntityProperty(this.datastoreEntity, (MetaData)mmd, propName, value);
        }
        this.relationStoreInfos.clear();
        return modifiedEntity;
    }

    private String getExpectedChildType(AbstractMemberMetaData dependent) {
        if (dependent.getCollection() != null) {
            CollectionMetaData cmd = dependent.getCollection();
            return cmd.getElementType();
        }
        if (dependent.getArray() != null) {
            ArrayMetaData amd = dependent.getArray();
            return amd.getElementType();
        }
        return dependent.getTypeName();
    }

    private void addToParentKeyMap(KeyRegistry keyRegistry, Object childValue, Key key, ExecutionContext ec, String expectedType, boolean checkForPolymorphism) {
        AbstractClassMetaData acmd;
        if (checkForPolymorphism && childValue != null && !childValue.getClass().getName().equals(expectedType) && !MetaDataUtils.isNewOrSuperclassTableInheritanceStrategy(acmd = ec.getMetaDataManager().getMetaDataForClass(childValue.getClass(), ec.getClassLoaderResolver()))) {
            throw new UnsupportedOperationException("Received a child of type " + childValue.getClass().getName() + " for a field of type " + expectedType + ". Unfortunately polymorphism in relationships is only supported for the " + "superclass-table inheritance mapping strategy.");
        }
        keyRegistry.registerParentKeyForOwnedObject(childValue, key);
    }

    Object establishEntityGroup() {
        Key parentKey = this.datastoreEntity.getParent();
        if (parentKey == null) {
            KeyRegistry keyReg = KeyRegistry.getKeyRegistry(this.op.getExecutionContext());
            if (keyReg.isUnowned(this.op.getObject())) {
                return null;
            }
            parentKey = EntityUtils.getParentKey(this.datastoreEntity, this.op);
            if (parentKey != null) {
                this.datastoreEntity = EntityUtils.recreateEntityWithParent(parentKey, this.datastoreEntity);
            }
        }
        AbstractMemberMetaData parentPkMmd = this.getStoreManager().getMetaDataForParentPK(this.getClassMetaData());
        if (parentKey != null && parentPkMmd != null) {
            return parentPkMmd.getType().equals(Key.class) ? parentKey : KeyFactory.keyToString((Key)parentKey);
        }
        return null;
    }

    private class RelationStoreInformation {
        AbstractMemberMetaData mmd;
        Object value;

        public RelationStoreInformation(AbstractMemberMetaData mmd, Object val) {
            this.mmd = mmd;
            this.value = val;
        }
    }

    protected static enum Operation {
        INSERT,
        UPDATE;

    }
}

