/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.datanucleus.BatchManager;
import com.google.appengine.datanucleus.DatastorePersistenceHandler;
import com.google.appengine.datanucleus.DatastoreTransaction;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.Utils;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.store.ExecutionContext;

public class BatchDeleteManager
extends BatchManager<BatchDeleteState> {
    ExecutionContext ec;

    public BatchDeleteManager(ExecutionContext ec) {
        this.ec = ec;
    }

    @Override
    String getOperation() {
        return "delete";
    }

    @Override
    void processBatchState(DatastorePersistenceHandler handler, List<BatchDeleteState> batchDeleteStateList) {
        DatastoreTransaction txn = batchDeleteStateList.get(0).txn;
        ArrayList<Object> keyList = Utils.newArrayList(new Object[0]);
        for (BatchDeleteState bds : batchDeleteStateList) {
            if (bds.txn != txn) {
                throw new IllegalStateException("Batch delete cannot involve multiple txns.");
            }
            keyList.add(bds.key);
        }
        EntityUtils.deleteEntitiesFromDatastore(this.ec, keyList);
    }

    static final class BatchDeleteState {
        private final DatastoreTransaction txn;
        private final Key key;

        BatchDeleteState(DatastoreTransaction txn, Key key) {
            this.txn = txn;
            this.key = key;
        }
    }
}

