/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.enhancement;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.api.jpa.enhancement.SingleFieldPK;

public class LongFieldPK
extends SingleFieldPK {
    private long key;

    public LongFieldPK(Class pcClass, long key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.hashClassName() ^ (int)this.key;
    }

    public LongFieldPK(Class pcClass, Long key) {
        super(pcClass);
        this.setKeyAsObject(key);
        this.key = key;
        this.hashCode = this.hashClassName() ^ (int)this.key;
    }

    public LongFieldPK(Class pcClass, String str) {
        super(pcClass);
        this.assertKeyNotNull(str);
        this.key = Long.parseLong(str);
        this.hashCode = this.hashClassName() ^ (int)this.key;
    }

    public LongFieldPK() {
    }

    public long getKey() {
        return this.key;
    }

    public String toString() {
        return Long.toString(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        LongFieldPK other = (LongFieldPK)obj;
        return this.key == other.key;
    }

    public int compareTo(Object o) {
        if (o instanceof LongFieldPK) {
            LongFieldPK other = (LongFieldPK)o;
            return (int)(this.key - other.key);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    protected Object createKeyAsObject() {
        return this.key;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.key);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readLong();
    }
}

