/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

@GoogleInternal
public final class BuildData {
    private static Properties properties;
    private static volatile boolean warned;
    public static final String BUILT_ON = "Built on";
    public static final String BUILD_CHANGELIST = "Build changelist";
    public static final String BUILD_VERSION_MAP = "Build version map";
    public static final String BUILD_TARGET = "Build target";
    public static final String BUILT_AT = "Built at";
    public static final String BUILD_TIMESTAMP_AS_INT = "Build timestamp as int";
    public static final String BUILD_TIMESTAMP = "Build timestamp";
    public static final String BUILD_CHANGELIST_AS_INT = "Build changelist as int";
    public static final String DEPENDENCIES = "Dependencies";
    public static final String MPM_VERSION = "Mpm version";
    public static final String BUILD_TOOL = "Build tool";
    public static final String BUILD_LABEL = "Build label";
    public static final String BUILD_DEPOT_PATH = "Build depot path";
    public static final String BUILD_CLIENT = "Build client";
    private static Map<String, String> testData;
    public static final int UNKNOWN_BUILD_CHANGELIST = -1;
    public static final String UNKNOWN_BUILD_VERSION_MAP = "map 0 { // }";

    private BuildData() {
    }

    private static synchronized Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
            try {
                InputStream in = BuildData.class.getResourceAsStream("/build-data.properties");
                if (in != null) {
                    properties.load(in);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    private static Map<String, String> readDataFromProperties() {
        Properties props = BuildData.getProperties();
        if (props.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> buildData = new LinkedHashMap<String, String>();
        buildData.put(BUILT_ON, props.getProperty("build.time", ""));
        buildData.put(BUILD_TIMESTAMP, props.getProperty("build.timestamp", ""));
        buildData.put(BUILD_TIMESTAMP_AS_INT, props.getProperty("build.timestamp.as.int", ""));
        buildData.put(BUILT_AT, props.getProperty("build.location", ""));
        buildData.put(BUILD_TARGET, props.getProperty("build.target", ""));
        buildData.put(BUILD_CHANGELIST, props.getProperty("build.changelist", ""));
        buildData.put(BUILD_CHANGELIST_AS_INT, props.getProperty("build.changelist.as.int", ""));
        buildData.put(BUILD_VERSION_MAP, props.getProperty("build.versionmap", ""));
        buildData.put(BUILD_CLIENT, props.getProperty("build.client", ""));
        buildData.put(BUILD_DEPOT_PATH, props.getProperty("build.depot.path", ""));
        buildData.put(BUILD_LABEL, props.getProperty("build.label", ""));
        buildData.put(BUILD_TOOL, props.getProperty("build.tool", ""));
        buildData.put(MPM_VERSION, props.getProperty("build.mpm.version", ""));
        buildData.put(DEPENDENCIES, props.getProperty("build.dependencies", ""));
        return buildData;
    }

    public static Class<?> getEntryClass() {
        try {
            String mainClass = BuildData.getProperties().getProperty("main.class");
            if (mainClass == null) {
                return null;
            }
            return Class.forName(mainClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Map<String, String> getData() {
        Map<String, String> data = BuildData.tryGetData();
        if (data != null) {
            return data;
        }
        if (!warned) {
            warned = true;
            Logger logger = Logger.getLogger(BuildData.class.getName());
            logger.info("No build data available; consider building this application as a deploy jar");
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> tryGetData() {
        if (testData != null) {
            return testData;
        }
        return BuildData.readDataFromProperties();
    }

    public static int getBuildChangelist() {
        try {
            return Integer.parseInt(BuildData.getData().get(BUILD_CHANGELIST));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getBuildVersionMap() {
        String versionMap = BuildData.getData().get(BUILD_VERSION_MAP);
        return versionMap != null ? versionMap : UNKNOWN_BUILD_VERSION_MAP;
    }

    public static String getBuildDepotPath() {
        String depotPath = BuildData.getData().get(BUILD_DEPOT_PATH);
        return depotPath != null ? depotPath : "//depot/google3";
    }

    public static void write(OutputStream output) {
        Map<String, String> data = BuildData.tryGetData();
        if (data != null) {
            PrintWriter pw = new PrintWriter(output);
            for (Map.Entry<String, String> entry : data.entrySet()) {
                String name = entry.getKey().toLowerCase().replace(' ', '-');
                pw.write(name + ": " + entry.getValue() + "\n");
            }
            pw.flush();
        }
    }

    public static void setTestData(Map<String, String> testData) {
        BuildData.testData = new HashMap<String, String>(testData);
    }

    public static void unsetTestData() {
        testData = null;
    }

    public static void main(String[] args) {
        BuildData.write(System.out);
    }

    static {
        testData = null;
    }
}

