/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.collections.impl.Vector;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Hierarchy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;

public class Tool {
    protected Hierarchy theHierarchy;
    protected String grammarFileName;
    protected String[] args;
    protected int nargs;
    protected Vector grammars;
    protected antlr.Tool antlrTool;

    public Tool(antlr.Tool t, String[] args) {
        this.antlrTool = t;
        this.processArguments(args);
    }

    public static void main(String[] args) {
        antlr.Tool antlrTool = new antlr.Tool();
        Tool theTool = new Tool(antlrTool, args);
        theTool.preprocess();
        String[] a = theTool.preprocessedArgList();
        int i = 0;
        while (i < a.length) {
            System.out.print(" " + a[i]);
            ++i;
        }
        System.out.println();
    }

    public boolean preprocess() {
        boolean complete;
        if (this.grammarFileName == null) {
            this.antlrTool.toolError("no grammar file specified");
            return false;
        }
        if (this.grammars != null) {
            this.theHierarchy = new Hierarchy(this.antlrTool);
            Enumeration e = this.grammars.elements();
            while (e.hasMoreElements()) {
                String f = (String)e.nextElement();
                try {
                    this.theHierarchy.readGrammarFile(f);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.antlrTool.toolError("file " + f + " not found");
                    return false;
                }
            }
        }
        if (!(complete = this.theHierarchy.verifyThatHierarchyIsComplete())) {
            return false;
        }
        this.theHierarchy.expandGrammarsInFile(this.grammarFileName);
        GrammarFile gf = this.theHierarchy.getFile(this.grammarFileName);
        String expandedFileName = gf.nameForExpandedGrammarFile(this.grammarFileName);
        if (expandedFileName.equals(this.grammarFileName)) {
            this.args[this.nargs++] = this.grammarFileName;
        } else {
            try {
                gf.generateExpandedFile();
                this.args[this.nargs++] = String.valueOf(this.antlrTool.getOutputDirectory()) + System.getProperty("file.separator") + expandedFileName;
            }
            catch (IOException iOException) {
                this.antlrTool.toolError("cannot write expanded grammar file " + expandedFileName);
                return false;
            }
        }
        return true;
    }

    public String[] preprocessedArgList() {
        String[] a = new String[this.nargs];
        System.arraycopy(this.args, 0, a, 0, this.nargs);
        this.args = a;
        return this.args;
    }

    private void processArguments(String[] incomingArgs) {
        this.nargs = 0;
        this.args = new String[incomingArgs.length];
        int i = 0;
        while (i < incomingArgs.length) {
            if (incomingArgs[i].length() == 0) {
                this.antlrTool.warning("Zero length argument ignoring...");
            } else if (incomingArgs[i].equals("-glib")) {
                if (File.separator.equals("\\") && incomingArgs[i].indexOf(47) != -1) {
                    this.antlrTool.warning("-glib cannot deal with '/' on a PC: use '\\'; ignoring...");
                } else {
                    this.grammars = antlr.Tool.parseSeparatedList(incomingArgs[i + 1], ';');
                    ++i;
                }
            } else if (incomingArgs[i].equals("-o")) {
                this.args[this.nargs++] = incomingArgs[i];
                if (i + 1 >= incomingArgs.length) {
                    this.antlrTool.error("missing output directory with -o option; ignoring");
                } else {
                    this.args[this.nargs++] = incomingArgs[++i];
                    this.antlrTool.setOutputDirectory(incomingArgs[i]);
                }
            } else if (incomingArgs[i].charAt(0) == '-') {
                this.args[this.nargs++] = incomingArgs[i];
            } else {
                this.grammarFileName = incomingArgs[i];
                if (this.grammars == null) {
                    this.grammars = new Vector(10);
                }
                this.grammars.appendElement(this.grammarFileName);
                if (i + 1 < incomingArgs.length) {
                    this.antlrTool.warning("grammar file must be last; ignoring other arguments...");
                    break;
                }
            }
            ++i;
        }
    }
}

