/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrintWriterWithSMAP
extends PrintWriter {
    private int currentOutputLine = 1;
    private int currentSourceLine = 0;
    private Map sourceMap = new HashMap();
    private boolean lastPrintCharacterWasCR = false;
    private boolean mapLines = false;
    private boolean mapSingleSourceLine = false;
    private boolean anythingWrittenSinceMapping = false;

    public PrintWriterWithSMAP(OutputStream out) {
        super(out);
    }

    public PrintWriterWithSMAP(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public PrintWriterWithSMAP(Writer out) {
        super(out);
    }

    public PrintWriterWithSMAP(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void startMapping(int sourceLine) {
        this.mapLines = true;
        if (sourceLine != -888) {
            this.currentSourceLine = sourceLine;
        }
    }

    public void startSingleSourceLineMapping(int sourceLine) {
        this.mapSingleSourceLine = true;
        this.mapLines = true;
        if (sourceLine != -888) {
            this.currentSourceLine = sourceLine;
        }
    }

    public void endMapping() {
        this.mapLine(false);
        this.mapLines = false;
        this.mapSingleSourceLine = false;
    }

    protected void mapLine(boolean incrementOutputLineCount) {
        if (this.mapLines && this.anythingWrittenSinceMapping) {
            Integer sourceLine = new Integer(this.currentSourceLine);
            Integer outputLine = new Integer(this.currentOutputLine);
            ArrayList<Integer> outputLines = (ArrayList<Integer>)this.sourceMap.get(sourceLine);
            if (outputLines == null) {
                outputLines = new ArrayList<Integer>();
                this.sourceMap.put(sourceLine, outputLines);
            }
            if (!outputLines.contains(outputLine)) {
                outputLines.add(outputLine);
            }
        }
        if (incrementOutputLineCount) {
            ++this.currentOutputLine;
        }
        if (!this.mapSingleSourceLine) {
            ++this.currentSourceLine;
        }
        this.anythingWrittenSinceMapping = false;
    }

    public void dump(PrintWriter smapWriter, String targetClassName, String grammarFile) {
        smapWriter.println("SMAP");
        smapWriter.println(String.valueOf(targetClassName) + ".java");
        smapWriter.println("G");
        smapWriter.println("*S G");
        smapWriter.println("*F");
        smapWriter.println("+ 0 " + grammarFile);
        smapWriter.println(grammarFile);
        smapWriter.println("*L");
        ArrayList sortedSourceLines = new ArrayList(this.sourceMap.keySet());
        Collections.sort(sortedSourceLines);
        Iterator i = sortedSourceLines.iterator();
        while (i.hasNext()) {
            Integer sourceLine = (Integer)i.next();
            List outputLines = (List)this.sourceMap.get(sourceLine);
            Iterator j = outputLines.iterator();
            while (j.hasNext()) {
                Integer outputLine = (Integer)j.next();
                smapWriter.println(sourceLine + ":" + outputLine);
            }
        }
        smapWriter.println("*E");
        smapWriter.close();
    }

    public void write(char[] buf, int off, int len) {
        int stop = off + len;
        int i = off;
        while (i < stop) {
            this.checkChar(buf[i]);
            ++i;
        }
        super.write(buf, off, len);
    }

    public void checkChar(int c) {
        if (this.lastPrintCharacterWasCR && c != 10) {
            this.mapLine(true);
        } else if (c == 10) {
            this.mapLine(true);
        } else if (!Character.isWhitespace((char)c)) {
            this.anythingWrittenSinceMapping = true;
        }
        this.lastPrintCharacterWasCR = c == 13;
    }

    public void write(int c) {
        this.checkChar(c);
        super.write(c);
    }

    public void write(String s, int off, int len) {
        int stop = off + len;
        int i = off;
        while (i < stop) {
            this.checkChar(s.charAt(i));
            ++i;
        }
        super.write(s, off, len);
    }

    public void println() {
        this.mapLine(true);
        super.println();
        this.lastPrintCharacterWasCR = false;
    }

    public Map getSourceMap() {
        return this.sourceMap;
    }

    public int getCurrentOutputLine() {
        return this.currentOutputLine;
    }
}

