/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.editors;

import com.android.ddmuilib.AbstractBufferFindTarget;
import com.android.ddmuilib.FindDialog;
import com.android.ddmuilib.IFindTarget;
import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.GlTracePlugin;
import com.android.ide.eclipse.gltrace.SwtUtils;
import com.android.ide.eclipse.gltrace.TraceFileParserTask;
import com.android.ide.eclipse.gltrace.editors.DurationMinimap;
import com.android.ide.eclipse.gltrace.editors.GLCallGroups;
import com.android.ide.eclipse.gltrace.editors.StateViewPage;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLFrame;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import com.android.ide.eclipse.gltrace.views.FrameSummaryViewPage;
import com.android.ide.eclipse.gltrace.views.detail.DetailsPage;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;

public class GLFunctionTraceViewer
extends EditorPart
implements ISelectionProvider {
    public static final String ID = "com.android.ide.eclipse.gltrace.GLFunctionTrace";
    private static final String DEFAULT_FILTER_MESSAGE = "Filter list of OpenGL calls. Accepts Java regexes.";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static Image sExpandAllIcon;
    private static String sLastExportedToFolder;
    private String mFilePath;
    private Scale mFrameSelectionScale;
    private Spinner mFrameSelectionSpinner;
    private GLTrace mTrace;
    private TreeViewer mFrameTreeViewer;
    private List<GLCallGroups.GLCallNode> mTreeViewerNodes;
    private Text mFilterText;
    private GLCallFilter mGLCallFilter;
    private Color mGldrawTextColor;
    private Color mGlCallErrorColor;
    private Job mTreeRefresherJob;
    private final Object mTreeRefresherLock = new Object();
    private static final int TREE_REFRESH_INTERVAL_MS = 250;
    private int mCurrentFrame;
    private int mCallStartIndex;
    private int mCallEndIndex;
    private DurationMinimap mDurationMinimap;
    private ScrollBar mVerticalScrollBar;
    private Combo mContextSwitchCombo;
    private boolean mShowContextSwitcher;
    private int mCurrentlyDisplayedContext = -1;
    private StateViewPage mStateViewPage;
    private FrameSummaryViewPage mFrameSummaryViewPage;
    private DetailsPage mDetailsPage;
    private ToolItem mExpandAllToolItem;
    private ToolItem mCollapseAllToolItem;
    private ToolItem mSaveAsToolItem;
    private FindDialog mFindDialog;
    private TraceViewerFindTarget mFindTarget = new TraceViewerFindTarget();

    public GLFunctionTraceViewer() {
        this.mGldrawTextColor = Display.getDefault().getSystemColor(9);
        this.mGlCallErrorColor = Display.getDefault().getSystemColor(3);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IURIEditorInput)) {
            throw new PartInitException("GL Function Trace View: unsupported input type.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.mFilePath = ((IURIEditorInput)input).getURI().getPath();
        File f = new File(this.mFilePath);
        this.setPartName(f.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        this.setInput(parent.getShell(), this.mFilePath);
        this.createFrameSelectionControls(c);
        this.createOptionsBar(c);
        this.createFrameTraceView(c);
        this.getSite().setSelectionProvider((ISelectionProvider)this.mFrameTreeViewer);
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action("Copy"){

            public void run() {
                GLFunctionTraceViewer.this.copySelectionToClipboard();
            }
        });
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action("Select All"){

            public void run() {
                GLFunctionTraceViewer.this.selectAll();
            }
        });
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)new Action("Find"){

            public void run() {
                GLFunctionTraceViewer.this.showFindDialog();
            }
        });
    }

    public void setInput(Shell shell, String tracePath) {
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(shell);
        TraceFileParserTask parser = new TraceFileParserTask(this.mFilePath);
        try {
            dlg.run(true, true, (IRunnableWithProgress)parser);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)shell, (String)"Error parsing OpenGL Trace File", (String)e.getCause().getMessage());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.mTrace = parser.getTrace();
        boolean bl = this.mTrace == null ? false : (this.mShowContextSwitcher = this.mTrace.getContexts().size() > 1);
        if (this.mStateViewPage != null) {
            this.mStateViewPage.setInput(this.mTrace);
        }
        if (this.mFrameSummaryViewPage != null) {
            this.mFrameSummaryViewPage.setInput(this.mTrace);
        }
        if (this.mDetailsPage != null) {
            this.mDetailsPage.setInput(this.mTrace);
        }
        if (this.mDurationMinimap != null) {
            this.mDurationMinimap.setInput(this.mTrace);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                GLFunctionTraceViewer.this.refreshUI();
            }
        });
    }

    private void refreshUI() {
        if (this.mTrace == null || this.mTrace.getGLCalls().size() == 0) {
            this.setFrameCount(0);
            return;
        }
        this.setFrameCount(this.mTrace.getFrames().size());
        this.selectFrame(1);
    }

    private void createFrameSelectionControls(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        c.setLayoutData((Object)gd);
        Label l = new Label(c, 0);
        l.setText("Select Frame:");
        this.mFrameSelectionScale = new Scale(c, 256);
        this.mFrameSelectionScale.setMinimum(1);
        this.mFrameSelectionScale.setMaximum(1);
        this.mFrameSelectionScale.setSelection(0);
        gd = new GridData(768);
        this.mFrameSelectionScale.setLayoutData((Object)gd);
        this.mFrameSelectionScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedFrame = GLFunctionTraceViewer.this.mFrameSelectionScale.getSelection();
                GLFunctionTraceViewer.this.mFrameSelectionSpinner.setSelection(selectedFrame);
                GLFunctionTraceViewer.this.selectFrame(selectedFrame);
            }
        });
        this.mFrameSelectionSpinner = new Spinner(c, 2048);
        gd = new GridData();
        gd.widthHint = SwtUtils.getApproximateFontWidth((Control)this.mFrameSelectionSpinner) * 6;
        this.mFrameSelectionSpinner.setLayoutData((Object)gd);
        this.mFrameSelectionSpinner.setMinimum(1);
        this.mFrameSelectionSpinner.setMaximum(1);
        this.mFrameSelectionSpinner.setSelection(0);
        this.mFrameSelectionSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedFrame = GLFunctionTraceViewer.this.mFrameSelectionSpinner.getSelection();
                GLFunctionTraceViewer.this.mFrameSelectionScale.setSelection(selectedFrame);
                GLFunctionTraceViewer.this.selectFrame(selectedFrame);
            }
        });
    }

    private void setFrameCount(int nFrames) {
        boolean en = nFrames > 0;
        this.mFrameSelectionScale.setEnabled(en);
        this.mFrameSelectionSpinner.setEnabled(en);
        this.mFrameSelectionScale.setMaximum(nFrames);
        this.mFrameSelectionSpinner.setMaximum(nFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFrame(int selectedFrame) {
        this.mFrameSelectionScale.setSelection(selectedFrame);
        this.mFrameSelectionSpinner.setSelection(selectedFrame);
        Object object = this.mTreeRefresherLock;
        synchronized (object) {
            if (this.mTrace != null) {
                GLFrame f = this.mTrace.getFrame(selectedFrame - 1);
                this.mCallStartIndex = f.getStartIndex();
                this.mCallEndIndex = f.getEndIndex();
            } else {
                this.mCallEndIndex = 0;
                this.mCallStartIndex = 0;
            }
            this.mCurrentFrame = selectedFrame - 1;
            this.scheduleNewRefreshJob();
        }
        this.mDurationMinimap.setCallRangeForCurrentFrame(this.mCallStartIndex, this.mCallEndIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectContext(int context) {
        if (this.mCurrentlyDisplayedContext == context) {
            return;
        }
        Object object = this.mTreeRefresherLock;
        synchronized (object) {
            this.mCurrentlyDisplayedContext = context;
            this.scheduleNewRefreshJob();
        }
    }

    private void scheduleNewRefreshJob() {
        if (this.mTreeRefresherJob != null) {
            return;
        }
        this.mTreeRefresherJob = new Job("Refresh GL Trace View Tree"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                int context;
                int end;
                int start;
                Object object = GLFunctionTraceViewer.this.mTreeRefresherLock;
                synchronized (object) {
                    start = GLFunctionTraceViewer.this.mCallStartIndex;
                    end = GLFunctionTraceViewer.this.mCallEndIndex;
                    context = GLFunctionTraceViewer.this.mCurrentlyDisplayedContext;
                    GLFunctionTraceViewer.this.mTreeRefresherJob = null;
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GLFunctionTraceViewer.this.refreshTree(start, end, context);
                        if (GLFunctionTraceViewer.this.mFrameSummaryViewPage != null) {
                            GLFunctionTraceViewer.this.mFrameSummaryViewPage.setSelectedFrame(GLFunctionTraceViewer.this.mCurrentFrame);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.mTreeRefresherJob.setPriority(20);
        this.mTreeRefresherJob.schedule(250L);
    }

    private void refreshTree(int startCallIndex, int endCallIndex, int contextToDisplay) {
        this.mTreeViewerNodes = GLCallGroups.constructCallHierarchy(this.mTrace, startCallIndex, endCallIndex, contextToDisplay);
        this.mFrameTreeViewer.setInput(this.mTreeViewerNodes);
        this.mFrameTreeViewer.refresh();
        this.mFrameTreeViewer.expandAll();
    }

    private void createOptionsBar(Composite parent) {
        int numColumns = this.mShowContextSwitcher ? 4 : 3;
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(numColumns, false));
        GridData gd = new GridData(768);
        c.setLayoutData((Object)gd);
        Label l = new Label(c, 0);
        l.setText("Filter:");
        this.mFilterText = new Text(c, 2944);
        this.mFilterText.setLayoutData((Object)new GridData(768));
        this.mFilterText.setMessage(DEFAULT_FILTER_MESSAGE);
        this.mFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GLFunctionTraceViewer.this.updateAppliedFilters();
            }
        });
        if (this.mShowContextSwitcher) {
            this.mContextSwitchCombo = new Combo(c, 2056);
            this.mContextSwitchCombo.add("All Contexts");
            this.mContextSwitchCombo.select(0);
            this.mCurrentlyDisplayedContext = -1;
            int i = 0;
            while (i < this.mTrace.getContexts().size()) {
                this.mContextSwitchCombo.add("Context " + i);
                ++i;
            }
            this.mContextSwitchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GLFunctionTraceViewer.this.selectContext(GLFunctionTraceViewer.this.mContextSwitchCombo.getSelectionIndex() - 1);
                }
            });
        } else {
            this.mCurrentlyDisplayedContext = 0;
        }
        ToolBar toolBar = new ToolBar(c, 0x800800);
        this.mExpandAllToolItem = new ToolItem(toolBar, 8);
        this.mExpandAllToolItem.setToolTipText("Expand All");
        if (sExpandAllIcon == null) {
            ImageDescriptor id = GlTracePlugin.getImageDescriptor("/icons/expandall.png");
            sExpandAllIcon = id.createImage();
        }
        if (sExpandAllIcon != null) {
            this.mExpandAllToolItem.setImage(sExpandAllIcon);
        }
        this.mCollapseAllToolItem = new ToolItem(toolBar, 8);
        this.mCollapseAllToolItem.setToolTipText("Collapse All");
        this.mCollapseAllToolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_COLLAPSEALL"));
        this.mSaveAsToolItem = new ToolItem(toolBar, 8);
        this.mSaveAsToolItem.setToolTipText("Export Trace");
        this.mSaveAsToolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVEAS_EDIT"));
        SelectionAdapter toolbarSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == GLFunctionTraceViewer.this.mCollapseAllToolItem) {
                    GLFunctionTraceViewer.this.setTreeItemsExpanded(false);
                } else if (e.getSource() == GLFunctionTraceViewer.this.mExpandAllToolItem) {
                    GLFunctionTraceViewer.this.setTreeItemsExpanded(true);
                } else if (e.getSource() == GLFunctionTraceViewer.this.mSaveAsToolItem) {
                    GLFunctionTraceViewer.this.exportTrace();
                }
            }
        };
        this.mExpandAllToolItem.addSelectionListener((SelectionListener)toolbarSelectionListener);
        this.mCollapseAllToolItem.addSelectionListener((SelectionListener)toolbarSelectionListener);
        this.mSaveAsToolItem.addSelectionListener((SelectionListener)toolbarSelectionListener);
    }

    private void updateAppliedFilters() {
        this.mGLCallFilter.setFilters(this.mFilterText.getText().trim());
        this.mFrameTreeViewer.refresh();
    }

    private void createFrameTraceView(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        final Tree tree = new Tree(c, 67586);
        gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.mFrameTreeViewer = new TreeViewer(tree);
        GLFrameLabelProvider labelProvider = new GLFrameLabelProvider();
        TreeViewerColumn tvc = new TreeViewerColumn(this.mFrameTreeViewer, 0);
        tvc.setLabelProvider((CellLabelProvider)labelProvider);
        TreeColumn column = tvc.getColumn();
        column.setText("Function");
        column.setWidth(500);
        tvc = new TreeViewerColumn(this.mFrameTreeViewer, 0);
        tvc.setLabelProvider((CellLabelProvider)labelProvider);
        column = tvc.getColumn();
        column.setText("Wall Time (ns)");
        column.setWidth(150);
        column.setAlignment(131072);
        tvc = new TreeViewerColumn(this.mFrameTreeViewer, 0);
        tvc.setLabelProvider((CellLabelProvider)labelProvider);
        column = tvc.getColumn();
        column.setText("Thread Time (ns)");
        column.setWidth(150);
        column.setAlignment(131072);
        this.mFrameTreeViewer.setContentProvider((IContentProvider)new GLFrameContentProvider());
        this.mGLCallFilter = new GLCallFilter();
        this.mFrameTreeViewer.addFilter((ViewerFilter)this.mGLCallFilter);
        tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int w = ((GLFunctionTraceViewer)GLFunctionTraceViewer.this).mFrameTreeViewer.getTree().getClientArea().width;
                if (w > 200) {
                    GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getColumn(2).setWidth(100);
                    GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getColumn(1).setWidth(100);
                    GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getColumn(0).setWidth(w - 200);
                }
            }
        });
        this.mDurationMinimap = new DurationMinimap(c, this.mTrace);
        gd = new GridData(1040);
        gd.widthHint = gd.minimumWidth = this.mDurationMinimap.getMinimumWidth();
        this.mDurationMinimap.setLayoutData(gd);
        this.mDurationMinimap.addCallSelectionListener(new DurationMinimap.ICallSelectionListener(){

            @Override
            public void callSelected(int selectedCallIndex) {
                if (selectedCallIndex > 0 && selectedCallIndex < GLFunctionTraceViewer.this.mTreeViewerNodes.size()) {
                    TreeItem item = tree.getItem(selectedCallIndex);
                    tree.select(item);
                    tree.setTopItem(item);
                }
            }
        });
        this.mVerticalScrollBar = tree.getVerticalBar();
        this.mVerticalScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GLFunctionTraceViewer.this.updateVisibleRange();
            }
        });
    }

    private void updateVisibleRange() {
        int visibleCallTopIndex = this.mCallStartIndex;
        int visibleCallBottomIndex = this.mCallEndIndex;
        if (this.mVerticalScrollBar.isEnabled()) {
            int selection = this.mVerticalScrollBar.getSelection();
            int thumb = this.mVerticalScrollBar.getThumb();
            int max = this.mVerticalScrollBar.getMaximum();
            double top = (double)selection / (double)max;
            double bottom = (double)(selection + thumb) / (double)max;
            int range = this.mCallEndIndex - this.mCallStartIndex;
            visibleCallTopIndex = this.mCallStartIndex + (int)Math.floor((double)range * top);
            visibleCallBottomIndex = this.mCallStartIndex + (int)Math.ceil((double)range * bottom);
        }
        this.mDurationMinimap.setVisibleCallRange(visibleCallTopIndex, visibleCallBottomIndex);
    }

    public void setFocus() {
        this.mFrameTreeViewer.getTree().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.mFrameTreeViewer != null) {
            this.mFrameTreeViewer.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.mFrameTreeViewer != null) {
            return this.mFrameTreeViewer.getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.mFrameTreeViewer != null) {
            this.mFrameTreeViewer.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.mFrameTreeViewer != null) {
            this.mFrameTreeViewer.setSelection(selection);
        }
    }

    public GLTrace getTrace() {
        return this.mTrace;
    }

    public StateViewPage getStateViewPage() {
        if (this.mStateViewPage == null) {
            this.mStateViewPage = new StateViewPage(this.mTrace);
        }
        return this.mStateViewPage;
    }

    public FrameSummaryViewPage getFrameSummaryViewPage() {
        if (this.mFrameSummaryViewPage == null) {
            this.mFrameSummaryViewPage = new FrameSummaryViewPage(this.mTrace);
        }
        return this.mFrameSummaryViewPage;
    }

    public DetailsPage getDetailsPage() {
        if (this.mDetailsPage == null) {
            this.mDetailsPage = new DetailsPage(this.mTrace);
        }
        return this.mDetailsPage;
    }

    private void copySelectionToClipboard() {
        if (this.mFrameTreeViewer == null || this.mFrameTreeViewer.getTree().isDisposed()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        TreeItem[] treeItemArray = this.mFrameTreeViewer.getTree().getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem it = treeItemArray[n2];
            Object data = it.getData();
            if (data instanceof GLCallGroups.GLCallNode) {
                sb.append(((GLCallGroups.GLCallNode)data).getCall());
                sb.append(NEWLINE);
            }
            ++n2;
        }
        if (sb.length() > 0) {
            Clipboard cb = new Clipboard(Display.getDefault());
            cb.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
            cb.dispose();
        }
    }

    private void selectAll() {
        if (this.mFrameTreeViewer == null || this.mFrameTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.mFrameTreeViewer.getTree().selectAll();
    }

    private void exportTrace() {
        String path;
        if (this.mFrameTreeViewer == null || this.mFrameTreeViewer.getTree().isDisposed()) {
            return;
        }
        if (this.mCallEndIndex == 0) {
            return;
        }
        FileDialog fd = new FileDialog(this.mFrameTreeViewer.getTree().getShell(), 8192);
        fd.setFilterExtensions(new String[]{"*.txt"});
        if (sLastExportedToFolder != null) {
            fd.setFilterPath(sLastExportedToFolder);
        }
        if ((path = fd.open()) == null) {
            return;
        }
        File f = new File(path);
        sLastExportedToFolder = f.getParent();
        try {
            this.exportFrameTo(f);
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.mFrameTreeViewer.getTree().getShell(), (String)"Export trace file.", (String)"Unexpected error exporting trace file.", (IStatus)new Status(4, "com.android.ide.eclipse.gldebugger", e.toString()));
        }
    }

    private void exportFrameTo(File f) throws IOException {
        String glCalls = this.serializeGlCalls(this.mTrace.getGLCalls(), this.mCallStartIndex, this.mCallEndIndex);
        Files.write((CharSequence)glCalls, (File)f, (Charset)Charsets.UTF_8);
    }

    private String serializeGlCalls(List<GLCall> glCalls, int start, int end) {
        StringBuilder sb = new StringBuilder();
        while (start < end) {
            sb.append(glCalls.get(start).toString());
            sb.append("\n");
            ++start;
        }
        return sb.toString();
    }

    private void setTreeItemsExpanded(boolean expand) {
        if (this.mFrameTreeViewer == null || this.mFrameTreeViewer.getTree().isDisposed()) {
            return;
        }
        if (expand) {
            this.mFrameTreeViewer.expandAll();
        } else {
            this.mFrameTreeViewer.collapseAll();
        }
    }

    private void showFindDialog() {
        if (this.mFindDialog != null) {
            return;
        }
        this.mFindDialog = new FindDialog(Display.getDefault().getActiveShell(), (IFindTarget)this.mFindTarget, 1024);
        this.mFindDialog.open();
        this.mFindDialog = null;
    }

    public String getInputPath() {
        return this.mFilePath;
    }

    private static class GLCallFilter
    extends ViewerFilter {
        private final List<Pattern> mPatterns = new ArrayList<Pattern>();

        private GLCallFilter() {
        }

        public void setFilters(String filter) {
            this.mPatterns.clear();
            String[] stringArray = filter.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String regex = stringArray[n2];
                this.mPatterns.add(Pattern.compile(regex, 2));
                ++n2;
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof GLCallGroups.GLCallNode)) {
                return true;
            }
            String text = this.getTextUnderNode((GLCallGroups.GLCallNode)element);
            if (this.mPatterns.size() == 0) {
                return true;
            }
            for (Pattern p : this.mPatterns) {
                Matcher matcher = p.matcher(text);
                if (!matcher.find()) continue;
                return true;
            }
            return false;
        }

        private String getTextUnderNode(GLCallGroups.GLCallNode element) {
            String func = element.getCall().getFunction().toString();
            if (!element.hasChildren()) {
                return func;
            }
            StringBuilder sb = new StringBuilder(100);
            sb.append(func);
            for (GLCallGroups.GLCallNode child : element.getChildren()) {
                sb.append(this.getTextUnderNode(child));
            }
            return sb.toString();
        }
    }

    private static class GLFrameContentProvider
    implements ITreeContentProvider {
        private GLFrameContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            if (!(parentElement instanceof GLCallGroups.GLCallNode)) {
                return null;
            }
            GLCallGroups.GLCallNode parent = (GLCallGroups.GLCallNode)parentElement;
            if (parent.hasChildren()) {
                return parent.getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (!(element instanceof GLCallGroups.GLCallNode)) {
                return null;
            }
            return ((GLCallGroups.GLCallNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            if (!(element instanceof GLCallGroups.GLCallNode)) {
                return false;
            }
            return ((GLCallGroups.GLCallNode)element).hasChildren();
        }
    }

    private class GLFrameLabelProvider
    extends ColumnLabelProvider {
        private GLFrameLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (!(element instanceof GLCallGroups.GLCallNode)) {
                return;
            }
            GLCall c = ((GLCallGroups.GLCallNode)element).getCall();
            if (c.getFunction() == GLProtoBuf.GLMessage.Function.glDrawArrays || c.getFunction() == GLProtoBuf.GLMessage.Function.glDrawElements) {
                cell.setForeground(GLFunctionTraceViewer.this.mGldrawTextColor);
            }
            if (c.hasErrors()) {
                cell.setForeground(GLFunctionTraceViewer.this.mGlCallErrorColor);
            }
            cell.setText(this.getColumnText(c, cell.getColumnIndex()));
        }

        private String getColumnText(GLCall c, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Object marker;
                    if (c.getFunction() == GLProtoBuf.GLMessage.Function.glPushGroupMarkerEXT && (marker = c.getProperty(0)) instanceof String) {
                        return (String)marker;
                    }
                    return c.toString();
                }
                case 1: {
                    return this.formatDuration(c.getWallDuration());
                }
                case 2: {
                    return this.formatDuration(c.getThreadDuration());
                }
            }
            return Integer.toString(c.getContextId());
        }

        private String formatDuration(int time) {
            return String.format("%,10d", time);
        }
    }

    private class TraceViewerFindTarget
    extends AbstractBufferFindTarget {
        private TraceViewerFindTarget() {
        }

        public int getItemCount() {
            return GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getItemCount();
        }

        public String getItem(int index) {
            Object data = GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getItem(index).getData();
            if (data instanceof GLCallGroups.GLCallNode) {
                return ((GLCallGroups.GLCallNode)data).getCall().toString();
            }
            return null;
        }

        public void selectAndReveal(int index) {
            Tree t = GLFunctionTraceViewer.this.mFrameTreeViewer.getTree();
            t.deselectAll();
            t.select(t.getItem(index));
            t.showSelection();
        }

        public int getStartingIndex() {
            return 0;
        }
    }
}

