/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import com.android.sdklib.internal.project.ProjectProperties;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GetProjectPathsTask
extends Task {
    private String mProjectPath;
    private String mBinName;
    private String mSrcName;

    public void setProjectPath(String projectPath) {
        this.mProjectPath = projectPath;
    }

    public void setBinOut(String binName) {
        this.mBinName = binName;
    }

    public void setSrcOut(String srcName) {
        this.mSrcName = srcName;
    }

    public void execute() throws BuildException {
        if (this.mProjectPath == null) {
            throw new BuildException("Missing attribute projectPath");
        }
        ProjectProperties props = TaskHelper.getProperties(this.mProjectPath);
        if (this.mBinName != null) {
            this.handleProp(props, "out.dir", this.mBinName);
        }
        if (this.mSrcName != null) {
            this.handleProp(props, "source.dir", this.mSrcName);
        }
    }

    private void handleProp(ProjectProperties props, String inName, String outName) {
        String value = props.getProperty(inName);
        if (value == null) {
            value = TaskHelper.getDefault(inName);
        }
        this.getProject().setProperty(outName, new File(this.mProjectPath, value).getAbsolutePath());
    }
}

