/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.systrace;

import com.android.ide.eclipse.ddms.systrace.ISystraceOptions;
import com.android.ide.eclipse.ddms.systrace.ISystraceOptionsDialog;
import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystraceOptionsDialogV1
extends TitleAreaDialog
implements ISystraceOptionsDialog {
    private static final String TITLE = "Android System Trace";
    private static final String DEFAULT_MESSAGE = "Settings to use while capturing system level trace";
    private static final String DEFAULT_TRACE_FNAME = "trace.html";
    private Text mDestinationText;
    private String mDestinationPath;
    private Text mTraceDurationText;
    private Text mTraceBufferSizeText;
    private static String sSaveToFolder = System.getProperty("user.home");
    private static String sTraceDuration = "";
    private static String sTraceBufferSize = "";
    private Button mTraceCpuFreqBtn;
    private Button mTraceCpuIdleBtn;
    private Button mTraceCpuLoadBtn;
    private Button mTraceDiskIoBtn;
    private Button mTraceKernelWorkqueuesBtn;
    private Button mTraceCpuSchedulerBtn;
    private static boolean sTraceCpuFreq;
    private static boolean sTraceCpuIdle;
    private static boolean sTraceCpuLoad;
    private static boolean sTraceDiskIo;
    private static boolean sTraceKernelWorkqueues;
    private static boolean sTraceCpuScheduler;
    private Button mGfxTagBtn;
    private Button mInputTagBtn;
    private Button mViewTagBtn;
    private Button mWebViewTagBtn;
    private Button mWmTagBtn;
    private Button mAmTagBtn;
    private Button mSyncTagBtn;
    private Button mAudioTagBtn;
    private Button mVideoTagBtn;
    private Button mCameraTagBtn;
    private static boolean sGfxTag;
    private static boolean sInputTag;
    private static boolean sViewTag;
    private static boolean sWebViewTag;
    private static boolean sWmTag;
    private static boolean sAmTag;
    private static boolean sSyncTag;
    private static boolean sAudioTag;
    private static boolean sVideoTag;
    private static boolean sCameraTag;
    private final SystraceOptions mOptions = new SystraceOptions();

    public SystraceOptionsDialogV1(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        Composite c = new Composite(parent, 2048);
        c.setLayout((Layout)new GridLayout(3, false));
        c.setLayoutData((Object)new GridData(1808));
        Label l = new Label(c, 0);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        l.setText("Destination File: ");
        this.mDestinationText = new Text(c, 2048);
        this.mDestinationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mDestinationText.setText(String.valueOf(sSaveToFolder) + File.separator + DEFAULT_TRACE_FNAME);
        final Button browse = new Button(c, 0);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = SystraceOptionsDialogV1.this.openBrowseDialog(browse.getShell());
                if (path != null) {
                    SystraceOptionsDialogV1.this.mDestinationText.setText(path);
                }
            }
        });
        Label lblTraceDurationseconds = new Label(c, 0);
        lblTraceDurationseconds.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTraceDurationseconds.setText("Trace duration (seconds): ");
        this.mTraceDurationText = new Text(c, 2048);
        this.mTraceDurationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mTraceDurationText.setText(sTraceDuration);
        Label lblTraceBufferSize = new Label(c, 0);
        lblTraceBufferSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTraceBufferSize.setText("Trace Buffer Size (kb): ");
        this.mTraceBufferSizeText = new Text(c, 2048);
        this.mTraceBufferSizeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mTraceBufferSizeText.setText(sTraceBufferSize);
        Label separator = new Label(c, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        separator.setLayoutData((Object)gd);
        Group grpTraceEvents = new Group(c, 2048);
        grpTraceEvents.setLayout((Layout)new GridLayout(3, false));
        grpTraceEvents.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        grpTraceEvents.setText("Trace Events");
        this.mTraceCpuFreqBtn = new Button((Composite)grpTraceEvents, 32);
        this.mTraceCpuFreqBtn.setText("CPU Frequency Changes");
        this.mTraceCpuFreqBtn.setSelection(sTraceCpuFreq);
        this.mTraceCpuIdleBtn = new Button((Composite)grpTraceEvents, 32);
        this.mTraceCpuIdleBtn.setText("CPU Idle Events");
        this.mTraceCpuIdleBtn.setSelection(sTraceCpuIdle);
        this.mTraceCpuLoadBtn = new Button((Composite)grpTraceEvents, 32);
        this.mTraceCpuLoadBtn.setText("CPU Load");
        this.mTraceCpuLoadBtn.setSelection(sTraceCpuLoad);
        this.mTraceCpuSchedulerBtn = new Button((Composite)grpTraceEvents, 32);
        this.mTraceCpuSchedulerBtn.setText("CPU Scheduler");
        this.mTraceCpuSchedulerBtn.setSelection(sTraceCpuScheduler);
        Group grpTraceRootEvents = new Group(c, 2048);
        grpTraceRootEvents.setLayout((Layout)new GridLayout(2, false));
        grpTraceRootEvents.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        grpTraceRootEvents.setText("Trace Events that require root privileges on device");
        this.mTraceDiskIoBtn = new Button((Composite)grpTraceRootEvents, 32);
        this.mTraceDiskIoBtn.setText("Disk I/O");
        this.mTraceDiskIoBtn.setSelection(sTraceDiskIo);
        this.mTraceKernelWorkqueuesBtn = new Button((Composite)grpTraceRootEvents, 32);
        this.mTraceKernelWorkqueuesBtn.setText("Kernel Workqueues (requires root)");
        this.mTraceKernelWorkqueuesBtn.setSelection(sTraceKernelWorkqueues);
        Group grpTraceTags = new Group(c, 2048);
        grpTraceTags.setLayout((Layout)new GridLayout(5, false));
        grpTraceTags.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        grpTraceTags.setText("Trace Tags");
        this.mGfxTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mGfxTagBtn.setText("gfx");
        this.mGfxTagBtn.setSelection(sGfxTag);
        this.mInputTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mInputTagBtn.setText("input");
        this.mInputTagBtn.setSelection(sInputTag);
        this.mViewTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mViewTagBtn.setText("view");
        this.mViewTagBtn.setSelection(sViewTag);
        this.mWebViewTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mWebViewTagBtn.setText("webview");
        this.mWebViewTagBtn.setSelection(sWebViewTag);
        this.mWmTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mWmTagBtn.setText("wm");
        this.mWmTagBtn.setSelection(sWmTag);
        this.mAmTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mAmTagBtn.setText("am");
        this.mAmTagBtn.setSelection(sAmTag);
        this.mSyncTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mSyncTagBtn.setText("sync");
        this.mSyncTagBtn.setSelection(sSyncTag);
        this.mAudioTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mAudioTagBtn.setText("audio");
        this.mAudioTagBtn.setSelection(sAudioTag);
        this.mVideoTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mVideoTagBtn.setText("video");
        this.mVideoTagBtn.setSelection(sVideoTag);
        this.mCameraTagBtn = new Button((Composite)grpTraceTags, 32);
        this.mCameraTagBtn.setText("camera");
        this.mCameraTagBtn.setSelection(sCameraTag);
        Label lblTraceTagsWarning = new Label((Composite)grpTraceTags, 0);
        lblTraceTagsWarning.setText("Changes to trace tags will likely need a restart of the Android framework to take effect:\n    $ adb shell stop\n    $ adb shell start");
        lblTraceTagsWarning.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 5, 1));
        ModifyListener m = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystraceOptionsDialogV1.this.validateFields();
            }
        };
        this.mDestinationText.addModifyListener(m);
        this.mTraceBufferSizeText.addModifyListener(m);
        this.mTraceDurationText.addModifyListener(m);
        return c;
    }

    private void validateFields() {
        String msg = this.validatePath(this.mDestinationText.getText());
        if (msg != null) {
            this.setErrorMessage(msg);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!this.validateInteger(this.mTraceDurationText.getText())) {
            this.setErrorMessage("Trace Duration should be a valid integer (seconds)");
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!this.validateInteger(this.mTraceBufferSizeText.getText())) {
            this.setErrorMessage("Trace Buffer Size should be a valid integer (kilobytes)");
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
        this.setErrorMessage(null);
    }

    private boolean validateInteger(String text) {
        if (text == null || text.isEmpty()) {
            return true;
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String validatePath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        File f = new File(path);
        if (f.isDirectory()) {
            return String.format("The path '%s' points to a folder", path);
        }
        if (!f.exists() && !f.getParentFile().isDirectory()) {
            return String.format("That path '%s' is not a valid folder.", f.getParent());
        }
        return null;
    }

    private String openBrowseDialog(Shell parentShell) {
        FileDialog fd = new FileDialog(parentShell, 8192);
        fd.setText("Save To");
        fd.setFileName(DEFAULT_TRACE_FNAME);
        fd.setFilterPath(sSaveToFolder);
        fd.setFilterExtensions(new String[]{"*.html"});
        String fname = fd.open();
        if (fname == null || fname.trim().length() == 0) {
            return null;
        }
        sSaveToFolder = fd.getFilterPath();
        return fname;
    }

    protected void okPressed() {
        this.mDestinationPath = this.mDestinationText.getText().trim();
        sTraceDuration = this.mTraceDurationText.getText();
        if (!sTraceDuration.isEmpty()) {
            this.mOptions.mTraceDuration = Integer.parseInt(SystraceOptionsDialogV1.sTraceDuration);
        }
        if (!(sTraceBufferSize = this.mTraceBufferSizeText.getText()).isEmpty()) {
            this.mOptions.mTraceBufferSize = Integer.parseInt(SystraceOptionsDialogV1.sTraceBufferSize);
        }
        this.mOptions.mTraceCpuFreq = this.mTraceCpuFreqBtn.getSelection();
        this.mOptions.mTraceCpuIdle = this.mTraceCpuIdleBtn.getSelection();
        this.mOptions.mTraceCpuLoad = this.mTraceCpuLoadBtn.getSelection();
        this.mOptions.mTraceDiskIo = this.mTraceDiskIoBtn.getSelection();
        this.mOptions.mTraceKernelWorkqueues = this.mTraceKernelWorkqueuesBtn.getSelection();
        this.mOptions.mTraceCpuScheduler = this.mTraceCpuSchedulerBtn.getSelection();
        if (this.mGfxTagBtn.getSelection()) {
            this.mOptions.enableTag(2);
        }
        if (this.mInputTagBtn.getSelection()) {
            this.mOptions.enableTag(4);
        }
        if (this.mViewTagBtn.getSelection()) {
            this.mOptions.enableTag(8);
        }
        if (this.mWebViewTagBtn.getSelection()) {
            this.mOptions.enableTag(16);
        }
        if (this.mWmTagBtn.getSelection()) {
            this.mOptions.enableTag(32);
        }
        if (this.mAmTagBtn.getSelection()) {
            this.mOptions.enableTag(64);
        }
        if (this.mSyncTagBtn.getSelection()) {
            this.mOptions.enableTag(128);
        }
        if (this.mAudioTagBtn.getSelection()) {
            this.mOptions.enableTag(256);
        }
        if (this.mVideoTagBtn.getSelection()) {
            this.mOptions.enableTag(512);
        }
        if (this.mCameraTagBtn.getSelection()) {
            this.mOptions.enableTag(1024);
        }
        sTraceCpuFreq = this.mTraceCpuFreqBtn.getSelection();
        sTraceCpuIdle = this.mTraceCpuIdleBtn.getSelection();
        sTraceCpuLoad = this.mTraceCpuLoadBtn.getSelection();
        sTraceDiskIo = this.mTraceDiskIoBtn.getSelection();
        sTraceKernelWorkqueues = this.mTraceKernelWorkqueuesBtn.getSelection();
        sTraceCpuScheduler = this.mTraceCpuSchedulerBtn.getSelection();
        sGfxTag = this.mGfxTagBtn.getSelection();
        sInputTag = this.mInputTagBtn.getSelection();
        sViewTag = this.mViewTagBtn.getSelection();
        sWebViewTag = this.mWebViewTagBtn.getSelection();
        sWmTag = this.mWmTagBtn.getSelection();
        sAmTag = this.mAmTagBtn.getSelection();
        sSyncTag = this.mSyncTagBtn.getSelection();
        sAudioTag = this.mAudioTagBtn.getSelection();
        sVideoTag = this.mVideoTagBtn.getSelection();
        sCameraTag = this.mCameraTagBtn.getSelection();
        super.okPressed();
    }

    @Override
    public SystraceOptions getSystraceOptions() {
        return this.mOptions;
    }

    @Override
    public String getTraceFilePath() {
        return this.mDestinationPath;
    }

    private class SystraceOptions
    implements ISystraceOptions {
        private static final int TAG_GFX = 2;
        private static final int TAG_INPUT = 4;
        private static final int TAG_VIEW = 8;
        private static final int TAG_WEBVIEW = 16;
        private static final int TAG_WM = 32;
        private static final int TAG_AM = 64;
        private static final int TAG_SYNC = 128;
        private static final int TAG_AUDIO = 256;
        private static final int TAG_VIDEO = 512;
        private static final int TAG_CAMERA = 1024;
        private int mTraceBufferSize;
        private int mTraceDuration;
        private boolean mTraceCpuFreq;
        private boolean mTraceCpuIdle;
        private boolean mTraceCpuLoad;
        private boolean mTraceDiskIo;
        private boolean mTraceKernelWorkqueues;
        private boolean mTraceCpuScheduler;
        private int mTag;

        private SystraceOptions() {
        }

        private void enableTag(int tag) {
            this.mTag |= tag;
        }

        @Override
        public String getTags() {
            return this.mTag == 0 ? null : "0x" + Integer.toHexString(this.mTag);
        }

        @Override
        public String getOptions() {
            StringBuilder sb = new StringBuilder(20);
            if (this.mTraceCpuFreq) {
                sb.append("-f ");
            }
            if (this.mTraceCpuIdle) {
                sb.append("-i ");
            }
            if (this.mTraceCpuLoad) {
                sb.append("-l ");
            }
            if (this.mTraceDiskIo) {
                sb.append("-d ");
            }
            if (this.mTraceKernelWorkqueues) {
                sb.append("-w ");
            }
            if (this.mTraceCpuScheduler) {
                sb.append("-s ");
            }
            if (this.mTraceDuration > 0) {
                sb.append("-t");
                sb.append(this.mTraceDuration);
                sb.append(' ');
            }
            if (this.mTraceBufferSize > 0) {
                sb.append("-b ");
                sb.append(this.mTraceBufferSize);
                sb.append(' ');
            }
            return sb.toString().trim();
        }
    }
}

