/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.models;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.hierarchyviewerlib.device.IHvDevice;

public class Window {
    private final String mTitle;
    private final int mHashCode;
    private final IHvDevice mHvDevice;
    private final Client mClient;

    public Window(IHvDevice device, String title, int hashCode) {
        this.mHvDevice = device;
        this.mTitle = title;
        this.mHashCode = hashCode;
        this.mClient = null;
    }

    public Window(IHvDevice device, String title, Client c) {
        this.mHvDevice = device;
        this.mTitle = title;
        this.mClient = c;
        this.mHashCode = c.hashCode();
    }

    public String getTitle() {
        return this.mTitle;
    }

    public int getHashCode() {
        return this.mHashCode;
    }

    public String encode() {
        return Integer.toHexString(this.mHashCode);
    }

    public String toString() {
        return this.mTitle;
    }

    public IHvDevice getHvDevice() {
        return this.mHvDevice;
    }

    public IDevice getDevice() {
        return this.mHvDevice.getDevice();
    }

    public Client getClient() {
        return this.mClient;
    }

    public static Window getFocusedWindow(IHvDevice device) {
        return new Window(device, "<Focused Window>", -1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Window other = (Window)obj;
        if (this.mHvDevice == null ? other.mHvDevice != null : !this.mHvDevice.getDevice().getSerialNumber().equals(other.mHvDevice.getDevice().getSerialNumber())) {
            return false;
        }
        return this.mHashCode == other.mHashCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mHvDevice == null ? 0 : this.mHvDevice.getDevice().getSerialNumber().hashCode());
        result = 31 * result + this.mHashCode;
        return result;
    }
}

