/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ValueResourceParser2 {
    private final File mFile;

    ValueResourceParser2(File file) {
        this.mFile = file;
    }

    @NonNull
    List<ResourceItem> parseFile() throws MergingException {
        Document document = ValueResourceParser2.parseDocument(this.mFile);
        Element rootNode = document.getDocumentElement();
        if (rootNode == null) {
            return Collections.emptyList();
        }
        NodeList nodes = rootNode.getChildNodes();
        int count = nodes.getLength();
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)count);
        EnumMap map = Maps.newEnumMap(ResourceType.class);
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            ResourceItem resource;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser2.getResource(node)) == null) continue;
            ValueResourceParser2.checkDuplicate(resource, map);
            resources.add(resource);
            if (resource.getType() != ResourceType.DECLARE_STYLEABLE) continue;
            try {
                ValueResourceParser2.addStyleableItems(node, resources, map);
                continue;
            }
            catch (MergingException e) {
                e.setFile(this.mFile);
                throw e;
            }
        }
        return resources;
    }

    static ResourceItem getResource(Node node) {
        ResourceType type = ValueResourceParser2.getType(node);
        String name = ValueResourceParser2.getName(node);
        if (type != null && name != null) {
            return new ResourceItem(name, type, node);
        }
        return null;
    }

    static ResourceType getType(Node node) {
        String nodeName = node.getLocalName();
        String typeString = null;
        if ("item".equals(nodeName)) {
            Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "type");
            if (attribute != null) {
                typeString = attribute.getValue();
            }
        } else {
            typeString = nodeName;
        }
        if (typeString != null) {
            return ResourceType.getEnum(typeString);
        }
        return null;
    }

    static String getName(Node node) {
        Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "name");
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    static Document parseDocument(File file) throws MergingException {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            InputSource is = new InputSource(stream);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (SAXParseException e) {
            try {
                String message = e.getLocalizedMessage();
                MergingException exception = new MergingException(message, e);
                exception.setFile(file);
                int lineNumber = e.getLineNumber();
                if (lineNumber != -1) {
                    exception.setLine(lineNumber - 1);
                    exception.setColumn(e.getColumnNumber() - 1);
                }
                throw exception;
                catch (ParserConfigurationException e2) {
                    throw new MergingException(e2).setFile(file);
                }
                catch (SAXException e3) {
                    throw new MergingException(e3).setFile(file);
                }
                catch (IOException e4) {
                    throw new MergingException(e4).setFile(file);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)stream);
        return document;
    }

    static void addStyleableItems(@NonNull Node styleableNode, @NonNull List<ResourceItem> list, @Nullable Map<ResourceType, Set<String>> map) throws MergingException {
        assert (styleableNode.getNodeName().equals(ResourceType.DECLARE_STYLEABLE.getName()));
        NodeList nodes = styleableNode.getChildNodes();
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            ResourceItem resource;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser2.getResource(node)) == null) continue;
            assert (resource.getType() == ResourceType.ATTR);
            if (resource.getName().startsWith("android:") || !ValueResourceParser2.hasFormatAttribute(node)) continue;
            ValueResourceParser2.checkDuplicate(resource, map);
            resource.setIgnoredFromDiskMerge(true);
            list.add(resource);
        }
    }

    private static void checkDuplicate(@NonNull ResourceItem resource, @Nullable Map<ResourceType, Set<String>> map) throws MergingException {
        if (map == null) {
            return;
        }
        String name = resource.getName();
        HashSet set = map.get((Object)resource.getType());
        if (set == null) {
            set = Sets.newHashSet((Object[])new String[]{name});
            map.put(resource.getType(), set);
        } else {
            if (set.contains(name)) {
                throw new MergingException(String.format("Found item %s/%s more than one time", resource.getType().getDisplayName(), name));
            }
            set.add((String)name);
        }
    }

    private static boolean hasFormatAttribute(Node node) {
        return node.getAttributes().getNamedItemNS(null, "format") != null;
    }
}

