/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.exception;

import com.vladium.util.exception.ExceptionCommon;
import com.vladium.util.exception.ICodedException;
import com.vladium.util.exception.IThrowableWrapper;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class AbstractRuntimeException
extends RuntimeException
implements ICodedException,
IThrowableWrapper {
    private String m_message;
    private final transient Object[] m_arguments;
    private final Throwable m_cause;

    public AbstractRuntimeException() {
        this.m_cause = null;
        this.m_arguments = null;
    }

    public AbstractRuntimeException(String string) {
        super(string);
        this.m_cause = null;
        this.m_arguments = null;
    }

    public AbstractRuntimeException(String string, Object[] objectArray) {
        super(string);
        this.m_cause = null;
        this.m_arguments = objectArray == null ? null : (Object[])objectArray.clone();
    }

    public AbstractRuntimeException(Throwable throwable) {
        this.m_cause = throwable;
        this.m_arguments = null;
    }

    public AbstractRuntimeException(String string, Throwable throwable) {
        super(string);
        this.m_cause = throwable;
        this.m_arguments = null;
    }

    public AbstractRuntimeException(String string, Object[] objectArray, Throwable throwable) {
        super(string);
        this.m_cause = throwable;
        this.m_arguments = objectArray == null ? null : (Object[])objectArray.clone();
    }

    public final String getMessage() {
        if (this.m_message == null) {
            String string = super.getMessage();
            Class<?> clazz = this.getClass();
            String string2 = this.m_arguments == null ? ExceptionCommon.getMessage(clazz, string) : ExceptionCommon.getMessage(clazz, string, this.m_arguments);
            if (string2 == null) {
                String string3 = clazz.getName();
                string2 = string != null ? string3 + ": " + string : string3;
            }
            this.m_message = string2;
        }
        return this.m_message;
    }

    public final String getLocalizedMessage() {
        return this.getMessage();
    }

    public final void printStackTrace() {
        ExceptionCommon.printStackTrace((Throwable)this, System.out);
    }

    public final void printStackTrace(PrintStream printStream) {
        ExceptionCommon.printStackTrace((Throwable)this, printStream);
    }

    public final void printStackTrace(PrintWriter printWriter) {
        ExceptionCommon.printStackTrace((Throwable)this, printWriter);
    }

    public final String getErrorCode() {
        return super.getMessage();
    }

    public final Throwable getCause() {
        return this.m_cause;
    }

    public void __printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
    }

    public void __printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }

    public static void addExceptionResource(Class clazz, String string) {
        ExceptionCommon.addExceptionResource(clazz, string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getMessage();
        objectOutputStream.defaultWriteObject();
    }
}

