/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.args;

import com.vladium.util.IConstants;
import com.vladium.util.ResourceLoader;
import com.vladium.util.args.IOptsParser;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class OptsParser
implements IOptsParser {
    private final String m_msgPrefix;
    private final OptDefMetadata m_metadata;
    private static final int CANONICAL_OPT_PREFIX = 1;
    private static final String[] OPT_PREFIXES = new String[]{"--", "-"};
    private static final char[] OPT_VALUE_SEPARATORS = new char[]{':', '='};
    private static final int STATE_OPT = 0;
    private static final int STATE_OPT_VALUE = 1;
    private static final int STATE_FREE_ARGS = 2;
    private static final int STATE_ERROR = 3;

    public synchronized void usage(PrintWriter printWriter, int n, int n2) {
        String string = OPT_PREFIXES[1];
        Object object = this.m_metadata.getOptDefs();
        while (object.hasNext()) {
            int n3;
            int n4;
            OptDef optDef = (OptDef)object.next();
            if (n < 2 && optDef.isDetailedOnly()) continue;
            StringBuffer stringBuffer = new StringBuffer("  ");
            String string2 = optDef.getCanonicalName();
            boolean bl = optDef.isPattern();
            stringBuffer.append(string);
            stringBuffer.append(string2);
            if (bl) {
                stringBuffer.append('*');
            }
            String[] stringArray = optDef.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.equals(string2)) continue;
                stringBuffer.append(", ");
                stringBuffer.append(string);
                stringBuffer.append(string3);
                if (!bl) continue;
                stringBuffer.append('*');
            }
            String string4 = optDef.getValueMnemonic();
            if (string4 != null) {
                stringBuffer.append(' ');
                stringBuffer.append(string4);
            }
            if ((n4 = 16 - stringBuffer.length()) < 2) {
                printWriter.println(stringBuffer);
                stringBuffer.setLength(0);
                for (n3 = 0; n3 < 16; ++n3) {
                    stringBuffer.append(' ');
                }
            } else {
                for (n3 = 0; n3 < n4; ++n3) {
                    stringBuffer.append(' ');
                }
            }
            if (optDef.isRequired()) {
                stringBuffer.append("{required} ");
            }
            stringBuffer.append(optDef.getDescription());
            printWriter.println(stringBuffer);
        }
        if (n < 2 && (object = this.m_metadata.getUsageOptDef()) != null && ((OptDef)object).getNames() != null && ((OptDef)object).getNames().length > 1) {
            printWriter.println();
            printWriter.println("  {use '" + ((OptDef)object).getNames()[1] + "' option to see detailed usage help}");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized IOptsParser.IOpts parse(String[] var1_1) {
        if (var1_1 == null) {
            throw new IllegalArgumentException("null input: args");
        }
        var2_2 = new Opts();
        var3_3 = new String[2];
        var4_4 = new String[1];
        var5_5 = 0;
        var6_8 = null;
        var7_9 = null;
        var8_10 /* !! */  = null;
        var9_11 = 0;
        var10_13 = 0;
        block6: while (var10_13 < var1_1.length) {
            var11_14 = var1_1[var10_13];
            if (var11_14 == null) {
                throw new IllegalArgumentException("null input: args[" + var10_13 + "]");
            }
            switch (var5_5) {
                case 0: {
                    if (OptsParser.isOpt((String)var11_14, var9_11, (OptDef)var6_8)) {
                        var9_11 = 0;
                        OptsParser.getOptNameAndValue((String)var11_14, (String[])var3_3);
                        var12_15 /* !! */  = (int[])var3_3[0];
                        var6_8 = this.m_metadata.getOptDef((String)var12_15 /* !! */ , (String[])var4_4);
                        if (var6_8 == null) {
                            var2_2.addError(this.formatMessage("unknown option '" + (String)var12_15 /* !! */  + "'"));
                            var5_5 = 3;
                        } else {
                            var13_16 = OptsParser.getOptCanonicalName((String)var12_15 /* !! */ , (OptDef)var6_8);
                            var14_17 = var4_4[0];
                            var7_9 = var2_2.getOpt(var13_16);
                            if (var6_8.isMergeable()) {
                                if (var7_9 == null) {
                                    var7_9 = new Opt((String)var12_15 /* !! */ , var13_16, (String)var14_17);
                                    var2_2.addOpt((Opt)var7_9, (OptDef)var6_8, (String)var12_15 /* !! */ );
                                }
                            } else if (var7_9 == null) {
                                var7_9 = new Opt((String)var12_15 /* !! */ , var13_16, (String)var14_17);
                                var2_2.addOpt((Opt)var7_9, (OptDef)var6_8, (String)var12_15 /* !! */ );
                            } else {
                                var2_2.addError(this.formatMessage("option '" + (String)var12_15 /* !! */  + "' cannot be specified more than once"));
                                var5_5 = 3;
                            }
                            if ((var8_10 /* !! */  = var3_3[1]) == null) {
                                ++var10_13;
                            }
                            var5_5 = 1;
                        }
                    } else {
                        var5_5 = 2;
                    }
                    ** GOTO lbl83
                }
                case 1: {
                    if (var8_10 /* !! */  != null) {
                        var9_11 = 1;
                        var12_15 /* !! */  = var6_8.getValueCardinality();
                        if (var12_15 /* !! */ [1] < 1) {
                            var2_2.addError(this.formatMessage("option '" + var7_9.getName() + "' does not accept values: '" + (String)var8_10 /* !! */  + "'"));
                            var5_5 = 3;
                        } else {
                            ++var10_13;
                            var7_9.addValue((String)var8_10 /* !! */ );
                        }
                    } else {
                        var8_10 /* !! */  = var1_1[var10_13];
                        var12_15 /* !! */  = var6_8.getValueCardinality();
                        if (OptsParser.isOpt((String)var8_10 /* !! */ , var9_11, (OptDef)var6_8)) {
                            if (var9_11 < var12_15 /* !! */ [0]) {
                                var2_2.addError(this.formatMessage("option '" + var7_9.getName() + "' does not accept fewer than " + var12_15 /* !! */ [0] + " value(s)"));
                                var5_5 = 3;
                            } else {
                                var5_5 = 0;
                            }
                        } else if (var9_11 < var12_15 /* !! */ [1]) {
                            ++var9_11;
                            ++var10_13;
                            var7_9.addValue((String)var8_10 /* !! */ );
                        } else {
                            var5_5 = 2;
                        }
                    }
                    var8_10 /* !! */  = null;
                    ** GOTO lbl83
                }
                case 2: {
                    if (!OptsParser.isOpt(var1_1[var10_13], var9_11, (OptDef)var6_8)) ** GOTO lbl79
                    var5_5 = 0;
                    ** GOTO lbl83
lbl79:
                    // 1 sources

                    var2_2.setFreeArgs(var1_1, var10_13);
                    break block6;
                }
                case 3: {
                    break block6;
                }
lbl83:
                // 6 sources

                default: {
                    continue block6;
                }
            }
        }
        if (var10_13 == var1_1.length) {
            if (var7_9 != null) {
                var11_14 = var6_8.getValueCardinality();
                if (var9_11 < var11_14[0]) {
                    var2_2.addError(this.formatMessage("option '" + var7_9.getName() + "' does not accept fewer than " + (int)var11_14[0] + " value(s)"));
                }
            } else {
                var2_2.setFreeArgs(var1_1, var10_13);
            }
        }
        if ((var3_3 = var2_2.getOpts()) != null) {
            var4_4 = new HashSet<E>();
            var4_4.addAll(this.m_metadata.getRequiredOpts());
            for (var5_5 = 0; var5_5 < var3_3.length; ++var5_5) {
                var4_4.remove(var3_3[var5_5].getCanonicalName());
            }
            if (!var4_4.isEmpty()) {
                var5_6 = var4_4.iterator();
                while (var5_6.hasNext()) {
                    var2_2.addError(this.formatMessage("missing required option '" + (String)var5_6.next() + "'"));
                }
            }
            for (var5_7 = 0; var5_7 < var3_3.length; ++var5_7) {
                var6_8 = var3_3[var5_7];
                var7_9 = this.m_metadata.getOptDef(var6_8.getCanonicalName(), null);
                var8_10 /* !! */  = var7_9.getRequiresSet();
                if (var8_10 /* !! */  != null) {
                    for (var9_11 = 0; var9_11 < var8_10 /* !! */ .length; ++var9_11) {
                        if (var2_2.getOpt(var8_10 /* !! */ [var9_11]) != null) continue;
                        var2_2.addError(this.formatMessage("option '" + var6_8.getName() + "' requires option '" + var8_10 /* !! */ [var9_11] + "'"));
                    }
                }
                if ((var9_12 = var7_9.getExcludesSet()) != null) {
                    for (var10_13 = 0; var10_13 < var9_12.length; ++var10_13) {
                        var11_14 = var2_2.getOpt(var9_12[var10_13]);
                        if (var11_14 == null) continue;
                        var2_2.addError(this.formatMessage("option '" + var6_8.getName() + "' cannot be used with option '" + var11_14.getName() + "'"));
                    }
                }
                if (!var7_9.isUsage()) continue;
                var2_2.setUsageRequested(var6_8.getName().equals(var6_8.getCanonicalName()) != false ? 1 : 2);
            }
        }
        return var2_2;
    }

    private static String getOptCanonicalName(String string, OptDef optDef) {
        if (optDef.isPattern()) {
            String string2 = optDef.getCanonicalName();
            String[] stringArray = optDef.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!string.startsWith(string3)) continue;
                return string2.concat(string.substring(string3.length()));
            }
            throw new IllegalStateException("failed to detect pattern prefix for [" + string + "]");
        }
        return optDef.getCanonicalName();
    }

    private static boolean isOpt(String string, int n, OptDef optDef) {
        int[] nArray;
        if (optDef != null && n < (nArray = optDef.getValueCardinality())[1]) {
            return false;
        }
        for (int i = 0; i < OPT_PREFIXES.length; ++i) {
            if (!string.startsWith(OPT_PREFIXES[i])) continue;
            return string.length() > OPT_PREFIXES[i].length();
        }
        return false;
    }

    private static void getOptNameAndValue(String string, String[] stringArray) {
        stringArray[0] = null;
        stringArray[1] = null;
        for (int i = 0; i < OPT_PREFIXES.length; ++i) {
            if (!string.startsWith(OPT_PREFIXES[i]) || string.length() <= OPT_PREFIXES[i].length()) continue;
            String string2 = string.substring(OPT_PREFIXES[i].length());
            char c = '\u0000';
            int n = Integer.MAX_VALUE;
            for (int j = 0; j < OPT_VALUE_SEPARATORS.length; ++j) {
                int n2 = string2.indexOf(OPT_VALUE_SEPARATORS[j]);
                if (n2 <= 0 || n2 >= n) continue;
                c = OPT_VALUE_SEPARATORS[j];
                n = n2;
            }
            if (c != '\u0000') {
                stringArray[0] = string2.substring(0, n);
                stringArray[1] = string2.substring(n + 1);
            } else {
                stringArray[0] = string2;
            }
            return;
        }
    }

    OptsParser(String string, ClassLoader classLoader, String[] stringArray) {
        this(string, classLoader, null, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptsParser(String string, ClassLoader classLoader, String string2, String[] stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("null input: metadataResourceName");
        }
        this.m_msgPrefix = string2;
        InputStream inputStream = null;
        try {
            inputStream = ResourceLoader.getResourceAsStream(string, classLoader);
            if (inputStream == null) {
                throw new IllegalArgumentException("resource [" + string + "] could not be loaded via [" + classLoader + "]");
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.m_metadata = OptsParser.parseOptDefMetadata(inputStreamReader, stringArray);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static OptDefMetadata parseOptDefMetadata(Reader reader, String[] stringArray) {
        int n;
        MetadataParser metadataParser = new MetadataParser();
        OptDef[] optDefArray = metadataParser.parse(reader);
        OptDefMetadata optDefMetadata = new OptDefMetadata();
        for (n = 0; n < optDefArray.length; ++n) {
            optDefMetadata.addOptDef(optDefArray[n]);
        }
        if (stringArray != null) {
            OptDef optDef = new OptDef(true);
            optDef.setNames(stringArray);
            optDef.setDescription("display usage information");
            optDef.setValueCardinality(OptDef.C_ZERO);
            optDef.setRequired(false);
            optDef.setDetailedOnly(false);
            optDef.setMergeable(false);
            optDefMetadata.addOptDef(optDef);
        }
        for (n = 0; n < optDefArray.length; ++n) {
            String[] stringArray2;
            OptDef optDef = optDefArray[n];
            String[] stringArray3 = optDef.getRequiresSet();
            if (stringArray3 != null) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    OptDef optDef2 = optDefMetadata.getOptDef(stringArray3[i], null);
                    if (optDef2 == null) {
                        throw new IllegalArgumentException("option [" + optDef.getCanonicalName() + "] specifies an unknown option [" + stringArray3[i] + "] in its 'requires' set");
                    }
                    if (optDef2 != optDef) continue;
                    throw new IllegalArgumentException("option [" + optDef.getCanonicalName() + "] specifies itself in its 'requires' set");
                }
            }
            if ((stringArray2 = optDef.getExcludesSet()) == null) continue;
            for (int i = 0; i < stringArray2.length; ++i) {
                OptDef optDef3 = optDefMetadata.getOptDef(stringArray2[i], null);
                if (optDef3 == null) {
                    throw new IllegalArgumentException("option [" + optDef.getCanonicalName() + "] specifies an unknown option [" + stringArray2[i] + "] in its 'excludes' set");
                }
                if (optDef3.isRequired()) {
                    throw new IllegalArgumentException("option [" + optDef.getCanonicalName() + "] specifies a required option [" + stringArray2[i] + "] in its 'excludes' set");
                }
                if (optDef3 != optDef) continue;
                throw new IllegalArgumentException("option [" + optDef.getCanonicalName() + "] specifies itself in its 'excludes' set");
            }
        }
        return optDefMetadata;
    }

    private String formatMessage(String string) {
        if (this.m_msgPrefix == null) {
            return string;
        }
        return this.m_msgPrefix.concat(string);
    }

    private static final class Token {
        static final int EOF_ID = 0;
        static final int STRING_ID = 1;
        static final int COLON_ID = 2;
        static final int SEMICOLON_ID = 3;
        static final int COMMA_ID = 4;
        static final int LBRACKET_ID = 5;
        static final int RBRACKET_ID = 6;
        static final int OPTIONAL_ID = 7;
        static final int REQUIRED_ID = 8;
        static final int CARD_ID = 9;
        static final int VALUES_ID = 10;
        static final int TEXT_ID = 11;
        static final int REQUIRES_ID = 12;
        static final int EXCLUDES_ID = 13;
        static final int MERGEABLE_ID = 14;
        static final int DETAILEDONLY_ID = 15;
        static final int PATTERN_ID = 16;
        static final Token EOF = new Token(0, "<EOF>");
        static final Token COLON = new Token(2, ":");
        static final Token SEMICOLON = new Token(3, ";");
        static final Token COMMA = new Token(4, ",");
        static final Token LBRACKET = new Token(5, "{");
        static final Token RBRACKET = new Token(6, "}");
        static final Token OPTIONAL = new Token(7, "optional");
        static final Token REQUIRED = new Token(8, "required");
        static final Token VALUES = new Token(10, "values");
        static final Token REQUIRES = new Token(12, "requires");
        static final Token EXCLUDES = new Token(13, "excludes");
        static final Token MERGEABLE = new Token(14, "mergeable");
        static final Token DETAILEDONLY = new Token(15, "detailedonly");
        static final Token PATTERN = new Token(16, "pattern");
        private final int m_ID;
        private final String m_value;

        Token(int n, String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: value");
            }
            this.m_ID = n;
            this.m_value = string;
        }

        int getID() {
            return this.m_ID;
        }

        String getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.m_ID + ": [" + this.m_value + "]";
        }
    }

    static final class MetadataParser {
        private Reader m_in;
        private List m_opts;
        private Token m_token;
        private int m_currentChar;
        private static final Map KEYWORDS;
        private static final OptDef[] EMPTY_OPTDEF_ARRAY;

        MetadataParser() {
        }

        OptDef[] parse(Reader reader) {
            OptDef[] optDefArray;
            if (reader == null) {
                throw new IllegalArgumentException("null input: in");
            }
            this.m_in = reader;
            this.nextChar();
            this.nextToken();
            while (this.m_token != Token.EOF) {
                if (this.m_opts == null) {
                    this.m_opts = new ArrayList();
                }
                this.m_opts.add(this.optdef());
            }
            if (this.m_opts == null || this.m_opts.size() == 0) {
                optDefArray = EMPTY_OPTDEF_ARRAY;
            } else {
                optDefArray = new OptDef[this.m_opts.size()];
                this.m_opts.toArray(optDefArray);
            }
            this.m_in = null;
            this.m_opts = null;
            return optDefArray;
        }

        OptDef optdef() {
            OptDef optDef = new OptDef(false);
            optDef.setNames(this.optnamelist());
            this.accept(2);
            this.optmetadata(optDef);
            this.accept(3);
            return optDef;
        }

        String[] optnamelist() {
            return this.namelist();
        }

        void optmetadata(OptDef optDef) {
            switch (this.m_token.getID()) {
                case 8: {
                    this.accept();
                    optDef.setRequired(true);
                    break;
                }
                case 7: {
                    this.accept();
                    optDef.setRequired(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("parse error: invalid token " + this.m_token + ", expected " + Token.REQUIRED + " or " + Token.OPTIONAL);
                }
            }
            this.accept(4);
            if (this.m_token.getID() == 14) {
                this.accept();
                optDef.setMergeable(true);
                this.accept(4);
            }
            if (this.m_token.getID() == 15) {
                this.accept();
                optDef.setDetailedOnly(true);
                this.accept(4);
            }
            if (this.m_token.getID() == 16) {
                this.accept();
                optDef.setPattern(true);
                this.accept(4);
            }
            this.accept(10);
            this.accept(2);
            optDef.setValueCardinality(this.cardinality());
            this.accept(4);
            if (this.m_token.getID() == 1) {
                optDef.setValueMnemonic(this.m_token.getValue());
                this.accept();
                this.accept(4);
            }
            if (this.m_token.getID() == 12) {
                this.accept();
                this.accept(5);
                optDef.setRequiresSet(this.namelist());
                this.accept(6);
                this.accept(4);
            }
            if (this.m_token.getID() == 13) {
                this.accept();
                this.accept(5);
                optDef.setExcludesSet(this.namelist());
                this.accept(6);
                this.accept(4);
            }
            optDef.setDescription(this.accept(11).getValue());
        }

        int[] cardinality() {
            Token token = this.accept(9);
            if ("0".equals(token.getValue())) {
                return OptDef.C_ZERO;
            }
            if ("1".equals(token.getValue())) {
                return OptDef.C_ONE;
            }
            return OptDef.C_ZERO_OR_ONE;
        }

        String[] namelist() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.accept(1).getValue());
            while (this.m_token.getID() == 4) {
                this.accept();
                arrayList.add(this.accept(1).getValue());
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }

        Token accept() {
            Token token = this.m_token;
            this.nextToken();
            return token;
        }

        Token accept(int n) {
            Token token = this.m_token;
            if (this.m_token.getID() != n) {
                throw new IllegalArgumentException("parse error: invalid token [" + this.m_token + "], expected type [" + n + "]");
            }
            this.nextToken();
            return token;
        }

        void nextToken() {
            this.consumeWS();
            switch (this.m_currentChar) {
                case -1: {
                    this.m_token = Token.EOF;
                    break;
                }
                case 58: {
                    this.nextChar();
                    this.m_token = Token.COLON;
                    break;
                }
                case 59: {
                    this.nextChar();
                    this.m_token = Token.SEMICOLON;
                    break;
                }
                case 44: {
                    this.nextChar();
                    this.m_token = Token.COMMA;
                    break;
                }
                case 123: {
                    this.nextChar();
                    this.m_token = Token.LBRACKET;
                    break;
                }
                case 125: {
                    this.nextChar();
                    this.m_token = Token.RBRACKET;
                    break;
                }
                case 48: {
                    this.nextChar();
                    this.m_token = new Token(9, "0");
                    break;
                }
                case 49: {
                    this.nextChar();
                    this.m_token = new Token(9, "1");
                    break;
                }
                case 63: {
                    this.nextChar();
                    this.m_token = new Token(9, "?");
                    break;
                }
                case 39: {
                    StringBuffer stringBuffer = new StringBuffer();
                    this.nextChar();
                    while (this.m_currentChar != 39) {
                        stringBuffer.append((char)this.m_currentChar);
                        this.nextChar();
                    }
                    this.nextChar();
                    this.m_token = new Token(1, stringBuffer.toString());
                    break;
                }
                case 34: {
                    StringBuffer stringBuffer = new StringBuffer();
                    this.nextChar();
                    while (this.m_currentChar != 34) {
                        stringBuffer.append((char)this.m_currentChar);
                        this.nextChar();
                    }
                    this.nextChar();
                    this.m_token = new Token(11, stringBuffer.toString());
                    break;
                }
                default: {
                    StringBuffer stringBuffer = new StringBuffer();
                    while (Character.isLetter((char)this.m_currentChar)) {
                        stringBuffer.append((char)this.m_currentChar);
                        this.nextChar();
                    }
                    Token token = (Token)KEYWORDS.get(stringBuffer.toString());
                    if (token == null) {
                        throw new IllegalArgumentException("parse error: unrecognized keyword [" + stringBuffer + "]");
                    }
                    this.m_token = token;
                }
            }
        }

        private void consumeWS() {
            if (this.m_currentChar == -1) {
                return;
            }
            while (Character.isWhitespace((char)this.m_currentChar)) {
                this.nextChar();
            }
        }

        private void nextChar() {
            try {
                this.m_currentChar = this.m_in.read();
            }
            catch (IOException iOException) {
                throw new RuntimeException("I/O error while parsing: " + iOException);
            }
        }

        static {
            EMPTY_OPTDEF_ARRAY = new OptDef[0];
            KEYWORDS = new HashMap(17);
            KEYWORDS.put(Token.OPTIONAL.getValue(), Token.OPTIONAL);
            KEYWORDS.put(Token.REQUIRED.getValue(), Token.REQUIRED);
            KEYWORDS.put(Token.VALUES.getValue(), Token.VALUES);
            KEYWORDS.put(Token.REQUIRES.getValue(), Token.REQUIRES);
            KEYWORDS.put(Token.EXCLUDES.getValue(), Token.EXCLUDES);
            KEYWORDS.put(Token.MERGEABLE.getValue(), Token.MERGEABLE);
            KEYWORDS.put(Token.DETAILEDONLY.getValue(), Token.DETAILEDONLY);
            KEYWORDS.put(Token.PATTERN.getValue(), Token.PATTERN);
        }
    }

    static final class OptDefMetadata {
        final List m_optdefs = new ArrayList();
        final Map m_optdefMap = new HashMap();
        final Set m_requiredOpts = new HashSet();
        final Map m_patternOptDefMap = new HashMap();
        private OptDef m_usageOptDef;

        OptDefMetadata() {
        }

        OptDef getOptDef(String string, String[] stringArray) {
            OptDef optDef;
            if (string == null) {
                throw new IllegalArgumentException("null input: name");
            }
            if (stringArray != null) {
                stringArray[0] = null;
            }
            if ((optDef = (OptDef)this.m_optdefMap.get(string)) == null) {
                for (Map.Entry entry : this.m_patternOptDefMap.entrySet()) {
                    String string2 = (String)entry.getKey();
                    if (!string.startsWith(string2)) continue;
                    if (stringArray != null) {
                        stringArray[0] = string2;
                    }
                    optDef = (OptDef)entry.getValue();
                    break;
                }
            }
            return optDef;
        }

        Iterator getOptDefs() {
            return this.m_optdefs.iterator();
        }

        OptDef getPatternOptDefs(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: pattern");
            }
            return (OptDef)this.m_patternOptDefMap.get(string);
        }

        Set getRequiredOpts() {
            return this.m_requiredOpts;
        }

        OptDef getUsageOptDef() {
            return this.m_usageOptDef;
        }

        void addOptDef(OptDef optDef) {
            if (optDef == null) {
                throw new IllegalArgumentException("null input: optdef");
            }
            Map map = optDef.isPattern() ? this.m_patternOptDefMap : this.m_optdefMap;
            String[] stringArray = optDef.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (map.containsKey(stringArray[i])) {
                    throw new IllegalArgumentException("duplicate option name [" + stringArray[i] + "]");
                }
                map.put(stringArray[i], optDef);
            }
            this.m_optdefs.add(optDef);
            if (optDef.isRequired()) {
                this.m_requiredOpts.add(optDef.getCanonicalName());
            }
            if (optDef.isUsage()) {
                if (this.m_usageOptDef != null) {
                    throw new IllegalArgumentException("usage optdef set already");
                }
                this.m_usageOptDef = optDef;
            }
        }
    }

    static final class OptDef {
        static final int[] C_ZERO = new int[]{0, 0};
        static final int[] C_ONE = new int[]{1, 1};
        static final int[] C_ZERO_OR_ONE = new int[]{0, 1};
        static final int[] C_ZERO_OR_MORE = new int[]{0, Integer.MAX_VALUE};
        static final int[] C_ONE_OR_MORE = new int[]{1, Integer.MAX_VALUE};
        private final boolean m_usage;
        private String[] m_names;
        private boolean m_required;
        private String m_valueMnemonic;
        private boolean m_mergeable;
        private boolean m_detailedOnly;
        private boolean m_pattern;
        private int[] m_valueCardinality;
        private String[] m_requiresSet;
        private String[] m_excludesSet;
        private String m_description;

        OptDef(boolean bl) {
            this.m_usage = bl;
        }

        boolean isUsage() {
            return this.m_usage;
        }

        String getCanonicalName() {
            return this.m_names[0];
        }

        String[] getNames() {
            return this.m_names;
        }

        boolean isRequired() {
            return this.m_required;
        }

        String getValueMnemonic() {
            return this.m_valueMnemonic;
        }

        boolean isMergeable() {
            return this.m_mergeable;
        }

        boolean isDetailedOnly() {
            return this.m_detailedOnly;
        }

        boolean isPattern() {
            return this.m_pattern;
        }

        int[] getValueCardinality() {
            return this.m_valueCardinality;
        }

        String[] getRequiresSet() {
            return this.m_requiresSet;
        }

        String[] getExcludesSet() {
            return this.m_excludesSet;
        }

        String getDescription() {
            return this.m_description;
        }

        void setNames(String[] stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("null input: names");
            }
            this.m_names = stringArray;
        }

        void setRequired(boolean bl) {
            this.m_required = bl;
        }

        void setValueMnemonic(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: mnemonic");
            }
            this.m_valueMnemonic = string;
        }

        void setMergeable(boolean bl) {
            this.m_mergeable = bl;
        }

        void setDetailedOnly(boolean bl) {
            this.m_detailedOnly = bl;
        }

        void setPattern(boolean bl) {
            this.m_pattern = bl;
        }

        void setValueCardinality(int[] nArray) {
            if (nArray == null || nArray.length != 2) {
                throw new IllegalArgumentException("null or invalid input: cardinality");
            }
            this.m_valueCardinality = nArray;
        }

        void setRequiresSet(String[] stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("null input: names");
            }
            this.m_requiresSet = stringArray.length > 0 ? stringArray : null;
        }

        void setExcludesSet(String[] stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("null input: names");
            }
            this.m_excludesSet = stringArray.length > 0 ? stringArray : null;
        }

        void setDescription(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: description");
            }
            this.m_description = string;
        }
    }

    static final class Opts
    implements IOptsParser.IOpts {
        private final List m_opts = new ArrayList();
        private final Map m_nameMap = new HashMap();
        private final Map m_patternMap = new HashMap();
        private String[] m_freeArgs;
        private List m_errors;
        private int m_usageRequestLevel;
        private static final int DEFAULT_ERROR_WIDTH = 80;
        private static final IOptsParser.IOpt[] EMPTY_OPT_ARRAY = new IOptsParser.IOpt[0];

        public int usageRequestLevel() {
            return this.m_usageRequestLevel;
        }

        public void error(PrintWriter printWriter, int n) {
            if (this.hasErrors()) {
                Iterator iterator = this.m_errors.iterator();
                while (iterator.hasNext()) {
                    printWriter.println(iterator.next());
                }
            }
        }

        public String[] getFreeArgs() {
            if (this.hasErrors()) {
                throw new IllegalStateException(this.errorsToString());
            }
            return this.m_freeArgs;
        }

        public IOptsParser.IOpt[] getOpts() {
            if (this.hasErrors()) {
                return null;
            }
            if (this.m_opts.isEmpty()) {
                return EMPTY_OPT_ARRAY;
            }
            IOptsParser.IOpt[] iOptArray = new IOptsParser.IOpt[this.m_opts.size()];
            this.m_opts.toArray(iOptArray);
            return iOptArray;
        }

        public IOptsParser.IOpt[] getOpts(String string) {
            if (this.hasErrors()) {
                return null;
            }
            List list = (List)this.m_patternMap.get(string);
            if (list == null || list.isEmpty()) {
                return EMPTY_OPT_ARRAY;
            }
            IOptsParser.IOpt[] iOptArray = new IOptsParser.IOpt[list.size()];
            list.toArray(iOptArray);
            return iOptArray;
        }

        public boolean hasArg(String string) {
            if (this.hasErrors()) {
                throw new IllegalStateException(this.errorsToString());
            }
            return this.m_nameMap.containsKey(string);
        }

        Opts() {
        }

        void addOpt(Opt opt, OptDef optDef, String string) {
            boolean bl;
            if (opt == null) {
                throw new IllegalArgumentException("null input: opt");
            }
            if (optDef == null) {
                throw new IllegalArgumentException("null input: optdef");
            }
            if (string == null) {
                throw new IllegalArgumentException("null input: occuranceName");
            }
            this.m_opts.add(opt);
            String[] stringArray = optDef.getNames();
            boolean bl2 = bl = opt.getPatternPrefix() != null;
            if (bl) {
                String string2 = string.substring(opt.getPatternPrefix().length());
                for (int i = 0; i < stringArray.length; ++i) {
                    this.m_nameMap.put(stringArray[i].concat(string2), opt);
                }
                String string3 = optDef.getCanonicalName();
                ArrayList<Opt> arrayList = (ArrayList<Opt>)this.m_patternMap.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<Opt>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.m_patternMap.put(stringArray[i], arrayList);
                    }
                }
                arrayList.add(opt);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.m_nameMap.put(stringArray[i], opt);
                }
            }
        }

        Opt getOpt(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: occuranceName");
            }
            return (Opt)this.m_nameMap.get(string);
        }

        void setFreeArgs(String[] stringArray, int n) {
            if (stringArray == null) {
                throw new IllegalArgumentException("null input: args");
            }
            if (n < 0 || n > stringArray.length) {
                throw new IllegalArgumentException("invalid start index: " + n);
            }
            this.m_freeArgs = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, this.m_freeArgs, 0, this.m_freeArgs.length);
        }

        void setUsageRequested(int n) {
            this.m_usageRequestLevel = n;
        }

        void addError(String string) {
            if (string != null) {
                if (this.m_errors == null) {
                    this.m_errors = new ArrayList();
                }
                this.m_errors.add(string);
            }
        }

        boolean hasErrors() {
            return this.m_errors != null && !this.m_errors.isEmpty();
        }

        String errorsToString() {
            if (!this.hasErrors()) {
                return "<no errors>";
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charArrayWriter);
            this.error(printWriter, 80);
            printWriter.flush();
            return charArrayWriter.toString();
        }
    }

    static final class Opt
    implements IOptsParser.IOpt {
        private final String m_name;
        private final String m_canonicalName;
        private final String m_patternPrefix;
        private ArrayList m_values;

        public String getName() {
            return this.m_name;
        }

        public String getCanonicalName() {
            return this.m_canonicalName;
        }

        public int getValueCount() {
            if (this.m_values == null) {
                return 0;
            }
            return this.m_values.size();
        }

        public String getFirstValue() {
            if (this.m_values == null) {
                return null;
            }
            return (String)this.m_values.get(0);
        }

        public String[] getValues() {
            if (this.m_values == null) {
                return IConstants.EMPTY_STRING_ARRAY;
            }
            String[] stringArray = new String[this.m_values.size()];
            this.m_values.toArray(stringArray);
            return stringArray;
        }

        public String getPatternPrefix() {
            return this.m_patternPrefix;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.m_name);
            if (!this.m_canonicalName.equals(this.m_name)) {
                stringBuffer.append(" [" + this.m_canonicalName + "]");
            }
            if (this.m_values != null) {
                stringBuffer.append(": ");
                stringBuffer.append(this.m_values);
            }
            return stringBuffer.toString();
        }

        Opt(String string, String string2, String string3) {
            this.m_name = string;
            this.m_canonicalName = string2;
            this.m_patternPrefix = string3;
        }

        void addValue(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: value");
            }
            if (this.m_values == null) {
                this.m_values = new ArrayList();
            }
            this.m_values.add(string);
        }
    }
}

