/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IConstants;
import java.io.Serializable;

public final class IntObjectMap
implements Serializable {
    private final float m_loadFactor;
    private Entry[] m_buckets;
    private int m_size;
    private int m_sizeThreshold;
    private static final String EOL = System.getProperty("line.separator", "\n");

    public IntObjectMap() {
        this(11, 0.75f);
    }

    public IntObjectMap(int n) {
        this(n, 0.75f);
    }

    public IntObjectMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("negative input: initialCapacity [" + n + "]");
        }
        if ((double)f <= 0.0 || (double)f >= 1.000001) {
            throw new IllegalArgumentException("loadFactor not in (0.0, 1.0] range: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.m_loadFactor = (double)f > 1.0 ? 1.0f : f;
        this.m_sizeThreshold = (int)((float)n * f);
        this.m_buckets = new Entry[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.debugDump(stringBuffer);
        return stringBuffer.toString();
    }

    public int size() {
        return this.m_size;
    }

    public boolean contains(int n) {
        Entry[] entryArray = this.m_buckets;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.m_key) {
                return true;
            }
            entry = entry.m_next;
        }
        return false;
    }

    public Object get(int n) {
        Entry[] entryArray = this.m_buckets;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.m_key) {
                return entry.m_value;
            }
            entry = entry.m_next;
        }
        return null;
    }

    public int[] keys() {
        if (this.m_size == 0) {
            return IConstants.EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[this.m_size];
        int n = 0;
        for (int i = 0; i < this.m_buckets.length; ++i) {
            Entry entry = this.m_buckets[i];
            while (entry != null) {
                nArray[n++] = entry.m_key;
                entry = entry.m_next;
            }
        }
        return nArray;
    }

    public Object put(int n, Object object) {
        Entry entry;
        Entry entry2 = null;
        int n2 = (n & Integer.MAX_VALUE) % this.m_buckets.length;
        Entry[] entryArray = this.m_buckets;
        Object object2 = entryArray[n2];
        while (object2 != null) {
            if (n == ((Entry)object2).m_key) {
                entry2 = object2;
                break;
            }
            object2 = ((Entry)object2).m_next;
        }
        if (entry2 != null) {
            object2 = entry2.m_value;
            entry2.m_value = object;
            return object2;
        }
        if (this.m_size >= this.m_sizeThreshold) {
            this.rehash();
        }
        entryArray = this.m_buckets;
        n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        object2 = entryArray[n2];
        entryArray[n2] = entry = new Entry(n, object, (Entry)object2);
        ++this.m_size;
        return null;
    }

    void debugDump(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            stringBuffer.append(super.toString());
            stringBuffer.append(EOL);
            stringBuffer.append("size = " + this.m_size + ", bucket table size = " + this.m_buckets.length + ", load factor = " + this.m_loadFactor + EOL);
            stringBuffer.append("size threshold = " + this.m_sizeThreshold + EOL);
        }
    }

    private void rehash() {
        Entry[] entryArray = this.m_buckets;
        int n = (this.m_buckets.length << 1) + 1;
        Entry[] entryArray2 = new Entry[n];
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2;
                Entry entry3 = entry.m_next;
                int n2 = entry.m_key;
                int n3 = (n2 & Integer.MAX_VALUE) % n;
                entry.m_next = entry2 = entryArray2[n3];
                entryArray2[n3] = entry;
                entry = entry3;
            }
        }
        this.m_sizeThreshold = (int)((float)n * this.m_loadFactor);
        this.m_buckets = entryArray2;
    }

    private static final class Entry
    implements Serializable {
        Object m_value;
        final int m_key;
        Entry m_next;

        Entry(int n, Object object, Entry entry) {
            this.m_key = n;
            this.m_value = object;
            this.m_next = entry;
        }
    }
}

