/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.rt.ClassPathCacheEntry;
import com.vladium.emma.rt.IClassLoadHook;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Map;

public final class InstrClassLoader
extends URLClassLoader {
    public static final String PROPERTY_FORCED_DELEGATION_FILTER = "clsload.forced_delegation_filter";
    public static final String PROPERTY_THROUGH_DELEGATION_FILTER = "clsload.through_delegation_filter";
    private final ClassLoader m_parent;
    private final IInclExclFilter m_forcedDelegationFilter;
    private final IInclExclFilter m_throughDelegationFilter;
    private final Map m_cache;
    private final IClassLoadHook m_hook;
    private final PoolEntry[] m_bufPool;
    private final Logger m_log;
    private int m_nestLevel;
    private int m_cacheHits;
    private int m_cacheMisses;
    private static final int BAOS_INIT_SIZE = 32768;
    private static final int BAOS_MAX_SIZE = 0x100000;
    private static final int BAOS_POOL_SIZE = 8;
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public InstrClassLoader(ClassLoader classLoader, File[] fileArray, IInclExclFilter iInclExclFilter, IInclExclFilter iInclExclFilter2, IClassLoadHook iClassLoadHook, Map map) throws MalformedURLException {
        super(InstrClassLoader.filesToURLs(fileArray), (ClassLoader)null);
        this.m_hook = iClassLoadHook;
        this.m_cache = map;
        this.m_forcedDelegationFilter = iInclExclFilter;
        this.m_throughDelegationFilter = iInclExclFilter2;
        this.m_parent = classLoader;
        this.m_bufPool = new PoolEntry[8];
        this.m_log = Logger.getLogger();
    }

    public final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        boolean bl2 = this.m_log.atTRACE1();
        if (bl2) {
            this.m_log.trace1("loadClass", "(" + string + ", " + bl + "): nest level " + this.m_nestLevel);
        }
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz == null) {
            Class<?> clazz2;
            block15: {
                clazz2 = null;
                if (this.m_parent != null) {
                    try {
                        clazz2 = this.m_parent.loadClass(string);
                        if (clazz2.getClassLoader() != this.m_parent || this.m_forcedDelegationFilter == null || this.m_forcedDelegationFilter.included(string)) {
                            clazz = clazz2;
                            if (bl2) {
                                this.m_log.trace1("loadClass", "using parent's version for [" + string + "]");
                            }
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (this.m_forcedDelegationFilter != null && !this.m_forcedDelegationFilter.included(string)) break block15;
                        throw classNotFoundException;
                    }
                }
            }
            if (clazz == null) {
                try {
                    clazz = this.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (clazz2 != null) {
                        boolean bl3;
                        boolean bl4 = bl3 = this.m_throughDelegationFilter == null || this.m_throughDelegationFilter.included(string);
                        if (bl3) {
                            clazz = clazz2;
                            if (bl2) {
                                this.m_log.trace1("loadClass", "[delegation filter] using parent's version for [" + string + "]");
                            }
                        }
                        throw classNotFoundException;
                    }
                    throw classNotFoundException;
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public final URL getResource(String string) {
        boolean bl = this.m_log.atTRACE1();
        if (bl) {
            this.m_log.trace1("getResource", "(" + string + "): nest level " + this.m_nestLevel);
        }
        URL uRL = super.getResource(string);
        if (bl && uRL != null) {
            this.m_log.trace1("loadClass", "[" + string + "] found in " + uRL);
        }
        return uRL;
    }

    protected final Class findClass(String string) throws ClassNotFoundException {
        boolean bl = this.m_log.atTRACE1();
        if (bl) {
            this.m_log.trace1("findClass", "(" + string + "): nest level " + this.m_nestLevel);
        }
        boolean bl2 = this.m_cache != null;
        ClassPathCacheEntry classPathCacheEntry = bl2 ? (ClassPathCacheEntry)this.m_cache.remove(string) : null;
        URL uRL = null;
        if (classPathCacheEntry != null) {
            ++this.m_cacheHits;
            try {
                uRL = new URL(classPathCacheEntry.m_srcURL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            PoolEntry poolEntry = null;
            try {
                poolEntry = this.acquirePoolEntry();
                ByteArrayOStream byteArrayOStream = poolEntry.m_baos;
                byte[] byArray = classPathCacheEntry.m_bytes;
                int n = byArray.length;
                if (this.m_hook != null && this.m_hook.processClassDef(string, byArray, n, byteArrayOStream)) {
                    byArray = byteArrayOStream.getByteArray();
                    n = byteArrayOStream.size();
                    if (bl) {
                        this.m_log.trace1("findClass", "defining [cached] instrumented [" + string + "] {" + n + " bytes }");
                    }
                } else if (bl) {
                    this.m_log.trace1("findClass", "defining [cached] [" + string + "] {" + n + " bytes }");
                }
                Class clazz = this.defineClass(string, byArray, n, uRL);
                return clazz;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string);
            }
            finally {
                if (poolEntry != null) {
                    this.releasePoolEntry(poolEntry);
                }
            }
        }
        if (bl2) {
            ++this.m_cacheMisses;
        }
        String string2 = string.replace('.', '/') + ".class";
        uRL = this.getResource(string2);
        if (bl && uRL != null) {
            this.m_log.trace1("findClass", "[" + string + "] found in " + uRL);
        }
        if (uRL == null) {
            throw new ClassNotFoundException(string);
        }
        InputStream inputStream = null;
        PoolEntry poolEntry = null;
        try {
            inputStream = uRL.openStream();
            poolEntry = this.acquirePoolEntry();
            ByteArrayOStream byteArrayOStream = poolEntry.m_baos;
            InstrClassLoader.readFully(inputStream, byteArrayOStream, poolEntry.m_buf);
            inputStream.close();
            inputStream = null;
            byte[] byArray = byteArrayOStream.getByteArray();
            int n = byteArrayOStream.size();
            byteArrayOStream.reset();
            if (this.m_hook != null && this.m_hook.processClassDef(string, byArray, n, byteArrayOStream)) {
                byArray = byteArrayOStream.getByteArray();
                n = byteArrayOStream.size();
                if (bl) {
                    this.m_log.trace1("findClass", "defining instrumented [" + string + "] {" + n + " bytes }");
                }
            } else if (bl) {
                this.m_log.trace1("findClass", "defining [" + string + "] {" + n + " bytes }");
            }
            Class clazz = this.defineClass(string, byArray, n, uRL);
            return clazz;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string);
        }
        finally {
            if (poolEntry != null) {
                this.releasePoolEntry(poolEntry);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void debugDump(PrintWriter printWriter) {
        if (printWriter != null) {
            printWriter.println(this + ": " + this.m_cacheHits + " class cache hits, " + this.m_cacheMisses + " misses");
        }
    }

    private Class defineClass(String string, byte[] byArray, int n, URL uRL) {
        String string2;
        Package package_;
        CodeSource codeSource = new CodeSource(uRL, (Certificate[])null);
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0 && (package_ = this.getPackage(string2 = string.substring(0, n2))) == null) {
            this.definePackage(string2, "EMMA", "0.0", "(C) Vladimir Roubtsov", "EMMA", "0.0", "(C) Vladimir Roubtsov", uRL);
        }
        return this.defineClass(string, byArray, 0, n, codeSource);
    }

    private static URL[] filesToURLs(File[] fileArray) throws MalformedURLException {
        if (fileArray == null || fileArray.length == 0) {
            return EMPTY_URL_ARRAY;
        }
        URL[] uRLArray = new URL[fileArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = fileArray[i].toURL();
        }
        return uRLArray;
    }

    private static void readFully(InputStream inputStream, ByteArrayOStream byteArrayOStream, byte[] byArray) throws IOException {
        int n;
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOStream.write(byArray, 0, n);
        }
    }

    private PoolEntry acquirePoolEntry() {
        PoolEntry poolEntry;
        if (this.m_nestLevel >= 8) {
            poolEntry = new PoolEntry(32768, 32768);
        } else {
            poolEntry = this.m_bufPool[this.m_nestLevel];
            if (poolEntry == null) {
                this.m_bufPool[this.m_nestLevel] = poolEntry = new PoolEntry(32768, 32768);
            } else {
                poolEntry.m_baos.reset();
            }
        }
        ++this.m_nestLevel;
        return poolEntry;
    }

    private void releasePoolEntry(PoolEntry poolEntry) {
        if (--this.m_nestLevel < 8) {
            poolEntry.trim(32768, 0x100000);
        }
    }

    private static final class PoolEntry {
        ByteArrayOStream m_baos;
        final byte[] m_buf;

        PoolEntry(int n, int n2) {
            this.m_baos = new ByteArrayOStream(n);
            this.m_buf = new byte[n2];
        }

        void trim(int n, int n2) {
            if (this.m_baos.capacity() > n2) {
                this.m_baos = new ByteArrayOStream(n);
            }
        }
    }
}

