/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;

@Beta
public class XmlReporter
extends Reporter {
    private final Writer mWriter;

    public XmlReporter(LintCliClient client, File output) throws IOException {
        super(client, output);
        this.mWriter = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
    }

    @Override
    public void write(int errorCount, int warningCount, List<Warning> issues) throws IOException {
        this.mWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.mWriter.write("<issues format=\"4\"");
        String revision = this.mClient.getRevision();
        if (revision != null) {
            this.mWriter.write(String.format(" by=\"lint %1$s\"", revision));
        }
        this.mWriter.write(">\n");
        if (!issues.isEmpty()) {
            for (Warning warning : issues) {
                int index2;
                String line;
                int index1;
                this.mWriter.write(10);
                XmlReporter.indent(this.mWriter, 1);
                this.mWriter.write("<issue");
                Issue issue = warning.issue;
                XmlReporter.writeAttribute(this.mWriter, 2, "id", issue.getId());
                XmlReporter.writeAttribute(this.mWriter, 2, "severity", warning.severity.getDescription());
                XmlReporter.writeAttribute(this.mWriter, 2, "message", warning.message);
                XmlReporter.writeAttribute(this.mWriter, 2, "category", issue.getCategory().getFullName());
                XmlReporter.writeAttribute(this.mWriter, 2, "priority", Integer.toString(issue.getPriority()));
                XmlReporter.writeAttribute(this.mWriter, 2, "summary", issue.getDescription(Issue.OutputFormat.RAW));
                XmlReporter.writeAttribute(this.mWriter, 2, "explanation", issue.getExplanation(Issue.OutputFormat.RAW));
                List<String> moreInfo = issue.getMoreInfo();
                if (!moreInfo.isEmpty()) {
                    XmlReporter.writeAttribute(this.mWriter, 2, "url", moreInfo.get(0));
                    if (issue.getMoreInfo() != null) {
                        XmlReporter.writeAttribute(this.mWriter, 2, "urls", Joiner.on((char)',').join(issue.getMoreInfo()));
                    }
                }
                if (warning.errorLine != null && !warning.errorLine.isEmpty() && (index1 = (line = warning.errorLine).indexOf(10)) != -1 && (index2 = line.indexOf(10, index1 + 1)) != -1) {
                    String line1 = line.substring(0, index1);
                    String line2 = line.substring(index1 + 1, index2);
                    XmlReporter.writeAttribute(this.mWriter, 2, "errorLine1", line1);
                    XmlReporter.writeAttribute(this.mWriter, 2, "errorLine2", line2);
                }
                if (this.mClient.getRegistry() instanceof BuiltinIssueRegistry && ((BuiltinIssueRegistry)this.mClient.getRegistry()).hasAutoFix("adt", issue)) {
                    XmlReporter.writeAttribute(this.mWriter, 2, "quickfix", "adt");
                }
                assert (warning.file != null == (warning.location != null));
                if (warning.file != null) assert (warning.location.getFile() == warning.file);
                Location location = warning.location;
                if (location != null) {
                    this.mWriter.write(">\n");
                    while (location != null) {
                        XmlReporter.indent(this.mWriter, 2);
                        this.mWriter.write("<location");
                        String path = this.mClient.getDisplayPath(warning.project, location.getFile());
                        XmlReporter.writeAttribute(this.mWriter, 3, "file", path);
                        Position start = location.getStart();
                        if (start != null) {
                            int line2 = start.getLine();
                            int column = start.getColumn();
                            if (line2 >= 0) {
                                XmlReporter.writeAttribute(this.mWriter, 3, "line", Integer.toString(line2 + 1));
                                if (column >= 0) {
                                    XmlReporter.writeAttribute(this.mWriter, 3, "column", Integer.toString(column + 1));
                                }
                            }
                        }
                        this.mWriter.write("/>\n");
                        location = location.getSecondary();
                    }
                    XmlReporter.indent(this.mWriter, 1);
                    this.mWriter.write("</issue>\n");
                    continue;
                }
                this.mWriter.write(10);
                XmlReporter.indent(this.mWriter, 1);
                this.mWriter.write("/>\n");
            }
        }
        this.mWriter.write("\n</issues>\n");
        this.mWriter.close();
        String path = this.mOutput.getAbsolutePath();
        System.out.println(String.format("Wrote XML report to %1$s", path));
    }

    private static void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
        writer.write(10);
        XmlReporter.indent(writer, indent);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        int n = value.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    writer.write("&quot;");
                    continue block6;
                }
                case '\'': {
                    writer.write("&apos;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
        writer.write(34);
    }

    private static void indent(Writer writer, int indent) throws IOException {
        for (int level = 0; level < indent; ++level) {
            writer.write("    ");
        }
    }
}

