/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintCliXmlParser;
import com.android.tools.lint.LombokParser;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.IDomParser;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@Beta
public class LintCliClient
extends LintClient {
    protected final List<Warning> mWarnings = new ArrayList<Warning>();
    protected boolean mHasErrors;
    protected int mErrorCount;
    protected int mWarningCount;
    protected IssueRegistry mRegistry;
    protected LintDriver mDriver;
    protected final LintCliFlags mFlags;
    private final Map<File, String> mFileContents = new HashMap<File, String>(100);
    private Map<Project, LintClient.ClassPathInfo> mProjectInfo;

    public LintCliClient() {
        this.mFlags = new LintCliFlags();
        TextReporter reporter = new TextReporter(this, new PrintWriter(System.out, true), false);
        this.mFlags.getReporters().add(reporter);
    }

    public LintCliClient(LintCliFlags flags) {
        this.mFlags = flags;
    }

    public int run(IssueRegistry registry, List<File> files) throws IOException {
        assert (!this.mFlags.getReporters().isEmpty());
        this.mRegistry = registry;
        this.mDriver = new LintDriver(registry, this);
        this.mDriver.setAbbreviating(!this.mFlags.isShowEverything());
        if (!this.mFlags.isQuiet()) {
            this.mDriver.addLintListener(new ProgressPrinter());
        }
        this.mDriver.analyze(new LintRequest(this, files));
        Collections.sort(this.mWarnings);
        for (Reporter reporter : this.mFlags.getReporters()) {
            reporter.write(this.mErrorCount, this.mWarningCount, this.mWarnings);
        }
        return this.mFlags.isSetExitCode() ? (this.mHasErrors ? -1 : 0) : 0;
    }

    @Override
    public void log(@NonNull Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
        System.out.flush();
        if (!this.mFlags.isQuiet()) {
            System.err.println();
        }
        if (format != null) {
            System.err.println(String.format(format, args));
        }
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    @Override
    public IDomParser getDomParser() {
        return new LintCliXmlParser();
    }

    @Override
    public Configuration getConfiguration(@NonNull Project project) {
        return new CliConfiguration(this.mFlags.getDefaultConfiguration(), project);
    }

    private String getContents(File file) {
        String s = this.mFileContents.get(file);
        if (s == null) {
            s = this.readFile(file);
            this.mFileContents.put(file, s);
        }
        return s;
    }

    @Override
    public IJavaParser getJavaParser() {
        return new LombokParser();
    }

    @Override
    public void report(@NonNull Context context, @NonNull Issue issue, @NonNull Severity severity, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        assert (context.isEnabled(issue) || issue == IssueRegistry.LINT_ERROR);
        if (severity == Severity.IGNORE) {
            return;
        }
        if (severity == Severity.ERROR || severity == Severity.FATAL) {
            this.mHasErrors = true;
            ++this.mErrorCount;
        } else {
            ++this.mWarningCount;
        }
        Warning warning = new Warning(issue, message, severity, context.getProject(), data);
        this.mWarnings.add(warning);
        if (location != null) {
            Position startPosition;
            warning.location = location;
            File file = location.getFile();
            if (file != null) {
                warning.file = file;
                warning.path = this.getDisplayPath(context.getProject(), file);
            }
            if ((startPosition = location.getStart()) != null) {
                int line;
                warning.line = line = startPosition.getLine();
                warning.offset = startPosition.getOffset();
                if (line >= 0) {
                    if (context.file == location.getFile()) {
                        warning.fileContents = context.getContents();
                    }
                    if (warning.fileContents == null) {
                        warning.fileContents = this.getContents(location.getFile());
                    }
                    if (this.mFlags.isShowSourceLines()) {
                        warning.errorLine = LintCliClient.getLine(warning.fileContents, line);
                        if (warning.errorLine != null) {
                            warning.errorLine = warning.errorLine.replace('\t', ' ');
                            int column = startPosition.getColumn();
                            if (column < 0) {
                                column = 0;
                                int i = 0;
                                while (i < warning.errorLine.length() && Character.isWhitespace(warning.errorLine.charAt(i))) {
                                    ++i;
                                    ++column;
                                }
                            }
                            StringBuilder sb = new StringBuilder(100);
                            sb.append(warning.errorLine);
                            sb.append('\n');
                            for (int i = 0; i < column; ++i) {
                                sb.append(' ');
                            }
                            boolean displayCaret = true;
                            Position endPosition = location.getEnd();
                            if (endPosition != null) {
                                int endLine = endPosition.getLine();
                                int endColumn = endPosition.getColumn();
                                if (endLine == line && endColumn > column) {
                                    for (int i = column; i < endColumn; ++i) {
                                        sb.append('~');
                                    }
                                    displayCaret = false;
                                }
                            }
                            if (displayCaret) {
                                sb.append('^');
                            }
                            sb.append('\n');
                            warning.errorLine = sb.toString();
                        }
                    }
                }
            }
        }
    }

    static String getLine(String contents, int line) {
        int index = LintCliClient.getLineOffset(contents, line);
        if (index != -1) {
            return LintCliClient.getLineOfOffset(contents, index);
        }
        return null;
    }

    static String getLineOfOffset(String contents, int offset) {
        int end = contents.indexOf(10, offset);
        if (end == -1) {
            end = contents.indexOf(13, offset);
        }
        return contents.substring(offset, end != -1 ? end : contents.length());
    }

    static int getLineOffset(String contents, int line) {
        int index = 0;
        for (int i = 0; i < line; ++i) {
            if ((index = contents.indexOf(10, index)) == -1) {
                return -1;
            }
            ++index;
        }
        return index;
    }

    @Override
    @NonNull
    public String readFile(@NonNull File file) {
        try {
            return LintUtils.getEncodedString(this, file);
        }
        catch (IOException e) {
            return "";
        }
    }

    boolean isCheckingSpecificIssues() {
        return this.mFlags.getExactCheckedIds() != null;
    }

    @Override
    @NonNull
    protected LintClient.ClassPathInfo getClassPath(@NonNull Project project) {
        LintClient.ClassPathInfo info;
        LintClient.ClassPathInfo classPath = super.getClassPath(project);
        List<File> sources = this.mFlags.getSourcesOverride();
        List<File> classes = this.mFlags.getClassesOverride();
        List<File> libraries = this.mFlags.getLibrariesOverride();
        if (classes == null && sources == null && libraries == null) {
            return classPath;
        }
        if (this.mProjectInfo == null) {
            this.mProjectInfo = Maps.newHashMap();
            info = null;
        } else {
            info = this.mProjectInfo.get(project);
        }
        if (info == null) {
            if (sources == null) {
                sources = classPath.getSourceFolders();
            }
            if (classes == null) {
                classes = classPath.getClassFolders();
            }
            if (libraries == null) {
                libraries = classPath.getLibraries();
            }
            info = new LintClient.ClassPathInfo(sources, classes, libraries);
            this.mProjectInfo.put(project, info);
        }
        return info;
    }

    @Override
    @NonNull
    public List<File> getResourceFolders(@NonNull Project project) {
        List<File> resources = this.mFlags.getResourcesOverride();
        if (resources == null) {
            return super.getResourceFolders(project);
        }
        return resources;
    }

    @NonNull
    static String getCleanPath(@NonNull File file) {
        String path = file.getPath();
        StringBuilder sb = new StringBuilder(path.length());
        if (path.startsWith(File.separator)) {
            sb.append(File.separator);
        }
        block0: for (String element : Splitter.on((char)File.separatorChar).omitEmptyStrings().split((CharSequence)path)) {
            if (element.equals(".")) continue;
            if (element.equals("..") && sb.length() > 0) {
                for (int i = sb.length() - 1; i >= 0; --i) {
                    char c = sb.charAt(i);
                    if (c != File.separatorChar) continue;
                    sb.setLength(i == 0 ? 1 : i);
                    continue block0;
                }
                sb.setLength(0);
                continue;
            }
            if (sb.length() > 1) {
                sb.append(File.separatorChar);
            } else if (sb.length() > 0 && sb.charAt(0) != File.separatorChar) {
                sb.append(File.separatorChar);
            }
            sb.append(element);
        }
        if (path.endsWith(File.separator) && sb.length() > 0 && sb.charAt(sb.length() - 1) != File.separatorChar) {
            sb.append(File.separator);
        }
        return sb.toString();
    }

    String getDisplayPath(Project project, File file) {
        String path = file.getPath();
        if (!this.mFlags.isFullPath() && path.startsWith(project.getReferenceDir().getPath())) {
            int chop = project.getReferenceDir().getPath().length();
            if (path.length() > chop && path.charAt(chop) == File.separatorChar) {
                ++chop;
            }
            if ((path = path.substring(chop)).isEmpty()) {
                path = file.getName();
            }
        } else if (this.mFlags.isFullPath()) {
            path = LintCliClient.getCleanPath(file.getAbsoluteFile());
        }
        return path;
    }

    boolean isAllEnabled() {
        return this.mFlags.isCheckAllWarnings();
    }

    IssueRegistry getRegistry() {
        return this.mRegistry;
    }

    LintDriver getDriver() {
        return this.mDriver;
    }

    Configuration getConfiguration() {
        return this.mFlags.getDefaultConfiguration();
    }

    boolean isSuppressed(Issue issue) {
        return this.mFlags.getSuppressedIds().contains(issue.getId());
    }

    public Configuration createConfigurationFromFile(File file) {
        return new CliConfiguration(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    String getRevision() {
        File file = this.findResource("tools" + File.separator + "source.properties");
        if (file != null && file.exists()) {
            FileInputStream input;
            block5: {
                String string;
                input = null;
                try {
                    input = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(input);
                    String revision = properties.getProperty("Pkg.Revision");
                    if (revision == null || revision.isEmpty()) break block5;
                    string = revision;
                }
                catch (IOException iOException) {
                    Closeables.closeQuietly((Closeable)input);
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(input);
                        throw throwable;
                    }
                }
                Closeables.closeQuietly((Closeable)input);
                return string;
            }
            Closeables.closeQuietly((Closeable)input);
        }
        return null;
    }

    private static class ProgressPrinter
    implements LintListener {
        private ProgressPrinter() {
        }

        @Override
        public void update(@NonNull LintDriver lint, @NonNull LintListener.EventType type, @Nullable Context context) {
            switch (type) {
                case SCANNING_PROJECT: {
                    String name;
                    String string = name = context != null ? context.getProject().getName() : "?";
                    if (lint.getPhase() > 1) {
                        System.out.print(String.format("\nScanning %1$s (Phase %2$d): ", name, lint.getPhase()));
                        break;
                    }
                    System.out.print(String.format("\nScanning %1$s: ", name));
                    break;
                }
                case SCANNING_LIBRARY_PROJECT: {
                    String name = context != null ? context.getProject().getName() : "?";
                    System.out.print(String.format("\n         - %1$s: ", name));
                    break;
                }
                case SCANNING_FILE: {
                    System.out.print('.');
                    break;
                }
                case NEW_PHASE: {
                    break;
                }
                case CANCELED: 
                case COMPLETED: {
                    System.out.println();
                    break;
                }
            }
        }
    }

    class CliConfiguration
    extends DefaultConfiguration {
        CliConfiguration(@NonNull Configuration parent, Project project) {
            super(LintCliClient.this, project, parent);
        }

        CliConfiguration(File lintFile) {
            super(LintCliClient.this, null, null, lintFile);
        }

        @Override
        @NonNull
        public Severity getSeverity(@NonNull Issue issue) {
            Severity severity = this.computeSeverity(issue);
            if (LintCliClient.this.mFlags.isWarningsAsErrors() && severity != Severity.IGNORE) {
                severity = Severity.ERROR;
            }
            if (LintCliClient.this.mFlags.isIgnoreWarnings() && severity == Severity.WARNING) {
                severity = Severity.IGNORE;
            }
            return severity;
        }

        @Override
        @NonNull
        protected Severity getDefaultSeverity(@NonNull Issue issue) {
            if (LintCliClient.this.mFlags.isCheckAllWarnings()) {
                return issue.getDefaultSeverity();
            }
            return super.getDefaultSeverity(issue);
        }

        private Severity computeSeverity(@NonNull Issue issue) {
            Severity severity = super.getSeverity(issue);
            String id = issue.getId();
            Set<String> suppress = LintCliClient.this.mFlags.getSuppressedIds();
            if (suppress.contains(id)) {
                return Severity.IGNORE;
            }
            Set<String> enabled = LintCliClient.this.mFlags.getEnabledIds();
            Set<String> check = LintCliClient.this.mFlags.getExactCheckedIds();
            if (enabled.contains(id) || check != null && check.contains(id)) {
                if (severity == Severity.IGNORE && (severity = issue.getDefaultSeverity()) == Severity.IGNORE) {
                    severity = Severity.WARNING;
                }
                return severity;
            }
            if (check != null && issue != IssueRegistry.LINT_ERROR && issue != IssueRegistry.PARSER_ERROR) {
                return Severity.IGNORE;
            }
            return severity;
        }
    }
}

