/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.matchers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import lombok.ast.libs.org.parboiled.Action;
import lombok.ast.libs.org.parboiled.Context;
import lombok.ast.libs.org.parboiled.ContextAware;
import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.Rule;
import lombok.ast.libs.org.parboiled.errors.ActionError;
import lombok.ast.libs.org.parboiled.errors.ActionException;
import lombok.ast.libs.org.parboiled.errors.GrammarException;
import lombok.ast.libs.org.parboiled.matchers.AbstractMatcher;
import lombok.ast.libs.org.parboiled.matchers.MatcherVisitor;
import lombok.ast.libs.org.parboiled.transform.BaseAction;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMatcher<V>
extends AbstractMatcher<V> {
    public final Action<V> action;
    public final List<ContextAware<V>> contextAwares;
    public final boolean skipInPredicates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMatcher(@NotNull Action<V> action) {
        if (action == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.ActionMatcher.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this.contextAwares = new ArrayList<ContextAware<V>>();
        this.action = action;
        if (action instanceof BaseAction) {
            this.skipInPredicates = ((BaseAction)action).skipInPredicates();
            return;
        }
        this.skipInPredicates = false;
        if (action instanceof ContextAware) {
            this.contextAwares.add((ContextAware)((Object)action));
        }
        for (Field field : action.getClass().getDeclaredFields()) {
            if (!field.isSynthetic() || !ContextAware.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                ContextAware contextAware = (ContextAware)field.get(action);
                if (contextAware == null) continue;
                this.contextAwares.add(contextAware);
            }
            catch (IllegalAccessException e) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    @Override
    public MatcherContext<V> getSubContext(MatcherContext<V> context) {
        MatcherContext<V> subContext = context.getBasicSubContext();
        subContext.setMatcher(this);
        return subContext.getCurrentIndex() > 0 ? subContext : context.getSubContext(this);
    }

    @Override
    public boolean match(@NotNull MatcherContext<V> context) {
        if (context == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.ActionMatcher.match(...) corresponds to @NotNull parameter and must not be null");
        }
        if (this.skipInPredicates && context.inPredicate()) {
            return true;
        }
        Context parentContext = context.getParent();
        if (!this.contextAwares.isEmpty()) {
            for (ContextAware<V> contextAware : this.contextAwares) {
                contextAware.setContext(parentContext);
            }
        }
        try {
            if (!this.action.run(parentContext)) {
                return false;
            }
            context.setCurrentIndex(((MatcherContext)parentContext).getCurrentIndex());
            return true;
        }
        catch (ActionException e) {
            context.getParseErrors().add(new ActionError<V>(context.getInputBuffer(), context.getCurrentIndex(), e.getMessage(), context.getPath(), e));
            return false;
        }
    }

    @Override
    public Rule suppressNode() {
        throw new GrammarException("Actions cannot be marked with @SuppressNode or @SuppressSubnodes");
    }

    @Override
    public <R> R accept(@NotNull MatcherVisitor<V, R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.ActionMatcher.accept(...) corresponds to @NotNull parameter and must not be null");
        }
        return visitor.visit(this);
    }
}

