# [devil.android.sdk.adb_wrapper](https://chromium.googlesource.com/catapult.git/+/HEAD/devil/devil/android/sdk/adb_wrapper.py)

*This page was autogenerated. Run `devil/bin/generate_md_docs` to update*

## AdbWrapper

A wrapper around a local Android Debug Bridge executable.
### AdbWrapper.Backup

Write an archive of the device's data to |path|.
```
    Args:
      path: Local path to store the backup file.
      packages: List of to packages to be backed up.
      apk: (optional) If set include the .apk files in the archive.
      shared: (optional) If set buckup the device's SD card.
      nosystem: (optional) If set exclude system applications.
      include_all: (optional) If set back up all installed applications and
        |packages| is optional.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.DisableVerity

Disable Marshmallow's Verity security feature.
```
    Returns:
      The output of the disable-verity command as a string.
```


### AdbWrapper.Emu

Runs an emulator console command.
```
    See http://developer.android.com/tools/devices/emulator.html#console

    Args:
      cmd: The command to run on the emulator console.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.

    Returns:
      The output of the emulator console command.
```


### AdbWrapper.EnableVerity

Enable Marshmallow's Verity security feature.
```
    Returns:
      The output of the enable-verity command as a string.
```


### AdbWrapper.Forward

Forward socket connections from the local socket to the remote socket.
```
    Sockets are specified by one of:
      tcp:<port>
      localabstract:<unix domain socket name>
      localreserved:<unix domain socket name>
      localfilesystem:<unix domain socket name>
      dev:<character device name>
      jdwp:<process pid> (remote only)

    Args:
      local: The host socket.
      remote: The device socket.
      allow_rebind: A boolean indicating whether adb may rebind a local socket;
        otherwise, the default, an exception is raised if the local socket is
        already being forwarded.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.ForwardList

List all currently forwarded socket connections.
```
    Args:
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
    Returns:
      The output of adb forward --list as a string.
```


### AdbWrapper.ForwardRemove

Remove a forward socket connection.
```
    Args:
      local: The host socket.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.GetDevPath

Gets the device path.
```
    Args:
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.

    Returns:
      The device path (e.g. usb:3-4)
```


### AdbWrapper.GetDeviceSerial

Gets the device serial number associated with this object.
```
    Returns:
      Device serial number as a string.
```


### AdbWrapper.GetState

Get device state.
```
    Args:
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.

    Returns:
      One of 'offline', 'bootloader', or 'device'.
```


### AdbWrapper.Install

Install an apk on the device.
```
    Args:
      apk_path: Host path to the APK file.
      forward_lock: (optional) If set forward-locks the app.
      allow_downgrade: (optional) If set, allows for downgrades.
      reinstall: (optional) If set reinstalls the app, keeping its data.
      sd_card: (optional) If set installs on the SD card.
      streaming: (optional) If not set, use default way to install.
        If True, performs streaming install.
        If False, app is pushed to device and be installed from there.
        Note this option is not supported prior to adb version 1.0.40
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.InstallMultiple

Install an apk with splits on the device.
```
    Args:
      apk_paths: Host path to the APK file.
      forward_lock: (optional) If set forward-locks the app.
      reinstall: (optional) If set reinstalls the app, keeping its data.
      sd_card: (optional) If set installs on the SD card.
      allow_downgrade: (optional) Allow versionCode downgrade.
      partial: (optional) Package ID if apk_paths doesn't include all .apks.
      streaming: (optional) If not set, use default way to install.
        If True, performs streaming install.
        If False, app is pushed to device and be installed from there.
        Note this option is not supported prior to adb version 1.0.40
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.IterShell

Runs a shell command and returns an iterator over its output lines.
```
    Args:
      command: A string with the shell command to run.
      timeout: Timeout in seconds.

    Yields:
      The output of the command line by line.
```


### AdbWrapper.JDWP

List of PIDs of processes hosting a JDWP transport.
```
    Args:
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.

    Returns:
      A list of PIDs as strings.
```


### AdbWrapper.Logcat

Get an iterable over the logcat output.
```
    Args:
      clear: If true, clear the logcat.
      dump: If true, dump the current logcat contents.
      filter_specs: If set, a list of specs to filter the logcat.
      logcat_format: If set, the format in which the logcat should be output.
        Options include "brief", "process", "tag", "thread", "raw", "time",
        "threadtime", and "long"
      ring_buffer: If set, a list of alternate ring buffers to request.
        Options include "main", "system", "radio", "events", "crash" or "all".
        The default is equivalent to ["main", "system", "crash"].
      iter_timeout: If set and neither clear nor dump is set, the number of
        seconds to wait between iterations. If no line is found before the
        given number of seconds elapses, the iterable will yield None.
      check_error: Whether to check the exit status of the logcat command.
      timeout: (optional) If set, timeout per try in seconds. If clear or dump
        is set, defaults to DEFAULT_TIMEOUT.
      retries: (optional) If clear or dump is set, the number of retries to
        attempt. Otherwise, does nothing.

    Yields:
      logcat output line by line.
```


### AdbWrapper.Ls

List the contents of a directory on the device.
```
    Args:
      path: Path on the device filesystem.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.

    Returns:
      A list of pairs (filename, stat) for each file found in the directory,
      where the stat object has the properties: st_mode, st_size, and st_time.

    Raises:
      AdbCommandFailedError if |path| does not specify a valid and accessible
          directory in the device, or the output of "adb ls" command is less
          than four columns
```


### AdbWrapper.Pull

Pulls a file from the device to the host.
```
    Args:
      remote: Path on the device filesystem.
      local: Path on the host filesystem.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.Push

Pushes a file from the host to the device.
```
    Args:
      local: Path on the host filesystem.
      remote: Path on the device filesystem.
      sync: (optional) Whether to only push files that are newer on the host.
        Not supported when using adb prior to 1.0.39.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.

    Raises:
      AdbVersionError if sync=True with versions of adb prior to 1.0.39.
```


### AdbWrapper.Reboot

Reboots the device.
```
    Args:
      to_bootloader: (optional) If set reboots to the bootloader.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.Remount

Remounts the /system partition on the device read-write.
### AdbWrapper.Restore

Restore device contents from the backup archive.
```
    Args:
      path: Host path to the backup archive.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.Root

Restarts the adbd daemon with root permissions, if possible.
```
    Args:
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.Shell

Runs a shell command on the device.
```
    Args:
      command: A string with the shell command to run.
      expect_status: (optional) Check that the command's exit status matches
        this value. Default is 0. If set to None the test is skipped.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.

    Returns:
      The output of the shell command as a string.

    Raises:
      device_errors.AdbCommandFailedError: If the exit status doesn't match
        |expect_status|.
```


### AdbWrapper.StartShell

Starts a subprocess on the device and returns a handle to the process.
```
    Args:
      args: A sequence of program arguments. The executable to run is the first
        item in the sequence.

    Returns:
      An instance of subprocess.Popen associated with the live process.
```


### AdbWrapper.Uninstall

Remove the app |package| from the device.
```
    Args:
      package: The package to uninstall.
      keep_data: (optional) If set keep the data and cache directories.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.WaitForDevice

Block until the device is online.
```
    Args:
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### AdbWrapper.\_\_eq\_\_

Consider instances equal if they refer to the same device.
```
    Args:
      other: The instance to compare equality with.

    Returns:
      True if the instances are considered equal, false otherwise.
```


### AdbWrapper.\_\_init\_\_

Initializes the AdbWrapper.
```
    Args:
      device_serial: The device serial number as a string.
```


### AdbWrapper.\_\_repr\_\_

### AdbWrapper.\_\_str\_\_

The string representation of an instance.
```
    Returns:
      The device serial number as a string.
```


## DeviceStat

DeviceStat(st\_mode, st\_size, st\_time)
### DeviceStat.\_\_getnewargs\_\_

Return self as a plain tuple.  Used by copy and pickle.
### DeviceStat.\_\_getstate\_\_

Exclude the OrderedDict from pickling
### DeviceStat.\_\_repr\_\_

Return a nicely formatted representation string
### VerifyLocalFileExists

Verifies a local file exists.
```
  Args:
    path: Path to the local file.

  Raises:
    IOError: If the file doesn't exist.
```


