/*
 * Decompiled with CFR 0.152.
 */
package com.android.fastdeploy;

import com.android.fastdeploy.APKEntry;
import com.android.fastdeploy.APKMetaData;
import com.android.fastdeploy.PatchFormatException;
import com.android.tools.build.apkzlib.zip.CentralDirectoryHeader;
import com.android.tools.build.apkzlib.zip.CentralDirectoryHeaderCompressInfo;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.StoredEntryType;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

class PatchUtils {
    private static final long NEGATIVE_MASK = Long.MIN_VALUE;
    private static final long NEGATIVE_LONG_SIGN_MASK = Long.MIN_VALUE;
    public static final String SIGNATURE = "HAMADI/IHD";

    PatchUtils() {
    }

    private static long getOffsetFromEntry(StoredEntry entry) {
        return entry.getCentralDirectoryHeader().getOffset() + (long)entry.getLocalHeaderSize();
    }

    public static APKMetaData getAPKMetaData(File apkFile) throws IOException {
        APKMetaData.Builder apkEntriesBuilder = APKMetaData.newBuilder();
        ZFileOptions options = new ZFileOptions();
        ZFile zFile = new ZFile(apkFile, options);
        ArrayList<StoredEntry> metaDataEntries = new ArrayList<StoredEntry>();
        for (StoredEntry entry : zFile.entries()) {
            if (entry.getType() != StoredEntryType.FILE) continue;
            metaDataEntries.add(entry);
        }
        Collections.sort(metaDataEntries, new Comparator<StoredEntry>(){

            private long getOffsetFromEntry(StoredEntry entry) {
                return PatchUtils.getOffsetFromEntry(entry);
            }

            @Override
            public int compare(StoredEntry lhs, StoredEntry rhs) {
                return Long.compare(this.getOffsetFromEntry(lhs), this.getOffsetFromEntry(rhs));
            }
        });
        for (StoredEntry entry : metaDataEntries) {
            CentralDirectoryHeader cdh = entry.getCentralDirectoryHeader();
            CentralDirectoryHeaderCompressInfo cdhci = cdh.getCompressionInfoWithWait();
            APKEntry.Builder entryBuilder = APKEntry.newBuilder();
            entryBuilder.setCrc32(cdh.getCrc32());
            entryBuilder.setFileName(cdh.getName());
            entryBuilder.setCompressedSize(cdhci.getCompressedSize());
            entryBuilder.setUncompressedSize(cdh.getUncompressedSize());
            entryBuilder.setDataOffset(PatchUtils.getOffsetFromEntry(entry));
            apkEntriesBuilder.addEntries(entryBuilder);
            apkEntriesBuilder.build();
        }
        return apkEntriesBuilder.build();
    }

    static void writeFormattedLong(long value, OutputStream outputStream) throws IOException {
        long y = value;
        if (y < 0L) {
            y = -y | Long.MIN_VALUE;
        }
        for (int i = 0; i < 8; ++i) {
            outputStream.write((byte)(y & 0xFFL));
            y >>>= 8;
        }
    }

    static long readFormattedLong(InputStream inputStream) throws IOException {
        long result = 0L;
        for (int bitshift = 0; bitshift < 64; bitshift += 8) {
            result |= (long)inputStream.read() << bitshift;
        }
        if (result - Long.MIN_VALUE > 0L) {
            result = (result & Long.MAX_VALUE) * -1L;
        }
        return result;
    }

    static final long readBsdiffLong(InputStream in) throws PatchFormatException, IOException {
        long result = 0L;
        for (int bitshift = 0; bitshift < 64; bitshift += 8) {
            result |= (long)in.read() << bitshift;
        }
        if (result == Long.MIN_VALUE) {
            throw new PatchFormatException("read negative zero");
        }
        if ((result & Long.MIN_VALUE) != 0L) {
            result = -(result & Long.MAX_VALUE);
        }
        return result;
    }

    static void readFully(InputStream in, byte[] destination, int startAt, int numBytes) throws IOException {
        int readNow;
        for (int numRead = 0; numRead < numBytes; numRead += readNow) {
            readNow = in.read(destination, startAt + numRead, numBytes - numRead);
            if (readNow != -1) continue;
            throw new IOException("truncated input stream");
        }
    }

    static void pipe(InputStream in, OutputStream out, byte[] buffer, long copyLength) throws IOException {
        while (copyLength > 0L) {
            int maxCopy = Math.min(buffer.length, (int)copyLength);
            PatchUtils.readFully(in, buffer, 0, maxCopy);
            out.write(buffer, 0, maxCopy);
            copyLength -= (long)maxCopy;
        }
    }

    static void pipe(RandomAccessFile in, OutputStream out, byte[] buffer, long copyLength) throws IOException {
        while (copyLength > 0L) {
            int maxCopy = Math.min(buffer.length, (int)copyLength);
            in.readFully(buffer, 0, maxCopy);
            out.write(buffer, 0, maxCopy);
            copyLength -= (long)maxCopy;
        }
    }

    static void fill(byte value, OutputStream out, byte[] buffer, long fillLength) throws IOException {
        while (fillLength > 0L) {
            int maxCopy = Math.min(buffer.length, (int)fillLength);
            Arrays.fill(buffer, 0, maxCopy, value);
            out.write(buffer, 0, maxCopy);
            fillLength -= (long)maxCopy;
        }
    }
}

