//
//  AppController.m
//  X-MasTree
//
//  Created by John Schilling on 11/8/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "AppController.h"
#define TIMER_ANIMATION_SECOND_FAST     0.60
#define TIMER_ANIMATION_SECOND_SLOW     1.00
#define TIMER_IDLE_SECONDS              5.00

static AppController	*sharedInstance = nil;

@implementation AppController

#pragma mark
#pragma mark PRIVATE INSTANCE METHODS
#pragma mark

- (id)init
{
    if (sharedInstance) {
	NSLog(@"Attempt to allocate more than one Controller object!");
	return nil;
    } else {
	[super init];
	sharedInstance = self;
    }
    
    srandom(time(0));
    
    _tree = nil;
    _currentTimerSeconds = 0.0;
    
    return sharedInstance;
}

+ (AppController *)sharedInstance 
{
    return sharedInstance ? sharedInstance : [[self alloc] init];
}

- (void)awakeFromNib
{
    [self loadPreferences];
    [self setupSettingsPanel];
    int i = [self daysUntilChristmas];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    [self initTreeWithSize: _treeSize color:_treeColor];
    [self startTimerWithSeconds:(float)TIMER_IDLE_SECONDS];
    [self checkTimerAndUpdateTree];
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
    [self stopTimer];
    [NSApp setApplicationIconImage: [NSImage imageNamed:@"NSApplicationIcon"]]; 
    [self releaseTree];
    [self savePreferences];
}

- (void)applicationDidHide:(NSNotification *)aNotification
{
    /* NOP */
}

- (void)dealloc
{
    [super dealloc];
}







#pragma mark
#pragma mark PREFERENCE READING/WRITING METHODS
#pragma mark

- (void)loadPreferences
{
    [[NSUserDefaults standardUserDefaults] registerDefaults:[NSDictionary dictionaryWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"defaults" ofType:@"plist"]]];
    
    _treeSize               = [[NSUserDefaults standardUserDefaults] integerForKey:@"_treeSize"];
    _treeColor              = [[NSUserDefaults standardUserDefaults] integerForKey:@"_treeColor"];
    _windowLevel            = [[NSUserDefaults standardUserDefaults] integerForKey:@"_windowLevel"];
    _hasShadow              = [[NSUserDefaults standardUserDefaults] integerForKey:@"_hasShadow"];
    _drawRedLights          = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawRedLights"];
    _drawGreenLights        = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawGreenLights"];
    _drawBlueLights         = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawBlueLights"];
    _drawPurpleLights       = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawPurpleLights"];
    _lightsRedDensity       = [[NSUserDefaults standardUserDefaults] integerForKey:@"_lightsRedDensity"];
    _lightsGreenDensity     = [[NSUserDefaults standardUserDefaults] integerForKey:@"_lightsGreenDensity"];
    _lightsBlueDensity      = [[NSUserDefaults standardUserDefaults] integerForKey:@"_lightsBlueDensity"];
    _lightsPurpleDensity    = [[NSUserDefaults standardUserDefaults] integerForKey:@"_lightsPurpleDensity"];
    _lightsRedMode          = [[NSUserDefaults standardUserDefaults] integerForKey:@"_lightsRedMode"];
    _lightsGreenMode        = [[NSUserDefaults standardUserDefaults] integerForKey:@"_lightsGreenMode"];
    _lightsBlueMode         = [[NSUserDefaults standardUserDefaults] integerForKey:@"_lightsBlueMode"];
    _lightsPurpleMode       = [[NSUserDefaults standardUserDefaults] integerForKey:@"_lightsPurpleMode"];
    _useOldStyleLights      = [[NSUserDefaults standardUserDefaults] integerForKey:@"_useOldStyleLights"];
    _drawStar               = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawStar"];
    _starStyle              = [[NSUserDefaults standardUserDefaults] integerForKey:@"_starStyle"];
    _drawRedOrnaments       = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawRedOrnaments"];
    _drawGreenOrnaments     = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawGreenOrnaments"];
    _drawBlueOrnaments      = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawBlueOrnaments"];
    _drawPurpleOrnaments    = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawPurpleOrnaments"];
    _drawTinsel             = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawTinsel"];
    _drawPopcorn            = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawPopcorn"];
    _drawPresents           = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawPresents"];
    _incrementPresents      = [[NSUserDefaults standardUserDefaults] integerForKey:@"_incrementPresents"];
    _drawCustomObjects      = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawCustomObjects"];
    _drawBadge              = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawBadge"];
    _dateOfXmas             = [[NSUserDefaults standardUserDefaults] integerForKey:@"_dateOfXmas"];
    _drawDockIcon           = [[NSUserDefaults standardUserDefaults] integerForKey:@"_drawDockIcon"];
    _fastAnimation          = [[NSUserDefaults standardUserDefaults] integerForKey:@"_fastAnimation"];
}

- (void)savePreferences
{
    [[NSUserDefaults standardUserDefaults] setInteger:_treeSize forKey:@"_treeSize"];
    [[NSUserDefaults standardUserDefaults] setInteger:_treeColor forKey:@"_treeColor"];
    [[NSUserDefaults standardUserDefaults] setInteger:_windowLevel forKey:@"_windowLevel"];
    [[NSUserDefaults standardUserDefaults] setInteger:_hasShadow forKey:@"_hasShadow"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawRedLights forKey:@"_drawRedLights"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawGreenLights forKey:@"_drawGreenLights"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawBlueLights forKey:@"_drawBlueLights"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawPurpleLights forKey:@"_drawPurpleLights"];
    [[NSUserDefaults standardUserDefaults] setInteger:_lightsRedDensity forKey:@"_lightsRedDensity"];
    [[NSUserDefaults standardUserDefaults] setInteger:_lightsGreenDensity forKey:@"_lightsGreenDensity"];
    [[NSUserDefaults standardUserDefaults] setInteger:_lightsBlueDensity forKey:@"_lightsBlueDensity"];
    [[NSUserDefaults standardUserDefaults] setInteger:_lightsPurpleDensity forKey:@"_lightsPurpleDensity"];
    [[NSUserDefaults standardUserDefaults] setInteger:_lightsRedMode forKey:@"_lightsRedMode"];
    [[NSUserDefaults standardUserDefaults] setInteger:_lightsGreenMode forKey:@"_lightsGreenMode"];
    [[NSUserDefaults standardUserDefaults] setInteger:_lightsBlueMode forKey:@"_lightsBlueMode"];
    [[NSUserDefaults standardUserDefaults] setInteger:_lightsPurpleMode forKey:@"_lightsPurpleMode"];
    [[NSUserDefaults standardUserDefaults] setInteger:_useOldStyleLights forKey:@"_useOldStyleLights"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawStar forKey:@"_drawStar"];
    [[NSUserDefaults standardUserDefaults] setInteger:_starStyle forKey:@"_starStyle"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawRedOrnaments forKey:@"_drawRedOrnaments"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawGreenOrnaments forKey:@"_drawGreenOrnaments"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawBlueOrnaments forKey:@"_drawBlueOrnaments"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawPurpleOrnaments forKey:@"_drawPurpleOrnaments"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawPopcorn forKey:@"_drawPopcorn"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawTinsel forKey:@"_drawTinsel"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawPresents forKey:@"_drawPresents"];
    [[NSUserDefaults standardUserDefaults] setInteger:_incrementPresents forKey:@"_incrementPresents"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawBadge forKey:@"_drawBadge"];
    [[NSUserDefaults standardUserDefaults] setInteger:_dateOfXmas forKey:@"_dateOfXmas"];
    [[NSUserDefaults standardUserDefaults] setInteger:_drawDockIcon forKey:@"_drawDockIcon"];
    [[NSUserDefaults standardUserDefaults] setInteger:_fastAnimation forKey:@"_fastAnimation"];
    
    [[NSUserDefaults standardUserDefaults] synchronize];
    
    // NOTE: _drawCustomObjects is set by command line only. It is an unsupported feature this year.
}







#pragma mark
#pragma mark TREE CREATION/DESTRUCTION METHODS
#pragma mark

- (void)initTreeWithSize:(int)treeSize color:(int)treeColor;
{
    _tree = [[[Tree allocWithZone:[self zone]]
                    initNewTreeWithSize: _treeSize 
                                  color: _treeColor 
                             withShadow: _hasShadow 
                            windowLevel: _windowLevel] retain];
}

- (void)releaseTree
{
    [_tree saveTreeFrame];
    [[_tree treeWindow] close];
    [_tree release];
    _tree = nil;
}








#pragma mark
#pragma mark ACCESS TO STATE VARIABLES
#pragma mark

- (int)treeSize
{
    return _treeSize;
}

- (int)treeColor
{
    return _treeColor;
}

- (int)drawRedLights
{
    if (!_drawRedLights) return -1;
    return _lightsRedDensity;
}

- (int)drawGreenLights
{
    if (!_drawGreenLights) return -1;
    return _lightsGreenDensity;
}

- (int)drawBlueLights
{
    if (!_drawBlueLights) return -1;
    return _lightsBlueDensity;
}

- (int)drawPurpleLights
{
    if (!_drawPurpleLights) return -1;
    return _lightsPurpleDensity;
}

- (int)lightsRedMode
{
    return _lightsRedMode;
}

- (int)lightsGreenMode
{
    return _lightsGreenMode;
}

- (int)lightsBlueMode
{
    return _lightsBlueMode;
}

- (int)lightsPurpleMode
{
    return _lightsPurpleMode;
}

- (BOOL)useOldStyleLights
{
    return _useOldStyleLights;
}

- (BOOL)drawRedOrnaments
{
    return _drawRedOrnaments;
}

- (BOOL)drawGreenOrnaments
{
    return _drawGreenOrnaments;
}

- (BOOL)drawBlueOrnaments
{
    return _drawBlueOrnaments;
}

- (BOOL)drawPurpleOrnaments
{
    return _drawPurpleOrnaments;
}

- (BOOL)drawTinsel
{
    return _drawTinsel;
}

- (BOOL)drawPopcorn
{
    return _drawPopcorn;
}

- (int)drawStar
{
    if (!_drawStar) return -1;
    return _starStyle;
}

- (int)drawPresents
{
    if (!_drawPresents) return -1;
    return _incrementPresents;
}

- (BOOL)drawCustomObjects
{
    return _drawCustomObjects;
}

- (BOOL)drawBadger
{
    return _drawBadge;
}

- (BOOL)drawDockIcon
{
    return _drawDockIcon;
}




#pragma mark
#pragma mark USER INTERFACE SETTINGS METHODS
#pragma mark

- (void)setupSettingsPanel
{
    [_treeSizeList selectItemAtIndex:_treeSize];
    [_treeColorList selectItemAtIndex:_treeColor];
    [_windowLevelList selectItemAtIndex:_windowLevel];
    [_hasShadowButton setState:(_hasShadow ? NSOnState : NSOffState)];
    
    [_drawLightsRedButton setState:(_drawRedLights ? NSOnState : NSOffState)];
    [_drawLightsRedMatrix setEnabled:(_drawRedLights ? YES : NO)];
    [_lightsRedModeMatrix setEnabled:(_drawRedLights ? YES : NO)];
    [_drawLightsGreenButton setState:(_drawGreenLights ? NSOnState : NSOffState)];
    [_drawLightsGreenMatrix setEnabled:(_drawGreenLights ? YES : NO)];
    [_lightsGreenModeMatrix setEnabled:(_drawGreenLights ? YES : NO)];
    [_drawLightsBlueButton setState:(_drawBlueLights ? NSOnState : NSOffState)];
    [_drawLightsBlueMatrix setEnabled:(_drawBlueLights ? YES : NO)];
    [_lightsBlueModeMatrix setEnabled:(_drawBlueLights ? YES : NO)];
    [_drawLightsPurpleButton setState:(_drawPurpleLights ? NSOnState : NSOffState)];
    [_drawLightsPurpleMatrix setEnabled:(_drawPurpleLights ? YES : NO)];
    [_lightsPurpleModeMatrix setEnabled:(_drawPurpleLights ? YES : NO)];
    
    [_drawStarButton setState:(_drawStar ? NSOnState : NSOffState)];
    [_drawStarMatrix setEnabled:(_drawStar ? YES : NO)];
    [_drawRedOrnamentsButton setState:(_drawRedOrnaments ? NSOnState : NSOffState)];
    [_drawGreenOrnamentsButton setState:(_drawGreenOrnaments ? NSOnState : NSOffState)];
    [_drawBlueOrnamentsButton setState:(_drawBlueOrnaments ? NSOnState : NSOffState)];
    [_drawPurpleOrnamentsButton setState:(_drawPurpleOrnaments ? NSOnState : NSOffState)];
    [_drawTinselButton setState:(_drawTinsel ? NSOnState : NSOffState)];
    [_drawPopcornButton setState:(_drawPopcorn ? NSOnState : NSOffState)];
    [_drawPresentsButton setState:(_drawPresents ? NSOnState : NSOffState)];
    [_incrementPresentsButton setEnabled:(_drawPresents ? YES : NO)];
    [_incrementPresentsButton setState:(_incrementPresents ? NSOnState : NSOffState)];
    [_drawBadgeButton setState:(_drawBadge ? NSOnState : NSOffState)];
    [_xmasDateList selectItemAtIndex:_dateOfXmas];
    [_xmasDateList setEnabled:_drawBadge];
    [_drawDockIconButton setState:(_drawDockIcon ? NSOnState : NSOffState)];
    
    [_drawLightsRedMatrix deselectAllCells];
    [_drawLightsRedMatrix selectCellWithTag:_lightsRedDensity];
    [_drawLightsGreenMatrix deselectAllCells];
    [_drawLightsGreenMatrix selectCellWithTag:_lightsGreenDensity];
    [_drawLightsBlueMatrix deselectAllCells];
    [_drawLightsBlueMatrix selectCellWithTag:_lightsBlueDensity];
    [_drawLightsPurpleMatrix deselectAllCells];
    [_drawLightsPurpleMatrix selectCellWithTag:_lightsPurpleDensity];
    
    [_lightsRedModeMatrix deselectAllCells];
    [_lightsRedModeMatrix selectCellWithTag:_lightsRedMode];
    [_lightsGreenModeMatrix deselectAllCells];
    [_lightsGreenModeMatrix selectCellWithTag:_lightsGreenMode];
    [_lightsBlueModeMatrix deselectAllCells];
    [_lightsBlueModeMatrix selectCellWithTag:_lightsBlueMode];
    [_lightsPurpleModeMatrix deselectAllCells];
    [_lightsPurpleModeMatrix selectCellWithTag:_lightsPurpleMode];
    
    [_useOldStyleLightsButton setState:(_useOldStyleLights ? NSOnState : NSOffState)];
    
    [_drawStarMatrix deselectAllCells];
    [_drawStarMatrix selectCellWithTag:_starStyle];
    
    [_fastAnimationButton setState:(_fastAnimation ? NSOnState : NSOffState)];
}

- (IBAction)openSettingsPanel:(id)sender
{
    [_settingsPanel center];
    [_settingsPanel makeKeyAndOrderFront:self];
}

- (IBAction)userSetTreeSize:(id)sender
{
    _treeSize = [[sender selectedItem] tag];
    [_tree updateTreeForSize:_treeSize treeColor:_treeColor];
    [_tree resetShadow];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetTreeColor:(id)sender
{
    _treeColor = [[sender selectedItem] tag];
    [_tree updateTreeForSize:_treeSize treeColor:_treeColor];
    [_tree resetShadow];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetWindowLevel:(id)sender
{
    _windowLevel = [[sender selectedItem] tag];
    [_tree setWindowLevel:_windowLevel];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetHasShadow:(id)sender
{
    _hasShadow = [sender state];
    [_tree setHasShadow:_hasShadow];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawLightsRed:(id)sender
{
    _drawRedLights = [sender state];
    [_drawLightsRedMatrix setEnabled:[sender state]];
    [_lightsRedModeMatrix setEnabled:[sender state]];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawLightsGreen:(id)sender
{
    _drawGreenLights = [sender state];
    [_drawLightsGreenMatrix setEnabled:[sender state]];
    [_lightsGreenModeMatrix setEnabled:[sender state]];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawLightsBlue:(id)sender
{
    _drawBlueLights = [sender state];
    [_drawLightsBlueMatrix setEnabled:[sender state]];
    [_lightsBlueModeMatrix setEnabled:[sender state]];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawLightsPurple:(id)sender
{
    _drawPurpleLights = [sender state];
    [_drawLightsPurpleMatrix setEnabled:[sender state]];
    [_lightsPurpleModeMatrix setEnabled:[sender state]];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetRedLightsDensity:(id)sender
{
    _lightsRedDensity = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetGreenLightsDensity:(id)sender
{
    _lightsGreenDensity = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetBlueLightsDensity:(id)sender
{
    _lightsBlueDensity = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetPurpleLightsDensity:(id)sender
{
    _lightsPurpleDensity = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetRedLightMode:(id)sender
{
    _lightsRedMode = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetGreenLightMode:(id)sender
{
    _lightsGreenMode = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetBlueLightMode:(id)sender
{
    _lightsBlueMode = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetPurpleLightMode:(id)sender
{
    _lightsPurpleMode = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetUseOldStyleLights:(id)sender
{
    _useOldStyleLights = [sender state];
    [self checkTimerAndUpdateTree];
}


- (IBAction)userSetDrawStar:(id)sender
{
    _drawStar = [sender state];
    [_drawStarMatrix setEnabled:[sender state]];
    [_tree resetShadow];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawStyle:(id)sender
{
    _starStyle = [[sender selectedCell] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawRedOrnaments:(id)sender
{
    _drawRedOrnaments = [sender state];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawGreenOrnaments:(id)sender
{
    _drawGreenOrnaments = [sender state];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawBlueOrnaments:(id)sender
{
    _drawBlueOrnaments = [sender state];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawPurpleOrnaments:(id)sender
{
    _drawPurpleOrnaments = [sender state];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawTinsel:(id)sender
{
    _drawTinsel = [sender state];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawPopcorn:(id)sender
{
    _drawPopcorn = [sender state];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawPresents:(id)sender
{
    _drawPresents = [sender state];
    [_incrementPresentsButton setEnabled:[sender state]];
    [_tree resetShadow];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetIncrementPresents:(id)sender
{
    _incrementPresents = [sender state];
    [_tree resetShadow];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawBadge:(id)sender
{
    _drawBadge = [sender state];
    [_xmasDateList setEnabled:_drawBadge];
    [_tree resetShadow];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetXmasDate:(id)sender
{
    _dateOfXmas = [[sender selectedItem] tag];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetDrawDockIcon:(id)sender
{
    _drawDockIcon = [sender state];
    if (!_drawDockIcon) [NSApp setApplicationIconImage: [NSImage imageNamed:@"NSApplicationIcon"]];
    [self checkTimerAndUpdateTree];
}

- (IBAction)userSetUseFastAnimation:(id)sender
{
    _fastAnimation = [sender state];
    [self checkTimerAndUpdateTree];
}




#pragma mark
#pragma mark TIMER ANIMATION METHODS
#pragma mark

// There are far too many variables to check to see if we really need to draw a new tree or not.
// It's far easier, and easier to follow, if I just draw the damn tree constantly. The only thing
// I am doing is checking to see if we need to animate the tree. If not, I'm sttepping down the
// timer to 5 seconds. I still need the timer to draw the tree every once and a while for when the
// date changes for the badger.

- (void)checkTimerAndUpdateTree
{
    if ((!_drawRedLights || _lightsRedMode == 0) && 
        (!_drawGreenLights || _lightsGreenMode == 0) && 
        (!_drawBlueLights || _lightsBlueMode == 0) && 
        (!_drawPurpleLights || _lightsPurpleMode == 0) && 
        (!_drawStar || _starStyle != 2))
    {
        [_tree drawTree];
        if (_currentTimerSeconds != (float)TIMER_IDLE_SECONDS) [self startTimerWithSeconds:(float)TIMER_IDLE_SECONDS];
    } else {
        [_tree drawTree];
        if (!_fastAnimation && (_currentTimerSeconds != (float)TIMER_ANIMATION_SECOND_SLOW)) [self startTimerWithSeconds:(float)TIMER_ANIMATION_SECOND_SLOW];
        if (_fastAnimation && (_currentTimerSeconds != (float)TIMER_ANIMATION_SECOND_FAST)) [self startTimerWithSeconds:(float)TIMER_ANIMATION_SECOND_FAST];
    }
}


- (void)startTimerWithSeconds:(float)seconds
{
    _currentTimerSeconds = seconds;
    
    [self stopTimer];
    
    _timer = [[NSTimer scheduledTimerWithTimeInterval:seconds
                                                target:self 
                                                selector:@selector(animate:) 
                                                userInfo:nil 
                                                repeats:YES] retain];
}

- (void)stopTimer
{
    if (_timer) [_timer invalidate];
    if (_timer) [_timer release];
    _timer = nil;
}

- (void)animate:(NSTimer *)timer
{
    [_tree drawTree];
}






#pragma mark
#pragma mark DATE METHODS
#pragma mark

- (int)daysUntilChristmas
{
    int xday, xmonth;
    
    if (_dateOfXmas == 0)
    {
        xday = 25;
        xmonth = 12;
    } else if (_dateOfXmas == 1) {
        xday = 24;
        xmonth = 12;
    } else if (_dateOfXmas == 2) {
        xday = 7;
        xmonth = 1;
    }

    NSCalendarDate *xmas = [NSCalendarDate dateWithYear:[[NSCalendarDate calendarDate] yearOfCommonEra]
                                                        month:xmonth day:xday hour:0 minute:0 second:0 timeZone:nil];
    NSCalendarDate *today = [NSCalendarDate calendarDate];
    
    int tdd = [today dayOfCommonEra];
    int xdd = [xmas dayOfCommonEra];
    int dif = xdd - tdd;
    if (dif < 0) {
        NSCalendarDate *nxmas = [NSCalendarDate dateWithYear:([[NSCalendarDate calendarDate] yearOfCommonEra] + 1)
                                                        month:xmonth day:xday hour:0 minute:0 second:0 timeZone:nil];
        int nxm = [nxmas dayOfCommonEra];
        dif = nxm - tdd;
    }
    return dif;
}

@end
