/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.util.Span;

public class SentenceSample {
    private final String document;
    private final List<Span> sentences;

    public SentenceSample(String document, Span ... sentences) {
        this.document = document;
        this.sentences = Collections.unmodifiableList(new ArrayList<Span>(Arrays.asList(sentences)));
    }

    public SentenceSample(Detokenizer detokenizer, String[][] sentences) {
        ArrayList<Span> spans = new ArrayList<Span>(sentences.length);
        StringBuilder documentBuilder = new StringBuilder();
        for (String[] sentenceTokens : sentences) {
            String sampleSentence = detokenizer.detokenize(sentenceTokens, null);
            int beginIndex = documentBuilder.length();
            documentBuilder.append(sampleSentence);
            spans.add(new Span(beginIndex, documentBuilder.length()));
        }
        this.document = documentBuilder.toString();
        this.sentences = Collections.unmodifiableList(spans);
    }

    public String getDocument() {
        return this.document;
    }

    public Span[] getSentences() {
        return this.sentences.toArray(new Span[this.sentences.size()]);
    }

    public String toString() {
        StringBuilder documentBuilder = new StringBuilder();
        for (Span sentSpan : this.sentences) {
            documentBuilder.append(sentSpan.getCoveredText(this.document).toString().replace("\r", "<CR>").replace("\n", "<LF>"));
            documentBuilder.append("\n");
        }
        return documentBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SentenceSample) {
            SentenceSample a = (SentenceSample)obj;
            return this.getDocument().equals(a.getDocument()) && Arrays.equals(this.getSentences(), a.getSentences());
        }
        return false;
    }
}

