/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgLockUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnSetLock;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgSetLock
extends SvnNgOperationRunner<SVNLock, SvnSetLock>
implements ISVNLockHandler {
    @Override
    protected SVNLock run(SVNWCContext context) throws SVNException {
        String lockMessage = ((SvnSetLock)this.getOperation()).getLockMessage();
        if (lockMessage != null && !SVNEncodingUtil.isXMLSafe(lockMessage)) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.XML_UNESCAPABLE_DATA, "Lock comment contains illegal characters");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        final SVNHashMap entriesMap = new SVNHashMap();
        SVNHashMap pathsRevisionsMap = new SVNHashMap();
        SvnNgRepositoryAccess repositoryAccess = this.getRepositoryAccess();
        SVNURL topURL = SvnNgLockUtil.collectLockInfo(this, this.getWcContext(), repositoryAccess, ((SvnSetLock)this.getOperation()).getTargets(), entriesMap, pathsRevisionsMap, true, ((SvnSetLock)this.getOperation()).isStealLock());
        SVNRepository repository = this.getRepositoryAccess().createRepository(topURL, null, true);
        final SVNURL rootURL = repository.getRepositoryRoot(true);
        repository.lock(pathsRevisionsMap, ((SvnSetLock)this.getOperation()).getLockMessage(), ((SvnSetLock)this.getOperation()).isStealLock(), new ISVNLockHandler(){

            @Override
            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                SVNURL fullURL = rootURL.appendPath(path, false);
                SvnNgLockUtil.LockInfo lockInfo = (SvnNgLockUtil.LockInfo)entriesMap.get(fullURL);
                if (error == null) {
                    ISVNWCDb.SVNWCDbLock dbLock = new ISVNWCDb.SVNWCDbLock();
                    dbLock.token = lock.getID();
                    dbLock.owner = lock.getOwner();
                    dbLock.comment = lock.getComment();
                    dbLock.date = SVNDate.fromDate(lock.getCreationDate());
                    SvnNgSetLock.this.getWcContext().getDb().addLock(lockInfo.getFile(), dbLock);
                    if (SvnNgSetLock.this.getWcContext().getProperty(lockInfo.getFile(), "svn:needs-lock") != null) {
                        SVNFileUtil.setReadonly(lockInfo.getFile(), false);
                    }
                    SvnNgSetLock.this.handleEvent(SVNEventFactory.createLockEvent(lockInfo.getFile(), SVNEventAction.LOCKED, lock, null), -1.0);
                } else {
                    SvnNgSetLock.this.handleEvent(SVNEventFactory.createLockEvent(lockInfo.getFile(), SVNEventAction.LOCK_FAILED, lock, error), -1.0);
                }
            }

            @Override
            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) {
            }
        });
        return (SVNLock)((SvnSetLock)this.getOperation()).first();
    }

    @Override
    public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
        if (error != null) {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.LOCK_FAILED, lock, error), -1.0);
        } else {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.LOCKED, lock, null), -1.0);
        }
    }

    @Override
    public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
    }
}

