/**
KeyboardEvent objects describe a user interaction with the keyboard; each event describes a single interaction between the user and a key (or combination of a key with modifier keys) on the keyboard.

@returns {KeyboardEvent}
*/
KeyboardEvent = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.altKey = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.charCode = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
KeyboardEvent.prototype.code = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.ctrlKey = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.isComposing = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
KeyboardEvent.prototype.key = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.keyCode = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.location = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.metaKey = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.repeat = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.shiftKey = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} keyArg
@returns {Boolean}
**/
KeyboardEvent.prototype.getModifierState = function(keyArg) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} typeArg
@param {Boolean} [bubblesArg]
@param {Boolean} [cancelableArg]
@param {(Window | null)} [viewArg] Window | null
@param {String} [keyArg]
@param {Number} [locationArg]
@param {Boolean} [ctrlKey]
@param {Boolean} [altKey]
@param {Boolean} [shiftKey]
@param {Boolean} [metaKey]
@returns {undefined}
**/
KeyboardEvent.prototype.initKeyboardEvent = function(typeArg) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.DOM_KEY_LOCATION_LEFT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.DOM_KEY_LOCATION_NUMPAD = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.DOM_KEY_LOCATION_RIGHT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.DOM_KEY_LOCATION_STANDARD = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.detail = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Window | null)} Window | null
**/
KeyboardEvent.prototype.view = new Window();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.which = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} typeArg
@param {Boolean} [bubblesArg]
@param {Boolean} [cancelableArg]
@param {(Window | null)} [viewArg] Window | null
@param {Number} [detailArg]
@returns {undefined}
**/
KeyboardEvent.prototype.initUIEvent = function(typeArg) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.bubbles = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.cancelBubble = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.cancelable = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.composed = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(EventTarget | null)} EventTarget | null
**/
KeyboardEvent.prototype.currentTarget = new EventTarget();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.defaultPrevented = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.eventPhase = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.isTrusted = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
KeyboardEvent.prototype.returnValue = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(EventTarget | null)} EventTarget | null
**/
KeyboardEvent.prototype.srcElement = new EventTarget();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(EventTarget | null)} EventTarget | null
**/
KeyboardEvent.prototype.target = new EventTarget();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} DOMHighResTimeStamp
**/
KeyboardEvent.prototype.timeStamp = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
KeyboardEvent.prototype.type = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the invocation target objects of event's path (objects on which listeners will be invoked), except for any nodes in shadow trees of which the shadow root's mode is "closed" that are not reachable from event's currentTarget.

@returns {EventTarget[]}
**/
KeyboardEvent.prototype.composedPath = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {Boolean} [bubbles]
@param {Boolean} [cancelable]
@returns {undefined}
**/
KeyboardEvent.prototype.initEvent = function(type) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
If invoked when the cancelable attribute value is true, and while executing a listener for the event with passive set to false, signals to the operation that caused event to be dispatched that it needs to be canceled.

@returns {undefined}
**/
KeyboardEvent.prototype.preventDefault = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Invoking this method prevents event from reaching any registered event listeners after the current one finishes running and, when dispatched in a tree, also prevents event from reaching any other objects.

@returns {undefined}
**/
KeyboardEvent.prototype.stopImmediatePropagation = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
When dispatched in a tree, invoking this method prevents event from reaching any objects other than the current object.

@returns {undefined}
**/
KeyboardEvent.prototype.stopPropagation = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.AT_TARGET = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.BUBBLING_PHASE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.CAPTURING_PHASE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
KeyboardEvent.prototype.NONE = new Number();

