/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.backend.smo.internal;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import org.apache.maven.search.backend.smo.SmoSearchTransport;

public class Java11HttpClientSmoSearchTransport
implements SmoSearchTransport {
    private final HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();

    @Override
    public String fetch(String serviceUri, Map<String, String> headers) throws IOException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(serviceUri)).GET();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        HttpRequest request = builder.build();
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return response.body();
            }
            throw new IOException("Unexpected response: " + response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }
}

