/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedReference<V>
implements Delayed {
    private final V data;
    private final long resumeTimeInMilliseconds;

    private DelayedReference(V data, long resumeTimeInMilliseconds) {
        this.data = data;
        this.resumeTimeInMilliseconds = resumeTimeInMilliseconds;
    }

    public DelayedReference(V data, long delay, TimeUnit timeUnit) {
        this(data, timeUnit.toMillis(delay) + System.currentTimeMillis());
    }

    public V getValue() {
        return this.data;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.resumeTimeInMilliseconds - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        long thatDelay;
        long thisDelay = this.resumeTimeInMilliseconds - System.currentTimeMillis();
        return thisDelay < (thatDelay = other.getDelay(TimeUnit.MILLISECONDS)) ? -1 : (thisDelay == thatDelay ? 0 : 1);
    }

    public DelayedReference<V> updateData(V data) {
        return new DelayedReference<V>(data, this.resumeTimeInMilliseconds);
    }

    public DelayedReference<V> updateDelay(long newDelay, TimeUnit timeUnit) {
        return new DelayedReference<V>(this.data, timeUnit.toMillis(newDelay) + System.currentTimeMillis());
    }
}

