/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropAccessor;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Collections;
import java.util.Iterator;

@ExportLibrary(value=NodeLibrary.class, receiverType=Node.class)
final class LegacyNodeExports {
    LegacyNodeExports() {
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static boolean hasScope(Node node, Frame frame) {
        Iterator<Scope> scopes = LegacyNodeExports.findLocalScopes(node, frame).iterator();
        if (!scopes.hasNext()) {
            return false;
        }
        return InteropAccessor.ACCESSOR.engineSupport().legacyScopesHasScope(node, scopes);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object getScope(Node node, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
        Iterator<Scope> scopes = LegacyNodeExports.findLocalScopes(node, frame).iterator();
        if (!scopes.hasNext()) {
            throw UnsupportedMessageException.create();
        }
        TruffleLanguage.Env env = LegacyNodeExports.findEnv(node);
        TruffleLanguage<?> spi = InteropAccessor.ACCESSOR.languageSupport().getLanguage(env);
        Object scope = InteropAccessor.ACCESSOR.engineSupport().legacyScopes2ScopeObject(node, scopes, spi.getClass());
        if (scope == null) {
            throw UnsupportedMessageException.create();
        }
        return scope;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static boolean hasReceiverMember(Node node, Frame frame) {
        Iterable<Scope> scopes = LegacyNodeExports.findLocalScopes(node, frame);
        for (Scope scope : scopes) {
            String name = scope.getReceiverName();
            if (name == null) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static String getReceiverMember(Node node, Frame frame) throws UnsupportedMessageException {
        Iterable<Scope> scopes = LegacyNodeExports.findLocalScopes(node, frame);
        for (Scope scope : scopes) {
            String name = scope.getReceiverName();
            if (name == null) continue;
            return name;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static boolean hasRootInstance(Node node, Frame frame) {
        Iterable<Scope> scopes = LegacyNodeExports.findLocalScopes(node, frame);
        for (Scope scope : scopes) {
            Object instance = scope.getRootInstance();
            if (instance == null) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object getRootInstance(Node node, Frame frame) throws UnsupportedMessageException {
        Iterable<Scope> scopes = LegacyNodeExports.findLocalScopes(node, frame);
        for (Scope scope : scopes) {
            Object instance = scope.getRootInstance();
            if (instance == null) continue;
            return instance;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object getView(Node node, Frame frame, Object value) {
        TruffleLanguage.Env env = LegacyNodeExports.findEnv(node);
        if (env == null) {
            return value;
        }
        return InteropAccessor.ACCESSOR.languageSupport().getLegacyScopedView(env, node, frame, value);
    }

    private static Iterable<Scope> findLocalScopes(Node node, Frame frame) {
        CompilerAsserts.neverPartOfCompilation();
        TruffleLanguage.Env env = LegacyNodeExports.findEnv(node);
        if (env == null) {
            return Collections.emptyList();
        }
        return InteropAccessor.ACCESSOR.languageSupport().findLegacyLocalScopes(env, node, frame);
    }

    private static TruffleLanguage.Env findEnv(Node node) {
        CompilerAsserts.neverPartOfCompilation();
        RootNode root = node.getRootNode();
        if (root == null || root.getLanguageInfo() == null) {
            return null;
        }
        return InteropAccessor.ACCESSOR.engineSupport().getEnvForInstrument(root.getLanguageInfo());
    }

    static int findScopeCount(Iterable<Scope> scopes) {
        Iterator<Scope> it = scopes.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    static Scope findScope(Iterable<Scope> scopes, int scopeNumber) {
        Iterator<Scope> it = scopes.iterator();
        int count = 0;
        while (it.hasNext()) {
            Scope scope = it.next();
            if (count == scopeNumber) {
                return scope;
            }
            ++count;
        }
        throw new AssertionError((Object)("wrong scope number: " + scopeNumber));
    }
}

