/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.api.CssStylesTC;
import org.netbeans.modules.css.visual.spi.CssStylesListener;
import org.netbeans.modules.css.visual.spi.CssStylesPanelProvider;
import org.netbeans.modules.css.visual.spi.RuleHandle;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.inspect.PageInspectorImpl;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.ui.Bundle;
import org.netbeans.modules.web.inspect.ui.Utilities;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class CssStylesPanelProviderImpl
extends JPanel
implements CssStylesPanelProvider {
    private JLabel noStylesLabel;
    private FileObject lastRelatedFOB;
    private PageModel currentPageModel;
    private FileObject inspectedFOB;
    private JPanel runFilePanel;
    private JButton runButton;
    private final MatchedRulesLookup lookup = new MatchedRulesLookup();
    private boolean active = true;
    private static final RequestProcessor RP = new RequestProcessor(CssStylesPanelProviderImpl.class);

    public CssStylesPanelProviderImpl() {
        this.setLayout(new BorderLayout());
        this.initNoStylesLabel();
        this.initRunFilePanel();
        this.add((Component)this.noStylesLabel, "Center");
        PageInspectorImpl.getDefault().addPropertyChangeListener(this.createInspectorListener());
        this.update(PageInspectorImpl.getDefault().getPage());
    }

    Lookup getMatchedRulesLookup() {
        return this.lookup;
    }

    private void initNoStylesLabel() {
        this.noStylesLabel = new JLabel();
        this.noStylesLabel.setText(NbBundle.getMessage(CssStylesPanelProviderImpl.class, (String)"CssStylesPanelProviderImpl.noStylesLabel"));
        this.noStylesLabel.setHorizontalAlignment(0);
        this.noStylesLabel.setVerticalAlignment(0);
        this.noStylesLabel.setEnabled(false);
        this.noStylesLabel.setBackground(UIManager.getColor("Tree.background"));
        this.noStylesLabel.setOpaque(true);
    }

    private void initRunFilePanel() {
        this.runFilePanel = new JPanel();
        JLabel label = new JLabel(NbBundle.getMessage(CssStylesPanelProviderImpl.class, (String)"CssStylesPanelProviderImpl.runFileLabel"));
        label.setHorizontalAlignment(0);
        this.runButton = new JButton();
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Lookup context;
                ActionProvider provider;
                FileObject lastRelatedFileObject = CssStylesPanelProviderImpl.this.getLastRelatedFileObject();
                if (lastRelatedFileObject != null && (provider = CssStylesPanelProviderImpl.actionProviderForFileObject(lastRelatedFileObject)) != null && provider.isActionEnabled("run.single", context = CssStylesPanelProviderImpl.contextForFileObject(lastRelatedFileObject))) {
                    provider.invokeAction("run.single", context);
                }
            }
        });
        GroupLayout layout = new GroupLayout(this.runFilePanel);
        this.runFilePanel.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.runButton).addContainerGap(-1, Short.MAX_VALUE));
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(label, -1, -1, Short.MAX_VALUE).addComponent(this.runButton)).addContainerGap());
    }

    void update(FileObject fob) {
        this.setLastRelatedFileObject(fob);
        this.update();
    }

    private void update() {
        if (EventQueue.isDispatchThread()) {
            PageModel pageModel = PageInspectorImpl.getDefault().getPage();
            FileObject lastRelatedFileObject = this.getLastRelatedFileObject();
            if (pageModel != null) {
                this.removeAll();
                PageModel.CSSStylesView stylesView = pageModel.getCSSStylesView();
                this.add((Component)stylesView.getView(), "Center");
                this.lookup.setView(pageModel.getCSSStylesView());
            } else {
                boolean runFilePanelShown;
                boolean noStylesLabelShown = this.noStylesLabel.getParent() != null;
                boolean bl = runFilePanelShown = this.runFilePanel.getParent() != null;
                if (lastRelatedFileObject == null ? !noStylesLabelShown : !runFilePanelShown) {
                    this.removeAll();
                    if (lastRelatedFileObject == null) {
                        this.add((Component)this.noStylesLabel, "Center");
                    } else {
                        this.add((Component)this.runFilePanel, "Center");
                    }
                }
                if (lastRelatedFileObject != null) {
                    String text = NbBundle.getMessage(CssStylesPanelProviderImpl.class, (String)"CssStylesPanelProviderImpl.runFileButton", (Object)lastRelatedFileObject.getNameExt());
                    this.runButton.setText(text);
                    boolean enabled = false;
                    ActionProvider provider = CssStylesPanelProviderImpl.actionProviderForFileObject(lastRelatedFileObject);
                    if (provider != null && Arrays.asList(provider.getSupportedActions()).contains("run.single")) {
                        Lookup context = CssStylesPanelProviderImpl.contextForFileObject(lastRelatedFileObject);
                        enabled = provider.isActionEnabled("run.single", context);
                    }
                    this.runButton.setEnabled(enabled);
                }
                this.lookup.setView(null);
            }
            this.revalidate();
            this.repaint();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CssStylesPanelProviderImpl.this.update();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastRelatedFileObject(FileObject fob) {
        CssStylesPanelProviderImpl cssStylesPanelProviderImpl = this;
        synchronized (cssStylesPanelProviderImpl) {
            this.lastRelatedFOB = fob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileObject getLastRelatedFileObject() {
        CssStylesPanelProviderImpl cssStylesPanelProviderImpl = this;
        synchronized (cssStylesPanelProviderImpl) {
            return this.lastRelatedFOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInspectedFileObject(FileObject fob) {
        CssStylesPanelProviderImpl cssStylesPanelProviderImpl = this;
        synchronized (cssStylesPanelProviderImpl) {
            this.inspectedFOB = fob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileObject getInspectedFileObject() {
        CssStylesPanelProviderImpl cssStylesPanelProviderImpl = this;
        synchronized (cssStylesPanelProviderImpl) {
            return this.inspectedFOB;
        }
    }

    void activateView() {
        this.active = true;
        if (this.currentPageModel == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TopComponent tc = WindowManager.getDefault().findTopComponent("CssStylesTC");
                    ((CssStylesTC)tc).setTitle(null);
                }
            });
        } else {
            this.currentPageModel.getCSSStylesView().activated();
        }
    }

    void deactivateView() {
        this.active = false;
        if (this.currentPageModel != null) {
            this.currentPageModel.getCSSStylesView().deactivated();
        }
    }

    private PropertyChangeListener createInspectorListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("model".equals(propName)) {
                    PageModel pageModel = PageInspectorImpl.getDefault().getPage();
                    CssStylesPanelProviderImpl.this.update(pageModel);
                }
            }
        };
    }

    private void update(final PageModel pageModel) {
        this.currentPageModel = pageModel;
        if (EventQueue.isDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CssStylesPanelProviderImpl.this.update(pageModel);
                }
            });
            return;
        }
        if (pageModel != null) {
            pageModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("document".equals(propName) && pageModel == CssStylesPanelProviderImpl.this.currentPageModel) {
                        CssStylesPanelProviderImpl.this.setInspectedFileObject(Utilities.inspectedFileObject(pageModel));
                        CssStylesPanelProviderImpl.this.update();
                    }
                }
            });
            this.setInspectedFileObject(Utilities.inspectedFileObject(pageModel));
            PageModel.CSSStylesView view = pageModel.getCSSStylesView();
            if (this.active) {
                view.activated();
            } else {
                view.deactivated();
            }
        }
        this.update();
    }

    private static ActionProvider actionProviderForFileObject(FileObject fileObject) {
        ActionProvider provider = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            Lookup lkp = project.getLookup();
            provider = (ActionProvider)lkp.lookup(ActionProvider.class);
        }
        return provider;
    }

    private static Lookup contextForFileObject(FileObject fileObject) {
        Lookup context;
        if (fileObject == null) {
            context = Lookup.EMPTY;
        } else {
            try {
                DataObject dob = DataObject.find((FileObject)fileObject);
                context = Lookups.fixed((Object[])new Object[]{fileObject, dob});
            }
            catch (DataObjectNotFoundException donfex) {
                context = Lookups.singleton((Object)fileObject);
            }
        }
        return context;
    }

    static class MatchedRulesLookup
    extends ProxyLookup {
        MatchedRulesLookup() {
        }

        void setView(PageModel.CSSStylesView view) {
            if (view == null) {
                this.setLookups(new Lookup[0]);
            } else {
                this.setLookups(new Lookup[]{view.getLookup()});
            }
        }
    }

    public static class WebCssStylesPanelListener
    implements CssStylesListener {
        public void ruleSelected(final RuleHandle handle) {
            final PageModel pageModel = PageInspectorImpl.getDefault().getPage();
            if (pageModel != null) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        FileObject file = Utilities.inspectedFileObject(pageModel);
                        if (file != null) {
                            try {
                                Source source = Source.create((FileObject)file);
                                if (source == null) {
                                    return;
                                }
                                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                                    public void run(ResultIterator resultIterator) throws Exception {
                                        CssParserResult result;
                                        Model model;
                                        Rule rule;
                                        ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                                        if (ri != null && (rule = handle.getRule(model = Model.getModel((CssParserResult)(result = (CssParserResult)ri.getParserResult())))) != null) {
                                            model.runReadTask(new Model.ModelTask(){

                                                public void run(StyleSheet styleSheet) {
                                                    final String elementSource = model.getElementSource((Element)rule.getSelectorsGroup()).toString();
                                                    RP.post(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            pageModel.setSelectedSelector(elementSource);
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                            catch (ParseException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            }
        }
    }

    public static class SelectionView
    extends CssStylesPanelProviderImpl {
        private static final String SELECTION_PANEL_ID = "selection";
        private Lookup lookup;
        private Lookup.Result<FileObject> result;
        private LookupListener listener;

        public String getPanelID() {
            return SELECTION_PANEL_ID;
        }

        public String getPanelDisplayName() {
            return Bundle.CTL_CssStylesProviderImpl_selection_view_title();
        }

        public JComponent getContent(Lookup lookup) {
            final Lookup.Result result = lookup.lookupResult(FileObject.class);
            this.lookup = lookup;
            this.result = result;
            this.listener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    this.update((Lookup.Result<FileObject>)result);
                }
            };
            result.addLookupListener(this.listener);
            this.update((Lookup.Result<FileObject>)result);
            return this;
        }

        void update(Lookup.Result<FileObject> result) {
            Collection fobs = result.allInstances();
            FileObject fob = null;
            if (!fobs.isEmpty()) {
                fob = (FileObject)fobs.iterator().next();
            }
            this.update(fob);
        }

        public Lookup getLookup() {
            return this.getMatchedRulesLookup();
        }

        public void activated() {
            this.activateView();
        }

        public void deactivated() {
            this.deactivateView();
        }

        public boolean providesContentFor(FileObject file) {
            return true;
        }
    }
}

