/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

public final class DBPrimaryKey
extends DBObject<DBTable> {
    private static final String RS_COLUMN_NAME = "COLUMN_NAME";
    private static final String RS_KEY_NAME = "PK_NAME";
    private static final String RS_KEY_SEQ = "KEY_SEQ";
    private List<String> columnNames;
    private String name;
    private DBTable parent;

    public DBPrimaryKey(ResultSet rs) throws SQLException {
        assert (rs != null);
        HashMap<Integer, String> pkColumns = new HashMap<Integer, String>();
        while (rs.next()) {
            short keySeq = rs.getShort(RS_KEY_SEQ);
            String columName = rs.getString(RS_COLUMN_NAME);
            pkColumns.put(Integer.valueOf(keySeq), columName);
            this.name = rs.getString(RS_COLUMN_NAME);
            String tmpName = rs.getString(RS_KEY_NAME);
            if (DataViewUtils.isNullString(tmpName) || this.name != null) continue;
            this.name = tmpName;
        }
        this.columnNames = new ArrayList<String>();
        ArrayList columnEntries = new ArrayList(pkColumns.keySet());
        Collections.sort(columnEntries);
        for (Integer id : columnEntries) {
            this.columnNames.add((String)pkColumns.get(id));
        }
    }

    public boolean contains(DBColumn col) {
        return this.contains(col.getName());
    }

    public boolean contains(String columnName) {
        return this.columnNames.contains(columnName);
    }

    public boolean equals(Object refObj) {
        boolean result;
        if (this == refObj) {
            return true;
        }
        if (!(refObj instanceof DBPrimaryKey)) {
            return false;
        }
        DBPrimaryKey ref = (DBPrimaryKey)refObj;
        boolean bl = this.getName() != null ? this.name.equals(ref.name) : (result = ref.name == null);
        return result &= this.columnNames != null ? this.columnNames.equals(ref.columnNames) : ref.columnNames != null;
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public String getName() {
        if (this.name == null && this.parent != null) {
            this.name = "PK_" + this.parent.getName();
        }
        return this.name;
    }

    public int hashCode() {
        int myHash = this.getName() != null ? this.name.hashCode() : 0;
        return myHash += this.columnNames != null ? this.columnNames.hashCode() : 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.columnNames.get(i).trim());
        }
        return buf.toString();
    }
}

