/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.rename;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.groovy.refactoring.DiffElement;
import org.netbeans.modules.groovy.refactoring.findusages.FindUsagesElement;
import org.netbeans.modules.groovy.refactoring.findusages.FindUsagesPlugin;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class RenameRefactoringPlugin
extends FindUsagesPlugin {
    public RenameRefactoringPlugin(FileObject fileObject, RefactoringElement element, AbstractRefactoring refactoring) {
        super(fileObject, element, refactoring);
    }

    public RenameRefactoring getRefactoring() {
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
        return (RenameRefactoring)this.refactoring;
    }

    @Override
    protected void refactorResults(RefactoringElementsBag elementsBag, List<FindUsagesElement> usages) {
        ModificationResult modificationResult = this.collectModifications(usages);
        elementsBag.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(modificationResult)));
        for (FileObject fo : modificationResult.getModifiedFileObjects()) {
            for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                elementsBag.add(this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modificationResult));
                fo.refresh();
            }
        }
    }

    private ModificationResult collectModifications(List<FindUsagesElement> usages) {
        ModificationResult modificationResult = new ModificationResult();
        for (FindUsagesElement whereUsedElement : usages) {
            this.addModificationToResult(modificationResult, whereUsedElement);
        }
        return modificationResult;
    }

    private void addModificationToResult(ModificationResult modificationResult, FindUsagesElement whereUsedElement) {
        if (this.isAlreadyInResult(modificationResult, whereUsedElement)) {
            return;
        }
        ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
        diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, whereUsedElement.getPosition().getBegin(), whereUsedElement.getPosition().getEnd(), whereUsedElement.getName(), this.getRefactoring().getNewName(), whereUsedElement.getDisplayText()));
        if (!diffs.isEmpty()) {
            modificationResult.addDifferences(whereUsedElement.getParentFile(), diffs);
        }
    }

    private boolean isAlreadyInResult(ModificationResult modificationResult, FindUsagesElement whereUsedElement) {
        assert (modificationResult != null);
        assert (whereUsedElement != null);
        FileObject file = whereUsedElement.getParentFile();
        PositionBounds position = whereUsedElement.getPosition();
        if (position == null) {
            return false;
        }
        int start = position.getBegin().getOffset();
        int end = position.getEnd().getOffset();
        List differences = modificationResult.getDifferences(file);
        if (differences != null && !differences.isEmpty()) {
            for (ModificationResult.Difference diff : differences) {
                int startOffset = diff.getStartPosition().getOffset();
                int endOffset = diff.getEndPosition().getOffset();
                if (startOffset != start || endOffset != end) continue;
                return true;
            }
        }
        return false;
    }
}

