/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinitionKind;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.impl.ClassItemFactory;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.ImportDecl;
import org.netbeans.spi.editor.completion.CompletionItem;

public final class ClassCompleter
implements Completer,
Completer.Factory {
    private static final Logger LOG = Logger.getLogger(ClassCompleter.class.getName());
    private static final int IMPORTED_PRIORITY = 50;
    private static final int NODE_PRIORITY = 100;
    private static final int OTHER_PRIORITY = 200;
    private static final int PACKAGE_PRIORITY = 150;
    private static final int PREFIX_TRESHOLD = 3;
    private boolean moreItems;
    private String packagePrefix;
    private String namePrefix;
    private final CompletionContext ctx;
    private Set<ElementHandle<TypeElement>> namedTypes;
    private TypeMirror propertyType;
    private boolean propertyTypeResolved;
    private static final Comparator<ElementHandle<TypeElement>> CLASS_SORTER = new Comparator<ElementHandle<TypeElement>>(){

        @Override
        public int compare(ElementHandle<TypeElement> o1, ElementHandle<TypeElement> o2) {
            int dot2;
            String sn2;
            String fn1 = o1.getQualifiedName();
            String fn2 = o2.getQualifiedName();
            int dot1 = fn1.lastIndexOf(46);
            String sn1 = dot1 == -1 ? fn1 : fn1.substring(dot1 + 1);
            int diff = sn1.compareToIgnoreCase(sn2 = (dot2 = fn2.lastIndexOf(46)) == -1 ? fn2 : fn2.substring(dot2 + 1));
            if (diff != 0) {
                return diff;
            }
            return fn1.compareToIgnoreCase(fn2);
        }
    };
    private static final Comparator<ElementHandle<TypeElement>> FQN_SORTER = new Comparator<ElementHandle<TypeElement>>(){

        @Override
        public int compare(ElementHandle<TypeElement> o1, ElementHandle<TypeElement> o2) {
            String fn1 = o1.getQualifiedName();
            String fn2 = o2.getQualifiedName();
            return fn1.compareToIgnoreCase(fn2);
        }
    };

    public ClassCompleter() {
        this.ctx = null;
    }

    private ClassCompleter(CompletionContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public boolean hasMoreItems() {
        return this.moreItems;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        FxNode parent = ctx.getElementParent();
        FxProperty pi = ctx.getEnclosingProperty();
        if (pi == null && parent.getKind() != FxNode.Kind.Source) {
            return null;
        }
        if (ctx.getType() == CompletionContext.Type.BEAN || ctx.getType() == CompletionContext.Type.ROOT || ctx.getType() == CompletionContext.Type.CHILD_ELEMENT || ctx.getType() == CompletionContext.Type.PROPERTY_ELEMENT) {
            if (pi == null || pi.getKind() == FxDefinitionKind.LIST) {
                return new ClassCompleter(ctx);
            }
            if (ctx.getPrefix().startsWith("<") || ctx.getCompletionType() == 9) {
                return new ClassCompleter(ctx);
            }
        }
        return null;
    }

    private boolean acceptsQName(CharSequence fullName, CharSequence name) {
        if (this.packagePrefix != null && fullName.length() > name.length() && !CompletionUtils.startsWith(fullName.subSequence(0, fullName.length() - name.length() - 1), this.packagePrefix)) {
            return false;
        }
        return this.acceptsName(name);
    }

    private boolean acceptsName(CharSequence name) {
        return this.namePrefix.isEmpty() || CompletionUtils.startsWith(name, this.namePrefix);
    }

    private TypeMirror getPropertyType() {
        TypeElement e;
        int minDepth;
        if (this.propertyTypeResolved) {
            return this.propertyType;
        }
        FxProperty prop = this.ctx.getEnclosingProperty();
        int n = minDepth = this.ctx.getPrefix().length() > 1 ? 2 : 1;
        if (prop != null) {
            TypeMirrorHandle propTypeH = prop.getType();
            if (propTypeH != null) {
                this.propertyType = propTypeH.resolve(this.ctx.getCompilationInfo());
            }
        } else if (this.ctx.getParents().size() <= minDepth && (e = this.ctx.getCompilationInfo().getElements().getTypeElement("javafx.scene.Node")) != null) {
            this.propertyType = e.asType();
        }
        this.propertyTypeResolved = true;
        return this.propertyType;
    }

    private boolean acceptsType(TypeElement t) {
        if (t.getModifiers().contains((Object)Modifier.ABSTRACT) || !FxClassUtils.isFxmlAccessible(t)) {
            return false;
        }
        TypeMirror pt = this.getPropertyType();
        if (pt == null) {
            return true;
        }
        return this.ctx.getCompilationInfo().getTypes().isAssignable(t.asType(), pt);
    }

    private Set<ElementHandle<TypeElement>> loadImportedClasses() {
        HashSet<ElementHandle<TypeElement>> handles = new HashSet<ElementHandle<TypeElement>>();
        List<ImportDecl> imports = this.ctx.getModel().getImports();
        for (ImportDecl decl : imports) {
            TypeElement el;
            if (decl.isWildcard()) {
                if (this.packagePrefix != null && !CompletionUtils.startsWith(decl.getImportedName(), this.namePrefix)) continue;
                PackageElement pel = this.ctx.getCompilationInfo().getElements().getPackageElement(decl.getImportedName());
                for (Element element : pel.getEnclosedElements()) {
                    TypeElement tel = (TypeElement)element;
                    if (!this.acceptsName(tel.getSimpleName()) || !this.acceptsType(tel)) continue;
                    handles.add((ElementHandle<TypeElement>)ElementHandle.create((Element)((TypeElement)element)));
                }
                continue;
            }
            if (!CompletionUtils.startsWithCamelCase(decl.getImportedName(), this.namePrefix) || (el = this.ctx.getCompilationInfo().getElements().getTypeElement(decl.getImportedName())) == null || !this.acceptsType(el)) continue;
            handles.add((ElementHandle<TypeElement>)ElementHandle.create((Element)el));
        }
        return handles;
    }

    private TypeElement getBaseClass() {
        TypeElement baseClass = null;
        if (this.getPropertyType() != null) {
            baseClass = (TypeElement)this.ctx.getCompilationInfo().getTypes().asElement(this.getPropertyType());
        }
        if (baseClass == null) {
            baseClass = this.ctx.getCompilationInfo().getElements().getTypeElement("javafx.scene.Node");
        }
        return baseClass;
    }

    Set<ElementHandle<TypeElement>> loadDescenantsOfNode() {
        if (this.namePrefix.length() < 3) {
            return this.loadDescenantsOfNode2();
        }
        TypeElement baseClass = this.getBaseClass();
        if (baseClass == null) {
            return Collections.emptySet();
        }
        HashSet<ElementHandle<TypeElement>> handles = new HashSet<ElementHandle<TypeElement>>();
        Set els = this.ctx.getClasspathInfo().getClassIndex().getDeclaredTypes(this.namePrefix, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES, ClassIndex.SearchScope.SOURCE));
        TypeMirror nodeType = baseClass.asType();
        for (ElementHandle h : els) {
            TypeElement e = (TypeElement)h.resolve(this.ctx.getCompilationInfo());
            if (e == null || !this.acceptsQName(e.getQualifiedName(), e.getSimpleName()) || e.getModifiers().contains((Object)Modifier.ABSTRACT) || !FxClassUtils.isFxmlAccessible(e) || !this.ctx.getCompilationInfo().getTypes().isAssignable(e.asType(), nodeType)) continue;
            handles.add((ElementHandle<TypeElement>)h);
        }
        return handles;
    }

    Set<ElementHandle<TypeElement>> loadDescenantsOfNode2() {
        TypeElement baseClass = this.getBaseClass();
        if (baseClass == null) {
            LOG.warning("javafx.scene.Node class not fond");
            return Collections.emptySet();
        }
        ClasspathInfo info = this.ctx.getClasspathInfo();
        ElementHandle nodeHandle = ElementHandle.create((Element)baseClass);
        HashSet<Object> allTypesSeen = new HashSet<Object>();
        LinkedList<Object> handles = new LinkedList<Object>();
        handles.add(nodeHandle);
        long time = System.currentTimeMillis();
        allTypesSeen.add(nodeHandle);
        while (!handles.isEmpty()) {
            ElementHandle baseHandle = (ElementHandle)handles.poll();
            LOG.log(Level.FINE, "Loading descendants of {0}", baseHandle);
            HashSet descendants = new HashSet(info.getClassIndex().getElements(baseHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES, ClassIndex.SearchScope.SOURCE)));
            descendants.removeAll(allTypesSeen);
            allTypesSeen.addAll(descendants);
            handles.addAll(descendants);
            LOG.log(Level.FINE, "Unique descendants: {0}", descendants);
        }
        long diff = System.currentTimeMillis();
        LOG.log(Level.FINE, "Loading Node descendants took: {0}ms", diff);
        HashSet<ElementHandle<TypeElement>> result = new HashSet<ElementHandle<TypeElement>>();
        for (ElementHandle elementHandle : allTypesSeen) {
            int lastDot;
            String n;
            if (elementHandle.getKind() != ElementKind.CLASS && elementHandle.getKind() != ElementKind.INTERFACE || (n = elementHandle.getQualifiedName()).length() < this.namePrefix.length() || (lastDot = n.lastIndexOf(46)) != -1 && this.packagePrefix != null && (lastDot < this.packagePrefix.length() || !n.startsWith(this.packagePrefix)) || !CompletionUtils.startsWith(n.substring(lastDot + 1), this.namePrefix)) continue;
            result.add((ElementHandle<TypeElement>)elementHandle);
        }
        return result;
    }

    private Set<ElementHandle<TypeElement>> loadFromAllTypes() {
        ClasspathInfo info = this.ctx.getClasspathInfo();
        HashSet<ElementHandle<TypeElement>> els = new HashSet<ElementHandle<TypeElement>>(info.getClassIndex().getDeclaredTypes(this.namePrefix, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES, ClassIndex.SearchScope.SOURCE)));
        TypeMirror pt = this.getPropertyType();
        if (pt == null) {
            return els;
        }
        Iterator it = els.iterator();
        while (it.hasNext()) {
            TypeElement t;
            String qn;
            ElementHandle teh = (ElementHandle)it.next();
            int lastDot = (qn = teh.getQualifiedName()).lastIndexOf(46);
            String sn = lastDot == -1 ? qn : qn.substring(lastDot + 1);
            if (!this.acceptsQName(qn, sn) || (t = (TypeElement)teh.resolve(this.ctx.getCompilationInfo())) != null && this.acceptsType(t)) continue;
            it.remove();
        }
        return els;
    }

    private CompletionItem createItem(ElementHandle<TypeElement> handle, int priority) {
        ClassItemFactory converter;
        TypeElement el = (TypeElement)handle.resolve(this.ctx.getCompilationInfo());
        if (el == null) {
            return null;
        }
        if (el.getKind() != ElementKind.CLASS && el.getKind() != ElementKind.ENUM) {
            return null;
        }
        if (!el.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        CompletionItem item = null;
        Collection converters = MimeLookup.getLookup((String)"text/x-fxml+xml").lookupAll(ClassItemFactory.class);
        Iterator iterator = converters.iterator();
        while (iterator.hasNext() && (item = (converter = (ClassItemFactory)iterator.next()).convert(el, this.ctx, priority)) == null) {
        }
        return item;
    }

    private List<CompletionItem> createItems(Collection<? extends ElementHandle<TypeElement>> elems, int priority) {
        ArrayList<? extends ElementHandle<TypeElement>> sorted = new ArrayList<ElementHandle<TypeElement>>(elems);
        Collections.sort(sorted, CLASS_SORTER);
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        for (ElementHandle elementHandle : sorted) {
            CompletionItem item = this.createItem((ElementHandle<TypeElement>)elementHandle, priority);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    private boolean isPrefixEmpty() {
        return this.namePrefix.isEmpty() && this.packagePrefix == null;
    }

    public List<CompletionItem> complete() {
        TypeMirror tm;
        int dot;
        this.namePrefix = this.ctx.getPrefix();
        if (this.namePrefix.startsWith("<")) {
            this.namePrefix = this.namePrefix.substring(1);
        }
        if ((dot = this.namePrefix.indexOf(46)) != -1) {
            this.packagePrefix = this.namePrefix.substring(0, dot);
            this.namePrefix = this.namePrefix.substring(dot + 1);
        }
        if ((tm = this.getPropertyType()) != null && tm.getKind() != TypeKind.DECLARED) {
            return null;
        }
        if (this.ctx.getCompletionType() == 1) {
            Set<ElementHandle<TypeElement>> handles = this.loadImportedClasses();
            List<CompletionItem> items = this.createItems(handles, 50);
            if (!items.isEmpty()) {
                this.moreItems = true;
                return items;
            }
        } else if (this.ctx.getCompletionType() != 9) {
            return null;
        }
        Set<ElementHandle<TypeElement>> nodeCandidates = this.loadDescenantsOfNode();
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.addAll(this.createItems(nodeCandidates, 100));
        if (!this.namePrefix.isEmpty()) {
            HashSet<ElementHandle<TypeElement>> allCandidates = new HashSet<ElementHandle<TypeElement>>(this.loadFromAllTypes());
            allCandidates.removeAll(nodeCandidates);
            items.addAll(this.createItems(allCandidates, 200));
        }
        return items;
    }
}

